/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.sql.SQLException;
import org.apache.derby.iapi.db.OptimizerTrace;
import org.apache.derby.iapi.services.context.Context;
import org.apache.derby.iapi.services.context.ContextService;
import org.apache.derby.iapi.services.loader.ClassFactory;
import org.apache.derby.iapi.services.loader.ClassFactoryContext;
import org.apache.derby.iapi.sql.compile.OptTrace;
import org.apache.derby.iapi.sql.dictionary.OptionalTool;
import org.apache.derby.impl.sql.compile.DefaultOptTrace;
import org.apache.derby.impl.sql.compile.XMLOptTrace;
import org.apache.derby.shared.common.error.PublicAPI;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.i18n.MessageService;

public class OptimizerTracer
implements OptionalTool {
    @Override
    public void loadTool(String ... configurationParameters) throws SQLException {
        OptTrace tracer;
        if (configurationParameters == null || configurationParameters.length == 0) {
            tracer = new DefaultOptTrace();
        } else if ("xml".equals(configurationParameters[0])) {
            try {
                tracer = new XMLOptTrace();
            }
            catch (Throwable t) {
                throw this.wrap(t);
            }
        } else if ("custom".equals(configurationParameters[0])) {
            if (configurationParameters.length != 2) {
                throw this.wrap(MessageService.getTextMessage("X0Y89.S", new Object[0]));
            }
            String customOptTraceName = configurationParameters[1];
            try {
                ClassFactoryContext cfc = (ClassFactoryContext)OptimizerTracer.getContext("ClassFactoryContext");
                ClassFactory classFactory = cfc.getClassFactory();
                Class clazz = classFactory.loadApplicationClass(customOptTraceName);
                tracer = (OptTrace)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (InstantiationException cnfe) {
                throw this.cantInstantiate(customOptTraceName);
            }
            catch (ClassNotFoundException cnfe) {
                throw this.cantInstantiate(customOptTraceName);
            }
            catch (IllegalAccessException cnfe) {
                throw this.cantInstantiate(customOptTraceName);
            }
            catch (NoSuchMethodException cnfe) {
                throw this.cantInstantiate(customOptTraceName);
            }
            catch (InvocationTargetException cnfe) {
                throw this.cantInstantiate(customOptTraceName);
            }
            catch (Throwable t) {
                throw this.wrap(t);
            }
        } else {
            throw this.wrap(MessageService.getTextMessage("X0Y89.S", new Object[0]));
        }
        OptimizerTrace.setOptimizerTracer(tracer);
    }

    private SQLException cantInstantiate(String className) {
        return this.wrap(MessageService.getTextMessage("X0Y90.S", className));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unloadTool(String ... configurationParameters) throws SQLException {
        try {
            PrintWriter pw;
            OptTrace tracer = OptimizerTrace.getOptimizerTracer();
            boolean needsClosing = false;
            if (configurationParameters != null && configurationParameters.length > 0) {
                try {
                    String fileName = configurationParameters[0];
                    File outputFile = new File(fileName);
                    if (outputFile.exists()) {
                        throw PublicAPI.wrapStandardException(StandardException.newException("XIE0S.S", fileName));
                    }
                    pw = new PrintWriter(outputFile);
                }
                catch (IOException ioe) {
                    throw this.wrap(new IllegalArgumentException(ioe.getMessage(), ioe));
                }
                needsClosing = true;
            } else {
                pw = new PrintWriter(System.out);
            }
            if (tracer != null) {
                tracer.printToWriter(pw);
                pw.flush();
            }
            if (needsClosing) {
                pw.close();
            }
        }
        finally {
            OptimizerTrace.setOptimizerTracer(null);
        }
    }

    private SQLException wrap(Throwable t) {
        return new SQLException(t.getMessage(), t);
    }

    private SQLException wrap(String errorMessage) {
        String sqlState = "XJ001.U".substring(0, 5);
        return new SQLException(errorMessage, sqlState);
    }

    private static Context getContext(String contextID) {
        return ContextService.getContext(contextID);
    }
}

