/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.blackbox.java;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtOperationalModuleEnv;
import org.eclipse.m2m.internal.qvt.oml.blackbox.java.DiagnosticUtil;
import org.eclipse.m2m.internal.qvt.oml.blackbox.java.Java2QVTTypeResolver;
import org.eclipse.m2m.internal.qvt.oml.blackbox.java.JavaBlackboxMessages;
import org.eclipse.m2m.internal.qvt.oml.expressions.DirectionKind;
import org.eclipse.m2m.internal.qvt.oml.expressions.ExpressionsFactory;
import org.eclipse.m2m.internal.qvt.oml.expressions.Helper;
import org.eclipse.m2m.internal.qvt.oml.expressions.ImperativeOperation;
import org.eclipse.m2m.internal.qvt.oml.expressions.VarParameter;
import org.eclipse.m2m.qvt.oml.blackbox.java.Operation;
import org.eclipse.m2m.qvt.oml.blackbox.java.Parameter;
import org.eclipse.osgi.util.NLS;

class OperationBuilder {
    private Java2QVTTypeResolver fTypeResolver;
    private BasicDiagnostic fProblems;

    OperationBuilder(Java2QVTTypeResolver typeResolver) {
        this.fTypeResolver = typeResolver;
    }

    public EOperation buildOperation(Method javaMethod) {
        this.resetErrors();
        return this.createOperation(javaMethod);
    }

    public Diagnostic getDiagnostics() {
        return this.fProblems != null ? this.fProblems : Diagnostic.OK_INSTANCE;
    }

    private EOperation createOperation(Method method) {
        EOperation operation;
        Operation.Kind operKind;
        boolean isContextual;
        EClassifier contextType = null;
        String name = method.getName();
        Type resultType = method.getGenericReturnType();
        Type[] paramTypes = method.getGenericParameterTypes();
        Annotation[][] annotations = method.getParameterAnnotations();
        Operation operAnnotation = method.getAnnotation(Operation.class);
        boolean bl = isContextual = operAnnotation != null && operAnnotation.contextual();
        if (isContextual && paramTypes.length == 0) {
            this.reportError(NLS.bind((String)JavaBlackboxMessages.FirstContextualOperationParameterRequired, (Object)method), method);
        }
        Operation.Kind kind = operKind = operAnnotation != null ? operAnnotation.kind() : Operation.Kind.OPERATION;
        if (operKind == Operation.Kind.OPERATION) {
            operKind = Operation.Kind.HELPER;
        }
        if (operKind == Operation.Kind.OPERATION) {
            operation = EcoreFactory.eINSTANCE.createEOperation();
        } else if (operKind == Operation.Kind.QUERY || operKind == Operation.Kind.HELPER) {
            Helper helper = ExpressionsFactory.eINSTANCE.createHelper();
            helper.setIsQuery(operKind == Operation.Kind.QUERY);
            operation = helper;
        } else {
            assert (false) : "unsupported operation kind";
            operation = EcoreFactory.eINSTANCE.createEOperation();
        }
        operation.setName(name);
        operation.setEType(this.fTypeResolver.toEClassifier(resultType));
        if (operation.getEType() == null) {
            this.reportError(NLS.bind((String)JavaBlackboxMessages.UnresolvedOclTypeForJavaType, method.getReturnType(), (Object)method), method);
        }
        int i = 0;
        QvtOperationalModuleEnv environment = this.fTypeResolver.getEnvironment();
        Type[] typeArray = paramTypes;
        int n = paramTypes.length;
        int n2 = 0;
        while (n2 < n) {
            Parameter paramAnno;
            VarParameter eParameter;
            Type paramType = typeArray[n2];
            VarParameter varParam = operKind != Operation.Kind.OPERATION ? ExpressionsFactory.eINSTANCE.createVarParameter() : null;
            VarParameter varParameter = eParameter = varParam != null ? varParam : EcoreFactory.eINSTANCE.createEParameter();
            if (varParam != null) {
                varParam.setKind(DirectionKind.IN);
            }
            eParameter.setEType(this.fTypeResolver.toEClassifier(paramType));
            if (eParameter.getEType() == null) {
                this.reportError(NLS.bind((String)JavaBlackboxMessages.UnresolvedOclTypeForJavaType, (Object)paramType, (Object)method), method);
            }
            String paramName = (paramAnno = OperationBuilder.getParameterAnnotation(annotations[i])) != null && paramAnno.name() != null ? paramAnno.name() : "arg" + i;
            eParameter.setName(paramName);
            if (isContextual && i == 0) {
                if (operKind != Operation.Kind.OPERATION) {
                    assert (operation instanceof ImperativeOperation);
                    assert (varParam != null);
                    varParam.setName("self");
                    ((ImperativeOperation)operation).setContext(varParam);
                }
                contextType = eParameter.getEType();
            } else {
                operation.getEParameters().add((Object)eParameter);
            }
            ++i;
            ++n2;
        }
        if (operation instanceof ImperativeOperation) {
            ImperativeOperation imperativeOperation = (ImperativeOperation)operation;
            environment.defineImperativeOperation(imperativeOperation, false, true);
        } else if (contextType != null) {
            environment.getTypeResolver().resolveAdditionalOperation(contextType, operation);
        }
        return operation;
    }

    private static Parameter getParameterAnnotation(Annotation[] allAnnotations) {
        Annotation[] annotationArray = allAnnotations;
        int n = allAnnotations.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation annotation = annotationArray[n2];
            if (annotation.annotationType() == Parameter.class) {
                return (Parameter)annotation;
            }
            ++n2;
        }
        return null;
    }

    private void resetErrors() {
        this.fProblems = null;
    }

    private void reportError(String message, Method problemMethod) {
        if (this.fProblems == null) {
            this.fProblems = DiagnosticUtil.createRootDiagnostic(NLS.bind((String)JavaBlackboxMessages.LoadOperationDiagnostics, (Object)problemMethod));
        }
        this.fProblems.add((Diagnostic)DiagnosticUtil.createErrorDiagnostic(message));
    }
}

