/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.runtime.launch;

import java.io.PrintWriter;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.IStatusHandler;
import org.eclipse.debug.core.model.IStreamsProxy;
import org.eclipse.m2m.internal.qvt.oml.QvtPlugin;
import org.eclipse.m2m.internal.qvt.oml.common.launch.BaseProcess;
import org.eclipse.m2m.internal.qvt.oml.common.launch.ShallowProcess;
import org.eclipse.m2m.internal.qvt.oml.common.launch.StreamsProxy;
import org.eclipse.m2m.internal.qvt.oml.evaluator.EvaluationMonitor;
import org.eclipse.m2m.internal.qvt.oml.evaluator.QvtRuntimeException;
import org.eclipse.m2m.internal.qvt.oml.library.Context;
import org.eclipse.m2m.internal.qvt.oml.library.IContext;
import org.eclipse.m2m.internal.qvt.oml.runtime.launch.QvtLaunchConfigurationDelegateBase;
import org.eclipse.m2m.internal.qvt.oml.runtime.launch.QvtLaunchUtil;
import org.eclipse.m2m.internal.qvt.oml.runtime.project.QvtInterpretedTransformation;
import org.eclipse.m2m.internal.qvt.oml.runtime.util.MiscUtil;

public class QvtLaunchConfigurationDelegate
extends QvtLaunchConfigurationDelegateBase {
    public static final int LAUNCH_ERROR_CODE = 210;
    public static final IStatus fgLaunchErrorStatus = new Status(4, "org.eclipse.m2m.qvt.oml.runtime", 210, "Launch configuration error", null);

    public void launch(final ILaunchConfiguration configuration, String mode, final ILaunch launch, IProgressMonitor monitor) throws CoreException {
        try {
            final QvtInterpretedTransformation qvtTransformation = new QvtInterpretedTransformation(QvtLaunchConfigurationDelegate.getQvtModule(configuration));
            final EvaluationMonitor execMonitor = this.createMonitor();
            StreamsProxy streamsProxy = new StreamsProxy();
            final PrintWriter printWriter = new PrintWriter(streamsProxy.getOutputWriter());
            BaseProcess.IRunnable r = new BaseProcess.IRunnable(){

                public void run() throws Exception {
                    IStatus status = QvtLaunchConfigurationDelegateBase.validate(qvtTransformation, configuration);
                    if (status.getSeverity() > 2) {
                        throw new CoreException(status);
                    }
                    Context context = new Context(QvtLaunchUtil.getConfiguration(configuration));
                    context.put("@out_print_writer", (Object)printWriter);
                    context.put("org.eclipse.m2m.internal.qvt.oml.evaluator.EvaluationMonitor", (Object)execMonitor);
                    QvtLaunchConfigurationDelegateBase.doLaunch(qvtTransformation, configuration, (IContext)context);
                    qvtTransformation.cleanup();
                }
            };
            r = QvtLaunchConfigurationDelegate.getSafeRunnable(qvtTransformation, r);
            final ShallowProcess process = new ShallowProcess(launch, r){
                boolean isTerminated;
                {
                    super($anonymous0, $anonymous1);
                    this.isTerminated = false;
                }

                public void terminate() throws DebugException {
                    execMonitor.cancel();
                    this.isTerminated = true;
                    super.terminate();
                }

                public boolean isTerminated() {
                    return this.isTerminated || super.isTerminated();
                }

                public boolean canTerminate() {
                    return !this.isTerminated();
                }
            };
            process.setStreamsProxy((IStreamsProxy)streamsProxy);
            Thread processThread = new Thread(new Runnable(){

                public void run() {
                    block7: {
                        try {
                            process.run();
                        }
                        catch (Exception e) {
                            if (e instanceof QvtRuntimeException) break block7;
                            IStatusHandler statusHandler = DebugPlugin.getDefault().getStatusHandler(fgLaunchErrorStatus);
                            if (statusHandler != null) {
                                Status actualStatus = new Status(4, "org.eclipse.m2m.qvt.oml.runtime", 210, e.getMessage(), (Throwable)(e.getMessage() == null ? e : null));
                                try {
                                    statusHandler.handleStatus((IStatus)actualStatus, (Object)configuration);
                                }
                                catch (CoreException coreExc) {
                                    QvtPlugin.log((Throwable)coreExc);
                                }
                            }
                            QvtPlugin.log((Throwable)e);
                        }
                    }
                    try {
                        launch.terminate();
                    }
                    catch (DebugException e) {
                        QvtPlugin.log((Throwable)e);
                    }
                }
            }, "QVT Run");
            processThread.start();
        }
        catch (Exception e) {
            throw new CoreException(MiscUtil.makeErrorStatus(e));
        }
    }

    private EvaluationMonitor createMonitor() {
        return new EvaluationMonitor(){
            boolean fIsCanceled = false;

            public void cancel() {
                this.fIsCanceled = true;
            }

            public boolean isCanceled() {
                return this.fIsCanceled;
            }
        };
    }

    protected boolean existsProblems(IProject proj) throws CoreException {
        IMarker[] markers = proj.findMarkers("org.eclipse.m2m.qvt.oml.qvtProblem", true, 2);
        int i = 0;
        while (i < markers.length) {
            if (this.isLaunchProblem(markers[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

