/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.evaluator;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.m2m.internal.qvt.oml.ast.binding.ASTBindingHelper;
import org.eclipse.m2m.internal.qvt.oml.ast.binding.IModuleSourceInfo;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtOperationalEvaluationEnv;
import org.eclipse.m2m.internal.qvt.oml.ast.parser.QvtOperationalParserUtil;
import org.eclipse.m2m.internal.qvt.oml.expressions.ImperativeOperation;
import org.eclipse.m2m.internal.qvt.oml.expressions.Module;
import org.eclipse.ocl.ecore.CallOperationAction;
import org.eclipse.ocl.ecore.Constraint;
import org.eclipse.ocl.ecore.SendSignalAction;
import org.eclipse.ocl.utilities.ASTNode;
import org.eclipse.ocl.utilities.UMLReflection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QvtStackTraceBuilder {
    private static final String UNKNOWN_NAME = "<Unknown>";
    private static final String INITIALIZER_NAME = "<init>";
    private static final int UNKNOWN_LINE_NUM = -1;
    private QvtOperationalEvaluationEnv fEnv;
    private Module fMainModule;
    private int fOffset;
    private UMLReflection<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint> fUML;

    public QvtStackTraceBuilder(QvtOperationalEvaluationEnv env, UMLReflection<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint> uml, Module mainModule, int astNodeIPOffset) {
        if (env == null || uml == null) {
            throw new IllegalArgumentException();
        }
        this.fEnv = env;
        this.fUML = uml;
        this.fOffset = astNodeIPOffset;
        this.fMainModule = mainModule;
    }

    public List<StackTraceElement> buildStackTrace() {
        LinkedList<StackTraceElement> elements = new LinkedList<StackTraceElement>();
        int pos = 0;
        QvtOperationalEvaluationEnv nextEnv = this.fEnv;
        while (nextEnv != null) {
            elements.add(this.createStackElement(nextEnv, pos++));
            nextEnv = nextEnv.getParent();
        }
        return Collections.unmodifiableList(elements);
    }

    private StackTraceElement createStackElement(QvtOperationalEvaluationEnv env, int stackPos) {
        IModuleSourceInfo sourceInfo;
        boolean isMainEnv = env.getParent() == null;
        String fileName = null;
        String declClassName = UNKNOWN_NAME;
        String operName = UNKNOWN_NAME;
        int lineNumber = -1;
        Module module = null;
        int resultOffset = this.fOffset;
        EOperation operation = env.getOperation();
        if (isMainEnv) {
            operName = INITIALIZER_NAME;
            module = this.fMainModule;
            if (module != null && module.getName() != null) {
                declClassName = module.getName();
            }
            if ((resultOffset = env.getCurrentASTOffset()) < 0 && this.fMainModule.getEntry() instanceof ASTNode) {
                resultOffset = ((ASTNode)this.fMainModule.getEntry()).getStartPosition();
            }
        } else if (operation != null) {
            EClassifier owner;
            if (operation.getName() != null) {
                operName = operation.getName();
            }
            if (operation instanceof ImperativeOperation) {
                module = QvtOperationalParserUtil.getOwningModule((ImperativeOperation)operation);
            }
            if ((owner = (EClassifier)this.fUML.getOwningClassifier((Object)operation)) == null && operation.getEContainingClass() != null) {
                owner = operation.getEContainingClass();
            }
            if (owner != null) {
                declClassName = this.fUML.getName((Object)owner);
            }
            int n = resultOffset = stackPos == 0 ? this.fOffset : env.getCurrentASTOffset();
        }
        if (module != null && (sourceInfo = ASTBindingHelper.getModuleSourceBinding(module)) != null) {
            fileName = sourceInfo.getFileName();
            if (resultOffset >= 0) {
                lineNumber = sourceInfo.getLineNumberProvider().getLineNumber(resultOffset);
            }
        }
        return new StackTraceElement(declClassName, operName, fileName, lineNumber);
    }
}

