/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner;

import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.utilities.Nameable;
import org.eclipse.qvtd.compiler.internal.qvtm2qvts.QVTm2QVTs;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.AbstractSimplePartitionFactory;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.BasicPartitionAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.MappingPartitioner;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.PartitionedTransformationAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.utilities.ReachabilityForest;
import org.eclipse.qvtd.pivot.qvtschedule.BasicPartition;
import org.eclipse.qvtd.pivot.qvtschedule.Edge;
import org.eclipse.qvtd.pivot.qvtschedule.Node;
import org.eclipse.qvtd.pivot.qvtschedule.Role;
import org.eclipse.qvtd.pivot.qvtschedule.RuleRegion;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.Graphable;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.QVTscheduleUtil;

public class AssignmentPartitionFactory
extends AbstractSimplePartitionFactory {
    protected final @NonNull Edge realizedEdge;

    public AssignmentPartitionFactory(@NonNull MappingPartitioner mappingPartitioner, @NonNull Edge realizedEdge) {
        super(mappingPartitioner);
        this.realizedEdge = realizedEdge;
    }

    @Override
    public @NonNull BasicPartitionAnalysis createPartitionAnalysis(@NonNull PartitionedTransformationAnalysis partitionedTransformationAnalysis) {
        ReachabilityForest reachabilityForest = this.createReachabilityForest();
        int partitionNumber = ((RuleRegion)this.region).getNextPartitionNumber();
        String name = this.computeName("edge" + partitionNumber + "-" + QVTscheduleUtil.getName((Nameable)this.realizedEdge));
        List<@NonNull Node> headNodes = this.mappingPartitioner.getTraceNodes();
        BasicPartition partition = this.createBasicPartition(name, headNodes);
        String namePrefix = "\u00abedge" + partitionNumber + "\u00bb";
        String symbolSuffix = "_p" + partitionNumber;
        BasicPartitionAnalysis basicPartitionAnalysis = new BasicPartitionAnalysis(partitionedTransformationAnalysis, partition, reachabilityForest, namePrefix, symbolSuffix);
        this.initializePartition(basicPartitionAnalysis);
        if (QVTm2QVTs.DEBUG_GRAPHS.isActive()) {
            this.scheduleManager.writeDebugGraphs((Graphable)partition, null);
        }
        return basicPartitionAnalysis;
    }

    protected void initializePartition(@NonNull BasicPartitionAnalysis partitionAnalysis) {
        Node targetNode;
        BasicPartition partition = (BasicPartition)partitionAnalysis.getPartition();
        for (Node traceNode : this.mappingPartitioner.getTraceNodes()) {
            Node globalSuccessNode;
            this.addNode(partition, traceNode, Role.PREDICATED);
            Node localSuccessNode = this.mappingPartitioner.basicGetLocalSuccessNode(traceNode);
            if (localSuccessNode != null) {
                this.addNode(partition, localSuccessNode, Role.CONSTANT_SUCCESS_TRUE);
            }
            if ((globalSuccessNode = this.mappingPartitioner.basicGetGlobalSuccessNode(traceNode)) == null) continue;
            this.addNode(partition, globalSuccessNode, Role.CONSTANT_SUCCESS_TRUE);
        }
        Node sourceNode = this.realizedEdge.getEdgeSource();
        if (!partition.hasNode(sourceNode)) {
            Role sourceNodeRole = QVTscheduleUtil.getNodeRole((Node)sourceNode);
            if (sourceNodeRole == Role.REALIZED) {
                sourceNodeRole = QVTscheduleUtil.asPredicated((Role)sourceNodeRole);
            }
            this.addNode(partition, sourceNode, sourceNodeRole);
        }
        if (!partition.hasNode(targetNode = this.realizedEdge.getEdgeTarget())) {
            Role targetNodeRole = QVTscheduleUtil.getNodeRole((Node)targetNode);
            if (targetNodeRole == Role.REALIZED) {
                targetNodeRole = QVTscheduleUtil.asPredicated((Role)targetNodeRole);
            }
            this.addNode(partition, targetNode, targetNodeRole);
        }
        this.resolvePrecedingNodes(partitionAnalysis);
        Node qvtrThis = null;
        Node qvtrTransformation = null;
        for (Node node : partition.getPartialNodes()) {
            if ("qvtrThisVariable".equals(node.getName())) {
                qvtrThis = node;
                continue;
            }
            if (!"qvtrTransformation".equals(node.getName())) continue;
            qvtrTransformation = node;
        }
        if (qvtrThis != null != (qvtrTransformation != null)) {
            this.resolvePrecedingNodes(partitionAnalysis);
        }
        this.resolveDisambiguations(partition);
        this.resolveEdges(partitionAnalysis);
    }

    @Override
    protected @Nullable Role resolveEdgeRole(@NonNull Role sourceNodeRole, @NonNull Edge edge, @NonNull Role targetNodeRole) {
        return QVTscheduleUtil.getEdgeRole((Edge)edge);
    }

    @Override
    public @NonNull String toString() {
        return String.valueOf(super.toString()) + " " + this.realizedEdge.getName();
    }
}

