/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvtm2qvts;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.NavigationCallExp;
import org.eclipse.ocl.pivot.OCLExpression;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.Variable;
import org.eclipse.ocl.pivot.VariableDeclaration;
import org.eclipse.ocl.pivot.VariableExp;
import org.eclipse.ocl.pivot.utilities.NameUtil;
import org.eclipse.ocl.pivot.utilities.PivotUtil;
import org.eclipse.ocl.pivot.utilities.TreeIterable;
import org.eclipse.qvtd.pivot.qvtcore.Assignment;
import org.eclipse.qvtd.pivot.qvtcore.CorePattern;
import org.eclipse.qvtd.pivot.qvtcore.NavigationAssignment;
import org.eclipse.qvtd.pivot.qvtcore.RealizedVariable;
import org.eclipse.qvtd.pivot.qvtcore.VariableAssignment;
import org.eclipse.qvtd.pivot.qvtcore.utilities.QVTcoreUtil;

public class AssignmentSorter {
    protected final @NonNull Map<@NonNull Variable, @NonNull Map<@NonNull Property, @NonNull NavigationAssignment>> realizedVariable2property2navigationAssignment = new HashMap<Variable, Map<Property, NavigationAssignment>>();
    protected final @NonNull Map<@NonNull VariableDeclaration, @NonNull VariableAssignment> variable2variableAssignment = new HashMap<VariableDeclaration, VariableAssignment>();
    protected final @NonNull List<@NonNull Assignment> otherAssignments = new ArrayList<Assignment>();

    private static @Nullable Variable getTargetVariable(@NonNull NavigationAssignment navigationAssignment) {
        OCLExpression slotExpression = navigationAssignment.getSlotExpression();
        if (slotExpression instanceof VariableExp) {
            VariableExp variableExp = (VariableExp)slotExpression;
            Variable targetVariable = (Variable)variableExp.getReferredVariable();
            assert (targetVariable != null);
            return targetVariable;
        }
        return null;
    }

    public void addAll(@NonNull Iterable<@NonNull Assignment> assignments) {
        for (Assignment assignment : assignments) {
            VariableDeclaration targetVariable;
            if (assignment instanceof VariableAssignment) {
                VariableAssignment variableAssignment = (VariableAssignment)assignment;
                targetVariable = variableAssignment.getTargetVariable();
                if (targetVariable == null) continue;
                VariableAssignment oldAssignment = this.variable2variableAssignment.put(targetVariable, variableAssignment);
                assert (oldAssignment == null);
                continue;
            }
            if (assignment instanceof NavigationAssignment) {
                NavigationAssignment navigationAssignment = (NavigationAssignment)assignment;
                targetVariable = AssignmentSorter.getTargetVariable(navigationAssignment);
                if (targetVariable != null) {
                    Map<@NonNull Property, @NonNull NavigationAssignment> property2navigationAssignable = this.realizedVariable2property2navigationAssignment.get(targetVariable);
                    if (property2navigationAssignable == null) {
                        property2navigationAssignable = new HashMap<Property, NavigationAssignment>();
                        this.realizedVariable2property2navigationAssignment.put((Variable)targetVariable, property2navigationAssignable);
                    }
                    Property targetProperty = QVTcoreUtil.getTargetProperty((NavigationAssignment)navigationAssignment);
                    NavigationAssignment oldAssignment = property2navigationAssignable.put(targetProperty, navigationAssignment);
                    assert (oldAssignment == null);
                    continue;
                }
                this.otherAssignments.add(assignment);
                continue;
            }
            throw new IllegalStateException("Unknown Assignment class " + assignment.getClass().getName());
        }
    }

    protected @NonNull Map<@NonNull Assignment, Set<@NonNull Assignment>> gatherSourceAssignables(@NonNull Iterable<@NonNull Assignment> assignments) {
        HashMap<@NonNull Assignment, Set<@NonNull Assignment>> targetAssignment2sourceAssignments = new HashMap<Assignment, Set<Assignment>>();
        for (Assignment assignment : assignments) {
            HashSet<@NonNull Object> assignmentReferences = new HashSet<Object>();
            OCLExpression value = assignment.getValue();
            assert (value != null);
            for (EObject eObject : new TreeIterable((EObject)value, true)) {
                VariableExp variableExp;
                VariableDeclaration referredVariable;
                VariableAssignment variableAssignment;
                if (eObject instanceof NavigationCallExp) {
                    Property property;
                    NavigationAssignment navigationAssignment;
                    Map<Property, NavigationAssignment> property2navigationAssignment;
                    VariableDeclaration referredVariable2;
                    NavigationCallExp navigationCallExp = (NavigationCallExp)eObject;
                    OCLExpression sourceExpression = navigationCallExp.getOwnedSource();
                    if (!(sourceExpression instanceof VariableExp) || !((referredVariable2 = ((VariableExp)sourceExpression).getReferredVariable()) instanceof RealizedVariable) || (property2navigationAssignment = this.realizedVariable2property2navigationAssignment.get(referredVariable2)) == null || (navigationAssignment = property2navigationAssignment.get(property = PivotUtil.getReferredProperty((NavigationCallExp)navigationCallExp))) == null) continue;
                    assignmentReferences.add(navigationAssignment);
                    continue;
                }
                if (!(eObject instanceof VariableExp) || (variableAssignment = this.variable2variableAssignment.get(referredVariable = (variableExp = (VariableExp)eObject).getReferredVariable())) == null) continue;
                assignmentReferences.add(variableAssignment);
            }
            targetAssignment2sourceAssignments.put(assignment, assignmentReferences);
        }
        return targetAssignment2sourceAssignments;
    }

    protected void gatherSourceAssignables(@NonNull Map<@NonNull Assignment, Set<@NonNull Assignment>> targetAssignment2sourceAssignments, @NonNull Iterable<@NonNull ? extends Assignment> assignments) {
        for (Assignment assignment : assignments) {
            HashSet<@NonNull Object> assignmentReferences = new HashSet<Object>();
            OCLExpression value = assignment.getValue();
            assert (value != null);
            for (EObject eObject : new TreeIterable((EObject)value, true)) {
                VariableExp variableExp;
                VariableDeclaration referredVariable;
                VariableAssignment variableAssignment;
                if (eObject instanceof NavigationCallExp) {
                    Property property;
                    NavigationAssignment navigationAssignment;
                    Map<Property, NavigationAssignment> property2navigationAssignment;
                    VariableDeclaration referredVariable2;
                    NavigationCallExp navigationCallExp = (NavigationCallExp)eObject;
                    OCLExpression sourceExpression = navigationCallExp.getOwnedSource();
                    if (!(sourceExpression instanceof VariableExp) || !((referredVariable2 = ((VariableExp)sourceExpression).getReferredVariable()).eContainer() instanceof CorePattern) || (property2navigationAssignment = this.realizedVariable2property2navigationAssignment.get(referredVariable2)) == null || (navigationAssignment = property2navigationAssignment.get(property = PivotUtil.getReferredProperty((NavigationCallExp)navigationCallExp))) == null) continue;
                    assignmentReferences.add(navigationAssignment);
                    continue;
                }
                if (!(eObject instanceof VariableExp) || (variableAssignment = this.variable2variableAssignment.get(referredVariable = (variableExp = (VariableExp)eObject).getReferredVariable())) == null) continue;
                assignmentReferences.add(variableAssignment);
            }
            targetAssignment2sourceAssignments.put(assignment, assignmentReferences);
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public @NonNull Iterable<@NonNull Assignment> getSortedAssignments() {
        HashMap<@NonNull Assignment, Set<@NonNull Assignment>> targetAssignment2sourceAssignments = new HashMap<Assignment, Set<Assignment>>();
        this.gatherSourceAssignables(targetAssignment2sourceAssignments, this.variable2variableAssignment.values());
        for (Map<Property, NavigationAssignment> property2navigationAssignment : this.realizedVariable2property2navigationAssignment.values()) {
            this.gatherSourceAssignables(targetAssignment2sourceAssignments, property2navigationAssignment.values());
        }
        ArrayList<@NonNull Assignment> sortedAssignments = new ArrayList<Assignment>();
        HashSet<@NonNull K> targetAssignments = new HashSet(targetAssignment2sourceAssignments.keySet());
        while (targetAssignments.size() > 0) {
            ArrayList<@NonNull Assignment> resolvedAssignments = new ArrayList<Assignment>();
            for (Assignment targetAssignment : targetAssignments) {
                @NonNull Set sourceAssignments = (Set)targetAssignment2sourceAssignments.get(targetAssignment);
                assert (sourceAssignments != null);
                HashSet<@NonNull E> unresolvedAssignments = new HashSet(sourceAssignments);
                unresolvedAssignments.removeAll(sortedAssignments);
                if (!unresolvedAssignments.isEmpty()) continue;
                resolvedAssignments.add(targetAssignment);
            }
            if (resolvedAssignments.isEmpty()) {
                throw new IllegalStateException("Cyclic assignment dependency " + targetAssignments);
            }
            Collections.sort(resolvedAssignments, NameUtil.ToStringComparator.INSTANCE);
            sortedAssignments.addAll(resolvedAssignments);
            targetAssignments.removeAll(resolvedAssignments);
        }
        sortedAssignments.addAll(this.otherAssignments);
        return sortedAssignments;
    }
}

