/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.shrikeBT;

import com.ibm.wala.shrikeBT.Constants;
import com.ibm.wala.shrikeBT.Instruction;
import com.ibm.wala.shrikeBT.Util;

public final class ArrayLoadInstruction
extends Instruction {
    private static final ArrayLoadInstruction[] preallocated = ArrayLoadInstruction.preallocate();

    protected ArrayLoadInstruction(short opcode) {
        super(opcode);
    }

    private static ArrayLoadInstruction[] preallocate() {
        ArrayLoadInstruction[] r = new ArrayLoadInstruction[9];
        short i = 46;
        while (i <= 53) {
            r[i - 46] = new ArrayLoadInstruction(i);
            i = (short)(i + 1);
        }
        r[8] = r[5];
        return r;
    }

    public static ArrayLoadInstruction make(String type) throws IllegalArgumentException {
        int i = Util.getTypeIndex(type);
        if (i < 0 || i > 8) {
            throw new IllegalArgumentException("Invalid type " + type + " for ArrayLoadInstruction");
        }
        return preallocated[i];
    }

    public boolean equals(Object o) {
        if (o instanceof ArrayLoadInstruction) {
            ArrayLoadInstruction i = (ArrayLoadInstruction)o;
            return i.opcode == this.opcode;
        }
        return false;
    }

    public int hashCode() {
        return this.opcode + 9109101;
    }

    public int getPoppedCount() {
        return 2;
    }

    public String toString() {
        return "ArrayLoad(" + this.getType() + ")";
    }

    public String getPushedType(String[] types) throws IllegalArgumentException {
        if (types == null) {
            return this.getType();
        }
        if (types.length <= 1) {
            throw new IllegalArgumentException("types.length <= 1");
        }
        String t = types[1];
        if (t == null) {
            throw new IllegalArgumentException("types[1] cannot be null");
        }
        if (t.startsWith("[")) {
            return t.substring(1);
        }
        if (t.equals("L;")) {
            return "L;";
        }
        return "L?;";
    }

    public byte getPushedWordSize() {
        return Util.getWordSize(this.getType());
    }

    public String getType() {
        return Constants.indexedTypes[this.opcode - 46];
    }

    public void visit(Instruction.Visitor v) throws NullPointerException {
        v.visitArrayLoad(this);
    }

    public boolean isPEI() {
        return true;
    }
}

