/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.telemetry.tracing.tck.cdi;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.Tracer;
import jakarta.inject.Inject;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.Assert;
import org.testng.annotations.Test;

public class OpenTelemetryBeanTest
extends Arquillian {
    private static final String SPAN_NAME = "MySpanName";
    private static final String INVALID_SPAN_ID = "0000000000000000";
    @Inject
    private OpenTelemetry openTelemetry;

    @Deployment
    public static WebArchive createDeployment() {
        return (WebArchive)((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class)).addAsResource((Asset)new StringAsset("otel.sdk.disabled=false"), "META-INF/microprofile-config.properties")).addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
    }

    @Test
    void testOpenTelemetryBean() {
        Assert.assertNotNull((Object)this.openTelemetry);
    }

    @Test
    void testSpanAndTracer() {
        Tracer tracer = this.openTelemetry.getTracer("instrumentation-test", "1.0.0");
        Assert.assertNotNull((Object)tracer);
        Span span = tracer.spanBuilder(SPAN_NAME).startSpan();
        Assert.assertNotEquals((Object)span.getSpanContext().getSpanId(), (Object)INVALID_SPAN_ID);
    }
}

