/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.lra.tck.participant.api;

import java.net.URI;
import java.util.logging.Logger;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.eclipse.microprofile.lra.annotation.Compensate;
import org.eclipse.microprofile.lra.annotation.Complete;
import org.eclipse.microprofile.lra.annotation.ws.rs.LRA;
import org.eclipse.microprofile.lra.annotation.ws.rs.Leave;
import org.eclipse.microprofile.lra.tck.service.LRAMetricService;
import org.eclipse.microprofile.lra.tck.service.LRAMetricType;

@ApplicationScoped
@Path(value="participating-tck-resource")
public class ParticipatingTckResource {
    private static final Logger LOGGER = Logger.getLogger(ParticipatingTckResource.class.getName());
    public static final String TCK_PARTICIPANT_RESOURCE_PATH = "participating-tck-resource";
    public static final String JOIN_WITH_EXISTING_LRA_PATH = "/join-with-existing-lra";
    public static final String JOIN_WITH_EXISTING_LRA_PATH2 = "/join-with-existing-lra2";
    public static final String JOIN_WITH_NEW_LRA_PATH = "/join-with-new-LRA";
    public static final String LEAVE_PATH = "/leave";
    public static final String ACCEPT_PATH = "/accept";
    public static final String RECOVERY_PARAM = "recoveryCount";
    private int recoveryPasses = 0;
    @Inject
    private LRAMetricService lraMetricService;

    @PUT
    @Path(value="/compensate")
    @Compensate
    public Response compensateWork(@HeaderParam(value="Long-Running-Action") URI lraId) {
        if (lraId == null) {
            throw new NullPointerException("lraId can't be null as it should be invoked with the context");
        }
        LOGGER.info(String.format("LRA id '%s' was told to compensate", lraId));
        return this.getEndPhaseResponse(false, lraId);
    }

    @PUT
    @Path(value="/complete")
    @Complete
    public Response completeWork(@HeaderParam(value="Long-Running-Action") URI lraId) {
        if (lraId == null) {
            throw new NullPointerException("lraId can't be null as it should be invoked with the context");
        }
        LOGGER.info(String.format("LRA id '%s' was told to complete", lraId));
        return this.getEndPhaseResponse(true, lraId);
    }

    private Response getEndPhaseResponse(boolean complete, URI lraId) {
        if (--this.recoveryPasses > 0) {
            return Response.accepted().build();
        }
        if (complete) {
            this.lraMetricService.incrementMetric(LRAMetricType.Completed, lraId, ParticipatingTckResource.class);
        } else {
            this.lraMetricService.incrementMetric(LRAMetricType.Compensated, lraId, ParticipatingTckResource.class);
        }
        return Response.ok().build();
    }

    @PUT
    @Path(value="/accept")
    @LRA(value=LRA.Type.REQUIRES_NEW)
    public Response acceptLRA(@QueryParam(value="recoveryCount") @DefaultValue(value="0") Integer recoveryPasses) {
        this.recoveryPasses = recoveryPasses;
        return Response.ok().build();
    }

    @GET
    @Path(value="/accept")
    public Response getAcceptLRA() {
        return Response.ok((Object)this.recoveryPasses).build();
    }

    @PUT
    @Path(value="/leave")
    @LRA(value=LRA.Type.SUPPORTS, end=false)
    @Leave
    public Response leaveLRA() {
        return Response.ok().build();
    }

    @PUT
    @Path(value="/join-with-existing-lra")
    @LRA(value=LRA.Type.MANDATORY, end=false, cancelOnFamily={})
    public Response joinWithExistingLRA(@HeaderParam(value="Long-Running-Action") URI lraId) {
        return Response.ok().build();
    }

    @PUT
    @Path(value="/join-with-existing-lra2")
    @LRA(value=LRA.Type.MANDATORY, end=false)
    public Response joinWithExistingLRA2(@HeaderParam(value="Long-Running-Action") URI lraId) {
        return Response.ok().build();
    }

    @PUT
    @Path(value="/join-with-new-LRA")
    @LRA(value=LRA.Type.REQUIRES_NEW, end=false)
    public Response joinWithNewLRA(@HeaderParam(value="Long-Running-Action") URI lraId) {
        return Response.ok().build();
    }
}

