/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.lra.tck;

import java.net.URL;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import org.eclipse.microprofile.lra.LRAResponse;
import org.eclipse.microprofile.lra.tck.LRAClientOps;
import org.eclipse.microprofile.lra.tck.LraTckConfigBean;
import org.eclipse.microprofile.lra.tck.participant.activity.Activity;
import org.eclipse.microprofile.lra.tck.participant.api.LraResource;
import org.eclipse.microprofile.lra.tck.service.LRAMetricService;
import org.eclipse.microprofile.lra.tck.service.LRATestService;
import org.eclipse.microprofile.lra.tck.service.spi.LRARecoveryService;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.rules.TestName;

public class TckTestBase {
    private static final Logger LOGGER = Logger.getLogger(TckTestBase.class.getName());
    @Rule
    public TestName testName = new TestName();
    @Inject
    private LraTckConfigBean config;
    @Inject
    LRATestService lraTestService;
    @Inject
    private LRAMetricService lraMetricService;
    @ArquillianResource
    private URL deploymentURL;
    LRAClientOps lraClient;
    WebTarget tckSuiteTarget;

    static WebArchive deploy(String archiveName) {
        return (WebArchive)((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)(archiveName + ".war"))).addPackages(false, new Package[]{TckTestBase.class.getPackage(), LRAResponse.class.getPackage(), Activity.class.getPackage(), LraResource.class.getPackage(), LRAMetricService.class.getPackage(), LRARecoveryService.class.getPackage()})).addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
    }

    @Before
    public void before() {
        LOGGER.info("Running test: " + this.testName.getMethodName());
        this.lraTestService.start(this.deploymentURL);
        this.lraMetricService.clear();
        this.lraClient = this.lraTestService.getLRAClient();
        this.tckSuiteTarget = this.lraTestService.getTCKSuiteTarget();
    }

    @After
    public void after() {
        this.lraTestService.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkStatusAndCloseResponse(Response.Status expectedStatus, Response response, WebTarget resourcePath) {
        try {
            Assert.assertEquals((String)("Not expected status at call '" + resourcePath.getUri() + "'"), (long)expectedStatus.getStatusCode(), (long)response.getStatus());
        }
        finally {
            response.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String checkStatusReadAndCloseResponse(Response.Status expectedStatus, Response response, WebTarget resourcePath) {
        try {
            Assert.assertEquals((String)("Response status on call to '" + resourcePath.getUri() + "' failed to match."), (long)expectedStatus.getStatusCode(), (long)response.getStatus());
            String string = (String)response.readEntity(String.class);
            return string;
        }
        finally {
            response.close();
        }
    }

    String lraClientId() {
        return this.getClass().getSimpleName() + "#" + this.testName.getMethodName();
    }

    long lraTimeout() {
        return this.config.getDefaultTimeout();
    }
}

