/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.lra.tck;

import java.net.URI;
import javax.inject.Inject;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import org.eclipse.microprofile.lra.annotation.ParticipantStatus;
import org.eclipse.microprofile.lra.tck.TckTestBase;
import org.eclipse.microprofile.lra.tck.participant.api.AfterLRAListener;
import org.eclipse.microprofile.lra.tck.participant.api.ContextTckResource;
import org.eclipse.microprofile.lra.tck.service.LRAMetricAssertions;
import org.eclipse.microprofile.lra.tck.service.LRAMetricService;
import org.eclipse.microprofile.lra.tck.service.LRAMetricType;
import org.eclipse.microprofile.lra.tck.service.LRATestService;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.StringContains;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
public class TckContextTests
extends TckTestBase {
    @Inject
    private LRAMetricAssertions lraMetric;
    @Inject
    private LRAMetricService lraMetricService;
    @Inject
    private LRATestService lraTestService;

    @Deployment(name="TckContextTests")
    public static WebArchive deploy() {
        return TckTestBase.deploy(TckContextTests.class.getSimpleName().toLowerCase());
    }

    @Override
    @Before
    public void before() {
        super.before();
        this.invoke("/reset", HttpMethod.PUT, null, 200, null, 200);
    }

    @Test
    public void testBasicContextPropagation() {
        URI lra = URI.create(this.invoke("/new-lra", HttpMethod.PUT, null, 200, ContextTckResource.EndPhase.SUCCESS, 200));
        this.invoke("/required-lra", HttpMethod.PUT, lra, 200, ContextTckResource.EndPhase.SUCCESS, 200);
        this.lraMetric.assertCompletedEquals("Resource was not asked to complete", 1, lra, ContextTckResource.class);
    }

    @Test
    public void testStatus() {
        URI lra = URI.create(this.invoke("/required-lra", HttpMethod.PUT, null, 200, ContextTckResource.EndPhase.ACCEPTED, 202));
        String status = this.invoke("/status", HttpMethod.GET, lra, 202, ContextTckResource.EndPhase.SUCCESS, 200);
        this.lraTestService.waitForCallbacks(lra);
        Assert.assertEquals((String)(this.testName.getMethodName() + ": participant is not completing"), (Object)ParticipantStatus.Completing.name(), (Object)status);
        this.invoke("/clear-status", HttpMethod.POST, lra, 200, ContextTckResource.EndPhase.SUCCESS, 200);
        this.lraTestService.waitForRecovery(lra);
        status = this.invoke("/status", HttpMethod.GET, lra, 200, ContextTckResource.EndPhase.SUCCESS, 200);
        Assert.assertEquals((String)(this.testName.getMethodName() + ": participant is not completed"), (Object)ParticipantStatus.Completed.name(), (Object)status);
    }

    @Test
    public void testLeave() {
        URI lra = URI.create(this.invoke("/new-lra", HttpMethod.PUT, null, 200, ContextTckResource.EndPhase.SUCCESS, 200));
        String status = this.invoke("/status", HttpMethod.GET, lra, 200, ContextTckResource.EndPhase.SUCCESS, 200);
        Assert.assertEquals((String)(this.testName.getMethodName() + ": participant is not active"), (Object)ParticipantStatus.Active.name(), (Object)status);
        this.invoke("/leave", HttpMethod.PUT, lra);
        this.lraClient.closeLRA(lra);
        this.lraMetric.assertNotCompleted("Resource left but was still asked to complete", lra, ContextTckResource.class);
    }

    @Test
    public void testForget() {
        URI lra = URI.create(this.invoke("/required-lra", HttpMethod.PUT, null, 200, ContextTckResource.EndPhase.FAILED, 503));
        this.lraTestService.waitForEndPhaseReplay(lra);
        this.lraMetric.assertStatus("Resource status should have been called", lra, ContextTckResource.class);
        this.lraMetric.assertNotForget("Resource forget should not have been called", lra, ContextTckResource.class);
        this.invoke("/clear-status", HttpMethod.POST, lra, 200, ContextTckResource.EndPhase.FAILED, 200);
        this.lraTestService.waitForRecovery(lra);
        int count = this.lraMetricService.getMetric(LRAMetricType.Status, lra, ContextTckResource.class);
        MatcherAssert.assertThat((String)(this.testName.getMethodName() + " resource status should have been called again"), (Object)count, (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(2)));
        this.lraMetric.assertForget("Resource forget should have been called", lra, ContextTckResource.class);
    }

    @Test
    public void testParentContextAvailable() {
        URI topLevelLRA = URI.create(this.invoke("/new-lra", HttpMethod.PUT, null));
        String result = this.invoke("/nested-lra", HttpMethod.PUT, topLevelLRA);
        MatcherAssert.assertThat((String)"Expecting the result string contains comma on PUT to /nested-lra", (Object)result, (Matcher)new StringContains(","));
        Assert.assertEquals((String)(this.testName.getMethodName() + ": wrong parent LRA"), (Object)topLevelLRA, (Object)URI.create(result.split(",")[1]));
        URI nestedLRA = URI.create(result.split(",")[0]);
        this.invoke("/required-lra", HttpMethod.PUT, topLevelLRA);
        this.lraMetric.assertCompletedEquals("Resource should have completed for the nested LRA", 1, nestedLRA, ContextTckResource.class);
        this.lraMetric.assertCompletedEquals("Resource should have completed for the top level LRA", 1, topLevelLRA, ContextTckResource.class);
        this.lraMetric.assertNestedEquals("when the resource was asked to complete a nested LRA the parent context header was missing", 1, topLevelLRA, ContextTckResource.class);
    }

    @Test
    public void testForgetCalledForNestedParticipantsWhenParentIsClosed() {
        URI topLevelLRA = URI.create(this.invoke("/new-lra", HttpMethod.PUT, null));
        String result = this.invoke("/nested-lra-with-close", HttpMethod.PUT, topLevelLRA);
        MatcherAssert.assertThat((String)"Expecting the result string contains comma on PUT to endpoint /nested-lra-with-close", (Object)result, (Matcher)new StringContains(","));
        Assert.assertEquals((String)(this.testName.getMethodName() + ": wrong parent LRA"), (Object)topLevelLRA, (Object)URI.create(result.split(",")[1]));
        URI nestedLRA = URI.create(result.split(",")[0]);
        this.lraTestService.waitForCallbacks(nestedLRA);
        this.lraMetric.assertCompletedEquals("resource should have completed for the nested LRA ", 1, nestedLRA, ContextTckResource.class);
        this.invoke("/required-lra", HttpMethod.PUT, topLevelLRA);
        this.lraTestService.waitForCallbacks(topLevelLRA);
        this.lraMetric.assertCompletedEquals("resource should have completed for the top level LRA", 1, topLevelLRA, ContextTckResource.class);
        this.lraMetric.assertCompletedEquals("resource should not have completed for the nested LRA again", 1, nestedLRA, ContextTckResource.class);
        this.lraMetric.assertForgetEquals("resource should have called forget for the nested LRA", 1, nestedLRA, ContextTckResource.class);
        this.lraMetric.assertNestedEquals("parent context not included in complete or forget callbacks", 2, topLevelLRA, ContextTckResource.class);
    }

    @Test
    public void testContextAfterRemoteCalls() {
        this.invoke("/context-check-lra", HttpMethod.PUT, null);
    }

    @Test
    public void testAsync1Support() {
        URI lra = URI.create(this.invoke("async-response-lra", HttpMethod.PUT, null));
        this.lraMetric.assertCompletedEquals("Resource async-response-lra was not asked to complete", 1, lra, ContextTckResource.class);
    }

    @Test
    public void testAsync2Support() {
        URI lra = URI.create(this.invoke("completion-stage-lra", HttpMethod.PUT, null));
        this.lraMetric.assertCompletedEquals("Resource 'completion-stage-lra' was not asked to complete", 1, lra, ContextTckResource.class);
    }

    @Test
    public void testAsync3Support() {
        URI lra = URI.create(this.invoke("completion-stage-exceptionally-lra", HttpMethod.PUT, null, 404, ContextTckResource.EndPhase.SUCCESS, 200));
        this.lraTestService.waitForCallbacks(lra);
        this.lraMetric.assertNotCompleted("Resource 'completion-stage-exceptionally-lra' was not expected to be asked to complete", lra, ContextTckResource.class);
        this.lraMetric.assertCompensatedEquals("Resource 'completion-stage-exceptionally-lra' was expected to be asked to compensate", 1, lra, ContextTckResource.class);
    }

    @Test
    public void testAfterLRAEnlistmentDuringClosingPhase() {
        URI lra = URI.create(this.invoke("/required-lra", HttpMethod.PUT, null, 200, ContextTckResource.EndPhase.ACCEPTED, 202));
        String status = this.invoke("/status", HttpMethod.GET, lra, 202, ContextTckResource.EndPhase.SUCCESS, 200);
        this.lraTestService.waitForCallbacks(lra);
        Assert.assertEquals((String)(this.testName.getMethodName() + ": participant is not completing"), (Object)ParticipantStatus.Completing.name(), (Object)status);
        Response enlistResponse = this.tckSuiteTarget.path("after-lra-listener").path("work").request().header("Long-Running-Action", (Object)lra).put(null);
        Assert.assertEquals((String)"AfterLRA listener hasn't been enlisted for the notification", (long)200L, (long)enlistResponse.getStatus());
        enlistResponse.close();
        this.invoke("/clear-status", HttpMethod.POST, lra, 200, ContextTckResource.EndPhase.SUCCESS, 200);
        this.lraTestService.waitForRecovery(lra);
        this.lraMetric.assertCompletedEquals("Resource '/required-lra' is not completed", 1, lra, ContextTckResource.class);
        this.lraMetric.assertClosed("AfterLRA listener registered during the Closing phase was not notified about the LRA close", lra, AfterLRAListener.class);
    }

    private String invoke(String where, HttpMethod method, URI lraContext) {
        return this.invoke(where, method, lraContext, 200, ContextTckResource.EndPhase.SUCCESS, 200);
    }

    private String invoke(String where, HttpMethod method, URI lraContext, int expectStatus, ContextTckResource.EndPhase finishWith, int finishStatus) {
        Response response;
        WebTarget resourcePath = this.tckSuiteTarget.path("context-tck-resource").path(where);
        Invocation.Builder builder = resourcePath.request().header("Lra-Tck-Fault-Type", (Object)finishWith).header("Lra-Tck-Fault-Status", (Object)finishStatus);
        if (lraContext != null) {
            if (where.startsWith("/count") || where.startsWith("/clear-status")) {
                builder.header("Lra-Tck-Context", (Object)lraContext);
            } else {
                builder.header("Long-Running-Action", (Object)lraContext);
            }
        }
        switch (method) {
            case GET: {
                response = builder.get();
                break;
            }
            case PUT: {
                response = builder.put(Entity.text((Object)""));
                break;
            }
            case POST: {
                response = builder.post(Entity.text((Object)""));
                break;
            }
            default: {
                throw new IllegalArgumentException("HTTP method not supported: " + (Object)((Object)method));
            }
        }
        return this.checkStatusReadAndCloseResponse(Response.Status.fromStatusCode((int)expectStatus), response, resourcePath);
    }

    static enum HttpMethod {
        GET,
        PUT,
        POST;

    }
}

