/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.fault.tolerance.tck.metrics.common.util;

import org.eclipse.microprofile.fault.tolerance.tck.util.TCKConfig;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

public class TimeUtils {
    private TimeUtils() {
    }

    public static Matcher<Long> approxMillis(long originalMillis) {
        long millis = TCKConfig.getConfig().getTimeoutInMillis(originalMillis);
        long nanos = millis * 1000000L;
        long error = Math.round((double)nanos * 0.2);
        return Matchers.allOf((Matcher)Matchers.greaterThan((Comparable)Long.valueOf(nanos - error)), (Matcher)Matchers.lessThan((Comparable)Long.valueOf(nanos + error)));
    }

    public static Matcher<Long> lessThanMillis(long originalMillis) {
        long millis = TCKConfig.getConfig().getTimeoutInMillis(originalMillis);
        long nanos = millis * 1000000L;
        return Matchers.lessThan((Comparable)Long.valueOf(nanos));
    }
}

