/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.query.refined;

import com.ibm.icu.text.DecimalFormat;
import com.ibm.icu.text.NumberFormat;
import java.text.Format;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.mat.query.Bytes;
import org.eclipse.mat.query.Column;
import org.eclipse.mat.report.internal.Messages;
import org.eclipse.mat.util.IProgressListener;
import org.eclipse.mat.util.MessageUtil;
import org.eclipse.mat.util.PatternUtil;

public abstract class Filter {
    public static final String[] FILTER_TYPES = new String[]{Messages.Filter_Label_Regex, Messages.Filter_Label_Numeric};
    protected FilterChangeListener listener;

    public abstract boolean setCriteria(String var1) throws IllegalArgumentException;

    public abstract String getCriteria();

    public abstract String getLabel();

    public abstract boolean isActive();

    abstract boolean acceptObject();

    abstract boolean accept(Object var1);

    abstract boolean accept(String var1);

    protected Filter(FilterChangeListener listener) {
        this.listener = listener;
    }

    static class Factory {
        public static Filter build(Column column, FilterChangeListener listener) {
            if (column.isNumeric()) {
                Format formatter = column.getFormatter();
                ValueConverter converter = (ValueConverter)column.getData(ValueConverter.class);
                boolean isPercentage = formatter instanceof DecimalFormat && ((DecimalFormat)formatter).toPattern().indexOf(37) >= 0;
                return isPercentage ? new PercentageFilter(listener, converter, column) : new NumericFilter(listener, converter, column);
            }
            return new PatternFilter(listener);
        }

        private Factory() {
        }
    }

    static interface FilterChangeListener {
        public void filterChanged(Filter var1);
    }

    private static class NumericFilter
    extends Filter {
        private static final String ERROR_MSG = Messages.Filter_Error_Parsing;
        String criteria;
        Test test;
        ValueConverter converter;
        Column column;

        public NumericFilter(FilterChangeListener listener, ValueConverter converter, Column column) {
            super(listener);
            this.converter = converter;
            this.column = column;
        }

        @Override
        boolean acceptObject() {
            return true;
        }

        @Override
        boolean accept(Object value) {
            Test currentTest;
            double doubleValue;
            double d = value instanceof Bytes ? (double)((Bytes)value).getValue() : (doubleValue = value instanceof Number ? ((Number)value).doubleValue() : Double.NaN);
            if (this.converter != null) {
                doubleValue = this.converter.convert(doubleValue);
            }
            if ((currentTest = this.test) == null) {
                throw new IProgressListener.OperationCanceledException();
            }
            return currentTest.accept(doubleValue);
        }

        @Override
        boolean accept(String value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getCriteria() {
            return this.criteria;
        }

        @Override
        public boolean setCriteria(String criteria) throws IllegalArgumentException {
            if (criteria == null || criteria.trim().length() == 0) {
                boolean changed = this.criteria != null;
                this.criteria = null;
                this.test = null;
                if (changed) {
                    this.listener.filterChanged(this);
                }
                return changed;
            }
            if (this.criteria != null && this.criteria.equals(criteria)) {
                return false;
            }
            Test newTest = null;
            try {
                int indexOfDots = criteria.indexOf("..");
                if (indexOfDots >= 0) {
                    int st = criteria.startsWith("U\\") ? 2 : (criteria.startsWith("!") ? 1 : 0);
                    Double lowerBound = this.number(criteria.substring(st, indexOfDots).trim());
                    int lastIndexOfDots = criteria.lastIndexOf("..");
                    Double upperBound = this.number(criteria.substring(lastIndexOfDots + 2).trim());
                    if (lowerBound != null && upperBound != null) {
                        newTest = new CompositeTest(new LowerEqualBoundary(lowerBound), new UpperEqualBoundary(upperBound));
                    } else if (lowerBound != null) {
                        newTest = new LowerEqualBoundary(lowerBound);
                    } else if (upperBound != null) {
                        newTest = new UpperEqualBoundary(upperBound);
                    } else {
                        lowerBound = this.number(criteria);
                    }
                    if (criteria.startsWith("!")) {
                        newTest = new NotTest(newTest);
                    } else if (criteria.startsWith("U\\")) {
                        newTest = new CompositeTest(new NotTest(newTest), new NotEqualsTest(Double.NaN));
                    }
                } else {
                    newTest = criteria.charAt(0) == '>' && criteria.length() >= 2 ? (criteria.length() >= 3 && criteria.charAt(1) == '=' ? new LowerEqualBoundary(this.number(criteria.substring(2))) : new LowerBoundary(this.number(criteria.substring(1)))) : (criteria.charAt(0) == '<' && criteria.length() >= 2 ? (criteria.length() >= 3 && criteria.charAt(1) == '=' ? new UpperEqualBoundary(this.number(criteria.substring(2))) : (criteria.length() >= 3 && criteria.charAt(1) == '>' ? new NotEqualsTest(this.number(criteria.substring(2))) : new UpperBoundary(this.number(criteria.substring(1))))) : (criteria.charAt(0) == '!' && criteria.length() >= 3 && criteria.charAt(1) == '=' ? new NotEqualsTest(this.number(criteria.substring(2))) : new EqualsTest(this.number(criteria))));
                }
            }
            catch (ParseException e) {
                throw new IllegalArgumentException(String.valueOf(MessageUtil.format(Messages.Filter_Error_Parsing2, this.format(this.lowerExample()), this.format(this.upperExample()))) + e.getMessage(), e);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException(String.valueOf(MessageUtil.format(Messages.Filter_Error_Parsing2, this.format(this.lowerExample()), this.format(this.upperExample()))) + e.getMessage(), e);
            }
            this.criteria = criteria;
            this.test = newTest;
            this.listener.filterChanged(this);
            return true;
        }

        protected String format(Object obj) {
            Format f = this.column.getFormatter();
            if (f != null) {
                return f.format(obj);
            }
            return String.valueOf(obj);
        }

        protected Object parseObject(String s, ParsePosition pos) {
            Format f = this.column.getFormatter();
            if (f != null) {
                return f.parseObject(s, pos);
            }
            return null;
        }

        protected Number lowerExample() {
            return 1000;
        }

        protected Number upperExample() {
            return 10000;
        }

        protected Double number(String string) throws ParseException {
            Number nresult;
            if (string.length() == 0) {
                return null;
            }
            ParsePosition pos = new ParsePosition(0);
            Object oresult = this.parseObject(string, pos);
            if (oresult instanceof Number) {
                nresult = (Number)oresult;
            } else if (oresult instanceof Bytes) {
                nresult = ((Bytes)oresult).getValue();
            } else {
                pos = new ParsePosition(0);
                NumberFormat f = DecimalFormat.getInstance();
                nresult = f.parse(string, pos);
            }
            if (pos.getIndex() < string.length()) {
                throw new ParseException(MessageUtil.format(Messages.Filter_Error_IllegalCharacters, string.substring(pos.getIndex())), pos.getIndex());
            }
            Double result = nresult.doubleValue();
            return result;
        }

        @Override
        public String getLabel() {
            return FILTER_TYPES[1];
        }

        @Override
        public boolean isActive() {
            return this.criteria != null;
        }

        static class CompositeTest
        implements Test {
            Test a;
            Test b;

            private CompositeTest(Test a, Test b) {
                this.a = a;
                this.b = b;
            }

            @Override
            public boolean accept(double value) {
                return this.a.accept(value) && this.b.accept(value);
            }
        }

        static class EqualsTest
        implements Test {
            double value;

            EqualsTest(double value) {
                this.value = value;
            }

            @Override
            public boolean accept(double value) {
                return this.value == value || Double.isNaN(this.value) && Double.isNaN(value);
            }
        }

        static class LowerBoundary
        implements Test {
            double bound;

            LowerBoundary(double bound) {
                this.bound = bound;
            }

            @Override
            public boolean accept(double value) {
                return value > this.bound;
            }
        }

        static class LowerEqualBoundary
        implements Test {
            double bound;

            LowerEqualBoundary(double bound) {
                this.bound = bound;
            }

            @Override
            public boolean accept(double value) {
                return value >= this.bound;
            }
        }

        static class NotEqualsTest
        implements Test {
            double value;

            NotEqualsTest(double value) {
                this.value = value;
            }

            @Override
            public boolean accept(double value) {
                return this.value != value && (!Double.isNaN(this.value) || !Double.isNaN(value));
            }
        }

        static class NotTest
        implements Test {
            Test a;

            private NotTest(Test t) {
                this.a = t;
            }

            @Override
            public boolean accept(double value) {
                return !this.a.accept(value);
            }
        }

        static interface Test {
            public boolean accept(double var1);
        }

        static class UpperBoundary
        implements Test {
            double bound;

            UpperBoundary(double bound) {
                this.bound = bound;
            }

            @Override
            public boolean accept(double value) {
                return value < this.bound;
            }
        }

        static class UpperEqualBoundary
        implements Test {
            double bound;

            UpperEqualBoundary(double bound) {
                this.bound = bound;
            }

            @Override
            public boolean accept(double value) {
                return value <= this.bound;
            }
        }
    }

    private static class PatternFilter
    extends Filter {
        Pattern pattern;

        public PatternFilter(FilterChangeListener listener) {
            super(listener);
        }

        @Override
        boolean acceptObject() {
            return false;
        }

        @Override
        boolean accept(Object value) {
            throw new UnsupportedOperationException();
        }

        @Override
        boolean accept(String value) {
            if (this.pattern == null) {
                throw new IProgressListener.OperationCanceledException();
            }
            return value == null ? false : this.pattern.matcher(value).matches();
        }

        @Override
        public boolean setCriteria(String criteria) throws IllegalArgumentException {
            if (criteria == null || criteria.trim().length() == 0) {
                boolean changed = this.pattern != null;
                this.pattern = null;
                if (changed) {
                    this.listener.filterChanged(this);
                }
                return changed;
            }
            try {
                Pattern p = Pattern.compile(PatternUtil.smartFix(criteria));
                boolean changed = this.pattern == null || !this.pattern.pattern().equals(p.pattern());
                this.pattern = p;
                if (changed) {
                    this.listener.filterChanged(this);
                }
                return changed;
            }
            catch (PatternSyntaxException e) {
                throw new IllegalArgumentException(String.valueOf(Messages.Filter_Error_InvalidRegex) + "\n\n" + e.getMessage(), e);
            }
        }

        @Override
        public String getCriteria() {
            return this.pattern != null ? this.pattern.pattern() : null;
        }

        @Override
        public String getLabel() {
            return FILTER_TYPES[0];
        }

        @Override
        public boolean isActive() {
            return this.pattern != null;
        }
    }

    private static class PercentageFilter
    extends NumericFilter {
        public PercentageFilter(FilterChangeListener listener, ValueConverter converter, Column column) {
            super(listener, converter, column);
        }

        @Override
        protected Number lowerExample() {
            return 0.01;
        }

        @Override
        protected Number upperExample() {
            return 0.1;
        }

        @Override
        protected Double number(String string) throws ParseException {
            Number nresult;
            if (string.length() == 0) {
                return null;
            }
            ParsePosition pos = new ParsePosition(0);
            Object oresult = this.parseObject(string, pos);
            if (oresult instanceof Number) {
                nresult = (Number)oresult;
            } else {
                pos = new ParsePosition(0);
                NumberFormat f = DecimalFormat.getPercentInstance();
                nresult = f.parse(string, pos);
                if (nresult == null) {
                    ParsePosition p2 = new ParsePosition(0);
                    f = DecimalFormat.getNumberInstance();
                    nresult = f.parse(string, p2);
                    if (nresult != null) {
                        if (p2.getIndex() < string.length() && string.charAt(p2.getIndex()) == '%' && nresult instanceof Number) {
                            nresult = nresult.doubleValue() / 100.0;
                            p2.setIndex(p2.getIndex() + 1);
                        }
                        pos = p2;
                    }
                }
            }
            if (pos.getIndex() < string.length()) {
                throw new ParseException(MessageUtil.format(Messages.Filter_Error_IllegalCharacters, string.substring(pos.getIndex())), pos.getIndex());
            }
            Double result = nresult.doubleValue();
            return result;
        }
    }

    public static interface ValueConverter {
        public double convert(double var1);
    }
}

