/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lyo.server.oauth.core.utils;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.EventListener;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import net.oauth.OAuthAccessor;
import net.oauth.OAuthConsumer;
import net.oauth.OAuthException;
import net.oauth.OAuthMessage;
import net.oauth.OAuthProblemException;
import net.oauth.server.OAuthServlet;
import org.eclipse.lyo.server.oauth.core.Application;
import org.eclipse.lyo.server.oauth.core.AuthenticationException;
import org.eclipse.lyo.server.oauth.core.OAuthConfiguration;
import org.eclipse.lyo.server.oauth.core.OAuthRequest;
import org.eclipse.lyo.server.oauth.core.consumer.ConsumerStore;
import org.eclipse.lyo.server.oauth.core.consumer.LyoOAuthConsumer;
import org.eclipse.lyo.server.oauth.core.token.LRUCache;
import org.eclipse.lyo.server.oauth.core.token.SimpleTokenStrategy;
import org.eclipse.lyo.server.oauth.core.utils.UnauthorizedException;

public abstract class AbstractAdapterCredentialsFilter<Credentials, Connection>
implements Filter {
    private static final String ATTRIBUTE_BASE = "org.eclipse.lyo.server.oauth.core.utils.";
    protected static final String CONNECTOR_ATTRIBUTE = "org.eclipse.lyo.server.oauth.core.utils.Connector";
    protected static final String CREDENTIALS_ATTRIBUTE = "org.eclipse.lyo.server.oauth.core.utils.Credentials";
    protected static final String ADMIN_SESSION_ATTRIBUTE = "org.eclipse.lyo.server.oauth.core.utils.AdminSession";
    protected static final String JAZZ_INVALID_EXPIRED_TOKEN_OAUTH_PROBLEM = "invalid_expired_token";
    protected static final String OAUTH_EMPTY_TOKEN_KEY = new String("OAUTH_EMPTY_TOKEN_KEY");
    private final LRUCache<String, Connection> tokenToConnectionCache = new LRUCache(200);
    private final String displayName;
    private final String realm;
    private HttpSessionListener listener = new HttpSessionListener(){

        public void sessionDestroyed(HttpSessionEvent se) {
            HttpSession session = se.getSession();
            Object loginSession = session.getAttribute(AbstractAdapterCredentialsFilter.CONNECTOR_ATTRIBUTE);
            AbstractAdapterCredentialsFilter.this.logout(loginSession, session);
        }

        public void sessionCreated(HttpSessionEvent se) {
        }
    };

    protected AbstractAdapterCredentialsFilter(String displayName, String realm) {
        this.displayName = displayName;
        this.realm = realm;
    }

    protected abstract Credentials getCredentialsFromRequest(HttpServletRequest var1) throws UnauthorizedException;

    protected abstract Credentials getCredentialsForOAuth(String var1, String var2);

    protected abstract Connection login(Credentials var1, HttpServletRequest var2) throws UnauthorizedException, ServletException;

    protected void logout(Connection loginSession, HttpSession session) {
    }

    protected abstract boolean isAdminSession(String var1, Connection var2, HttpServletRequest var3);

    protected abstract ConsumerStore createConsumerStore() throws Exception;

    public static <T> T getConnector(HttpServletRequest request) {
        Object connector = request.getAttribute(CONNECTOR_ATTRIBUTE);
        return (T)connector;
    }

    public static <T> T getCredentials(HttpServletRequest request) {
        Object credentials = request.getSession().getAttribute(CREDENTIALS_ATTRIBUTE);
        return (T)credentials;
    }

    protected String getOAuthRealm() {
        return this.realm;
    }

    protected String getDisplayName() {
        return this.displayName;
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain chain) throws IOException, ServletException {
        if (servletRequest instanceof HttpServletRequest && servletResponse instanceof HttpServletResponse) {
            HttpServletRequest request = (HttpServletRequest)servletRequest;
            HttpServletResponse response = (HttpServletResponse)servletResponse;
            boolean isTwoLeggedOAuthRequest = false;
            String twoLeggedOAuthConsumerKey = null;
            if (!request.getPathInfo().startsWith("/oauth")) {
                block20: {
                    try {
                        try {
                            OAuthMessage message = OAuthServlet.getMessage((HttpServletRequest)request, null);
                            if ("".equals(message.getToken())) {
                                this.validateTwoLeggedOAuthMessage(message);
                                isTwoLeggedOAuthRequest = true;
                                twoLeggedOAuthConsumerKey = message.getConsumerKey();
                            }
                            if (!isTwoLeggedOAuthRequest && message.getToken() != null) {
                                OAuthRequest oAuthRequest = new OAuthRequest(request);
                                oAuthRequest.validate();
                                Object connector = this.tokenToConnectionCache.get(message.getToken());
                                if (connector == null) {
                                    throw new OAuthProblemException("token_rejected");
                                }
                                request.getSession().setAttribute(CONNECTOR_ATTRIBUTE, connector);
                            }
                        }
                        catch (OAuthProblemException e) {
                            if ("token_rejected".equals(e.getProblem())) {
                                this.throwInvalidExpiredException(e);
                                break block20;
                            }
                            throw e;
                        }
                    }
                    catch (OAuthException e) {
                        OAuthServlet.handleException((HttpServletResponse)response, (Exception)((Object)e), (String)this.getOAuthRealm());
                        return;
                    }
                    catch (URISyntaxException e) {
                        throw new ServletException((Throwable)e);
                    }
                }
                HttpSession session = request.getSession();
                Object connector = session.getAttribute(CONNECTOR_ATTRIBUTE);
                if (connector == null) {
                    try {
                        Object credentials;
                        if (isTwoLeggedOAuthRequest) {
                            connector = this.tokenToConnectionCache.get("");
                            if (connector == null) {
                                credentials = this.getCredentialsForOAuth(OAUTH_EMPTY_TOKEN_KEY, twoLeggedOAuthConsumerKey);
                                connector = this.login(credentials, request);
                                this.tokenToConnectionCache.put("", connector);
                            }
                            credentials = null;
                        } else {
                            credentials = request.getSession().getAttribute(CREDENTIALS_ATTRIBUTE);
                            if (credentials == null && (credentials = this.getCredentialsFromRequest(request)) == null) {
                                throw new UnauthorizedException();
                            }
                            connector = this.login(credentials, request);
                        }
                        session.setAttribute(CONNECTOR_ATTRIBUTE, connector);
                        session.setAttribute(CREDENTIALS_ATTRIBUTE, credentials);
                    }
                    catch (UnauthorizedException e) {
                        this.sendUnauthorizedResponse(response, e);
                        System.err.println(e.getMessage());
                        return;
                    }
                    catch (ServletException ce) {
                        throw ce;
                    }
                }
                if (connector != null) {
                    this.doChainDoFilterWithConnector(request, response, chain, connector);
                    return;
                }
            }
        }
        chain.doFilter(servletRequest, servletResponse);
    }

    protected void doChainDoFilterWithConnector(HttpServletRequest request, HttpServletResponse response, FilterChain chain, Connection connector) throws IOException, ServletException {
        request.setAttribute(CONNECTOR_ATTRIBUTE, connector);
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    private void validateTwoLeggedOAuthMessage(OAuthMessage message) throws IOException, OAuthException, URISyntaxException {
        OAuthConfiguration config = OAuthConfiguration.getInstance();
        LyoOAuthConsumer consumer = config.getConsumerStore().getConsumer(message.getConsumerKey());
        if (consumer == null || !consumer.isTrusted()) {
            throw new OAuthProblemException("token_rejected");
        }
        OAuthAccessor accessor = new OAuthAccessor((OAuthConsumer)consumer);
        accessor.requestToken = "";
        accessor.tokenSecret = "";
        config.getValidator().validateMessage(message, accessor);
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        OAuthConfiguration config = OAuthConfiguration.getInstance();
        filterConfig.getServletContext().addListener((EventListener)this.listener);
        config.setApplication(new Application(){

            @Override
            public void login(HttpServletRequest request, String id, String password) throws AuthenticationException {
                try {
                    Object creds = AbstractAdapterCredentialsFilter.this.getCredentialsForOAuth(id, password);
                    request.getSession().setAttribute(AbstractAdapterCredentialsFilter.CREDENTIALS_ATTRIBUTE, creds);
                    Object bc = AbstractAdapterCredentialsFilter.this.login(creds, request);
                    request.setAttribute(AbstractAdapterCredentialsFilter.CONNECTOR_ATTRIBUTE, bc);
                    boolean isAdmin = AbstractAdapterCredentialsFilter.this.isAdminSession(id, bc, request);
                    request.getSession().setAttribute(AbstractAdapterCredentialsFilter.ADMIN_SESSION_ATTRIBUTE, (Object)isAdmin);
                }
                catch (Exception e) {
                    throw new AuthenticationException(e.getCause().getMessage(), e);
                }
            }

            @Override
            public String getName() {
                return AbstractAdapterCredentialsFilter.this.getDisplayName();
            }

            @Override
            public boolean isAdminSession(HttpServletRequest request) {
                return Boolean.TRUE.equals(request.getSession().getAttribute(AbstractAdapterCredentialsFilter.ADMIN_SESSION_ATTRIBUTE));
            }

            @Override
            public String getRealm(HttpServletRequest request) {
                return AbstractAdapterCredentialsFilter.this.getOAuthRealm();
            }

            @Override
            public boolean isAuthenticated(HttpServletRequest request) {
                Object connector = request.getSession().getAttribute(AbstractAdapterCredentialsFilter.CONNECTOR_ATTRIBUTE);
                if (connector == null) {
                    return false;
                }
                request.setAttribute(AbstractAdapterCredentialsFilter.CONNECTOR_ATTRIBUTE, connector);
                return true;
            }
        });
        config.setTokenStrategy(new SimpleTokenStrategy(){

            @Override
            public void markRequestTokenAuthorized(HttpServletRequest httpRequest, String requestToken) throws OAuthProblemException {
                AbstractAdapterCredentialsFilter.this.tokenToConnectionCache.put(requestToken, httpRequest.getAttribute(AbstractAdapterCredentialsFilter.CONNECTOR_ATTRIBUTE));
                super.markRequestTokenAuthorized(httpRequest, requestToken);
            }

            @Override
            public void generateAccessToken(OAuthRequest oAuthRequest) throws OAuthProblemException, IOException {
                String requestToken = oAuthRequest.getMessage().getToken();
                Object bc = AbstractAdapterCredentialsFilter.this.tokenToConnectionCache.remove(requestToken);
                super.generateAccessToken(oAuthRequest);
                AbstractAdapterCredentialsFilter.this.tokenToConnectionCache.put(oAuthRequest.getAccessor().accessToken, bc);
            }
        });
        try {
            config.setConsumerStore(this.createConsumerStore());
        }
        catch (Throwable t) {
            System.err.println("Error initializing the OAuth consumer store: " + t.getMessage());
        }
    }

    private void throwInvalidExpiredException(OAuthProblemException e) throws OAuthProblemException {
        OAuthProblemException ope = new OAuthProblemException(JAZZ_INVALID_EXPIRED_TOKEN_OAUTH_PROBLEM);
        ope.setParameter("HTTP status", (Object)new Integer(401));
        throw ope;
    }

    private void sendUnauthorizedResponse(HttpServletResponse response, UnauthorizedException e) throws IOException, ServletException {
        String WWW_AUTHENTICATE_HEADER = "WWW-Authenticate";
        String BASIC_AUTHORIZATION_PREFIX = "Basic ";
        String BASIC_AUTHENTICATION_CHALLENGE = "Basic realm=\"" + this.getOAuthRealm() + "\"";
        String OAUTH_AUTHORIZATION_PREFIX = "OAuth ";
        String OAUTH_AUTHENTICATION_CHALLENGE = "OAuth realm=\"" + this.getOAuthRealm() + "\"";
        response.addHeader("WWW-Authenticate", OAUTH_AUTHENTICATION_CHALLENGE);
        response.addHeader("WWW-Authenticate", BASIC_AUTHENTICATION_CHALLENGE);
        response.sendError(401);
    }
}

