/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lyo.server.oauth.core.consumer;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.oauth.OAuthException;
import net.oauth.OAuthMessage;
import org.eclipse.lyo.server.oauth.core.consumer.ConsumerStore;
import org.eclipse.lyo.server.oauth.core.consumer.LyoOAuthConsumer;

public abstract class AbstractConsumerStore
implements ConsumerStore {
    private Map<String, LyoOAuthConsumer> consumerMap = Collections.synchronizedMap(new HashMap());

    public void addAll(Collection<LyoOAuthConsumer> consumers) {
        for (LyoOAuthConsumer consumer : consumers) {
            this.consumerMap.put(consumer.consumerKey, consumer);
        }
    }

    @Override
    public Collection<LyoOAuthConsumer> getAllConsumers() {
        return this.consumerMap.values();
    }

    @Override
    public LyoOAuthConsumer getConsumer(OAuthMessage requestMessage) throws OAuthException, IOException {
        requestMessage.requireParameters(new String[]{"oauth_consumer_key"});
        return this.getConsumer(requestMessage.getConsumerKey());
    }

    @Override
    public LyoOAuthConsumer getConsumer(String consumerKey) {
        return this.consumerMap.get(consumerKey);
    }

    @Override
    public abstract void closeConsumerStore();

    protected LyoOAuthConsumer add(LyoOAuthConsumer consumer) {
        return this.consumerMap.put(consumer.consumerKey, consumer);
    }

    protected LyoOAuthConsumer remove(String consumerKey) {
        return this.consumerMap.remove(consumerKey);
    }
}

