/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lyo.server.oauth.core;

import java.io.IOException;
import java.net.URISyntaxException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import net.oauth.OAuthAccessor;
import net.oauth.OAuthConsumer;
import net.oauth.OAuthException;
import net.oauth.OAuthMessage;
import net.oauth.OAuthProblemException;
import net.oauth.server.OAuthServlet;
import org.eclipse.lyo.server.oauth.core.OAuthConfiguration;
import org.eclipse.lyo.server.oauth.core.consumer.LyoOAuthConsumer;

public class OAuthRequest {
    private HttpServletRequest httpRequest;
    private OAuthMessage message;
    private OAuthAccessor accessor;

    public OAuthRequest(HttpServletRequest request) throws OAuthException, IOException {
        this.httpRequest = request;
        this.message = OAuthServlet.getMessage((HttpServletRequest)this.httpRequest, null);
        LyoOAuthConsumer consumer = OAuthConfiguration.getInstance().getConsumerStore().getConsumer(this.message);
        if (consumer == null) {
            throw new OAuthProblemException("consumer_key_rejected");
        }
        this.accessor = new OAuthAccessor((OAuthConsumer)consumer);
        String token = this.message.getToken();
        if (token != null) {
            this.accessor.tokenSecret = OAuthConfiguration.getInstance().getTokenStrategy().getTokenSecret(this.httpRequest, token);
        }
    }

    public HttpServletRequest getHttpRequest() {
        return this.httpRequest;
    }

    public void setHttpRequest(HttpServletRequest httpRequest) {
        this.httpRequest = httpRequest;
    }

    public OAuthMessage getMessage() {
        return this.message;
    }

    public OAuthAccessor getAccessor() {
        return this.accessor;
    }

    public LyoOAuthConsumer getConsumer() {
        return (LyoOAuthConsumer)this.accessor.consumer;
    }

    public void validate() throws OAuthException, IOException, ServletException {
        try {
            OAuthConfiguration config = OAuthConfiguration.getInstance();
            config.getValidator().validateMessage(this.message, this.accessor);
            config.getTokenStrategy().validateAccessToken(this);
        }
        catch (URISyntaxException e) {
            throw new ServletException((Throwable)e);
        }
    }
}

