/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lyo.oslc4j.provider.jena;

import com.hp.hpl.jena.datatypes.BaseDatatype;
import com.hp.hpl.jena.datatypes.DatatypeFormatException;
import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.datatypes.xsd.XSDDateTime;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.RSIterator;
import com.hp.hpl.jena.rdf.model.ReifiedStatement;
import com.hp.hpl.jena.rdf.model.ResIterator;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import java.io.StringWriter;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigInteger;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.AbstractSequentialList;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Deque;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Queue;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.logging.Logger;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.namespace.QName;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.lyo.oslc4j.core.NestedWildcardProperties;
import org.eclipse.lyo.oslc4j.core.OSLC4JConstants;
import org.eclipse.lyo.oslc4j.core.SingletonWildcardProperties;
import org.eclipse.lyo.oslc4j.core.annotation.OslcName;
import org.eclipse.lyo.oslc4j.core.annotation.OslcNamespaceDefinition;
import org.eclipse.lyo.oslc4j.core.annotation.OslcPropertyDefinition;
import org.eclipse.lyo.oslc4j.core.annotation.OslcResourceShape;
import org.eclipse.lyo.oslc4j.core.annotation.OslcSchema;
import org.eclipse.lyo.oslc4j.core.annotation.OslcValueType;
import org.eclipse.lyo.oslc4j.core.exception.OslcCoreApplicationException;
import org.eclipse.lyo.oslc4j.core.exception.OslcCoreInvalidPropertyDefinitionException;
import org.eclipse.lyo.oslc4j.core.exception.OslcCoreMissingSetMethodException;
import org.eclipse.lyo.oslc4j.core.exception.OslcCoreMisusedOccursException;
import org.eclipse.lyo.oslc4j.core.exception.OslcCoreRelativeURIException;
import org.eclipse.lyo.oslc4j.core.model.AbstractResource;
import org.eclipse.lyo.oslc4j.core.model.AnyResource;
import org.eclipse.lyo.oslc4j.core.model.IExtendedResource;
import org.eclipse.lyo.oslc4j.core.model.IReifiedResource;
import org.eclipse.lyo.oslc4j.core.model.IResource;
import org.eclipse.lyo.oslc4j.core.model.InheritedMethodAnnotationHelper;
import org.eclipse.lyo.oslc4j.core.model.TypeFactory;
import org.eclipse.lyo.oslc4j.core.model.ValueType;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JenaModelHelper {
    private static final String PROPERTY_TOTAL_COUNT = "totalCount";
    private static final String PROPERTY_NEXT_PAGE = "nextPage";
    private static final String RDF_TYPE_URI = "http://www.w3.org/1999/02/22-rdf-syntax-ns#type";
    private static final BaseDatatype RDF_TYPE_XMLLITERAL = new BaseDatatype("http://www.w3.org/1999/02/22-rdf-syntax-ns#XMLLiteral");
    private static final String METHOD_NAME_START_GET = "get";
    private static final String METHOD_NAME_START_IS = "is";
    private static final String METHOD_NAME_START_SET = "set";
    private static final int METHOD_NAME_START_GET_LENGTH = "get".length();
    private static final int METHOD_NAME_START_IS_LENGTH = "is".length();
    private static final String GENERATED_PREFIX_START = "j.";
    private static final Logger logger = Logger.getLogger(JenaModelHelper.class.getName());

    private JenaModelHelper() {
    }

    public static Model createJenaModel(Object[] objects) throws DatatypeConfigurationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, OslcCoreApplicationException {
        return JenaModelHelper.createJenaModel(null, null, null, objects, null);
    }

    static Model createJenaModel(String descriptionAbout, String responseInfoAbout, String nextPageAbout, Object[] objects, Map<String, Object> properties) throws DatatypeConfigurationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, OslcCoreApplicationException {
        Model model = ModelFactory.createDefaultModel();
        HashMap<String, String> namespaceMappings = new HashMap<String, String>();
        Resource descriptionResource = null;
        if (descriptionAbout != null) {
            descriptionResource = model.createResource(descriptionAbout);
            if (responseInfoAbout != null) {
                Resource responseInfoResource = model.createResource(responseInfoAbout, (Resource)model.createProperty("http://open-services.net/ns/core#ResponseInfo"));
                responseInfoResource.addProperty(model.createProperty("http://open-services.net/ns/core#", PROPERTY_TOTAL_COUNT), String.valueOf(objects.length));
                if (nextPageAbout != null) {
                    responseInfoResource.addProperty(model.createProperty("http://open-services.net/ns/core#", PROPERTY_NEXT_PAGE), nextPageAbout);
                }
            }
        }
        for (Object object : objects) {
            JenaModelHelper.handleSingleResource(descriptionResource, object, model, namespaceMappings, properties);
        }
        if (descriptionAbout != null) {
            JenaModelHelper.ensureNamespacePrefix("rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns#", namespaceMappings);
            JenaModelHelper.ensureNamespacePrefix("rdfs", "http://www.w3.org/2000/01/rdf-schema#", namespaceMappings);
            if (responseInfoAbout != null) {
                JenaModelHelper.ensureNamespacePrefix("oslc", "http://open-services.net/ns/core#", namespaceMappings);
            }
        }
        for (Map.Entry namespaceMapping : namespaceMappings.entrySet()) {
            model.setNsPrefix((String)namespaceMapping.getKey(), (String)namespaceMapping.getValue());
        }
        return model;
    }

    private static void handleSingleResource(Resource descriptionResource, Object object, Model model, Map<String, String> namespaceMappings, Map<String, Object> properties) throws DatatypeConfigurationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, OslcCoreApplicationException {
        Resource mainResource;
        Class<?> objectClass = object.getClass();
        JenaModelHelper.recursivelyCollectNamespaceMappings(namespaceMappings, objectClass);
        URI aboutURI = null;
        if (object instanceof IResource) {
            aboutURI = ((IResource)object).getAbout();
        }
        if (aboutURI != null) {
            if (!aboutURI.isAbsolute()) {
                throw new OslcCoreRelativeURIException(objectClass, "getAbout", aboutURI);
            }
            mainResource = model.createResource(aboutURI.toString());
        } else {
            mainResource = model.createResource();
        }
        if (objectClass.getAnnotation(OslcResourceShape.class) != null) {
            String namespace = TypeFactory.getNamespace(objectClass);
            String name = TypeFactory.getName(objectClass);
            mainResource.addProperty(RDF.type, (RDFNode)model.createResource(namespace + name));
        }
        JenaModelHelper.buildResource(object, objectClass, model, mainResource, properties);
        if (descriptionResource != null) {
            descriptionResource.addProperty(RDFS.member, (RDFNode)mainResource);
        }
    }

    public static Object fromJenaResource(Resource resource, Class<?> beanClass) throws DatatypeConfigurationException, IllegalAccessException, IllegalArgumentException, InstantiationException, InvocationTargetException, OslcCoreApplicationException, URISyntaxException, SecurityException, NoSuchMethodException {
        Object newInstance = beanClass.newInstance();
        HashMap classPropertyDefinitionsToSetMethods = new HashMap();
        HashMap<String, Object> visitedResources = new HashMap<String, Object>();
        JenaModelHelper.fromResource(classPropertyDefinitionsToSetMethods, beanClass, newInstance, resource, visitedResources);
        return newInstance;
    }

    public static Object[] fromJenaModel(Model model, Class<?> beanClass) throws DatatypeConfigurationException, IllegalAccessException, IllegalArgumentException, InstantiationException, InvocationTargetException, OslcCoreApplicationException, URISyntaxException, SecurityException, NoSuchMethodException {
        String qualifiedName;
        ResIterator listSubjects;
        ArrayList results = new ArrayList();
        if (beanClass.getAnnotation(OslcResourceShape.class) != null && (listSubjects = model.listSubjectsWithProperty(RDF.type, (RDFNode)model.getResource(qualifiedName = TypeFactory.getQualifiedName(beanClass)))).hasNext()) {
            HashMap classPropertyDefinitionsToSetMethods = new HashMap();
            while (listSubjects.hasNext()) {
                Resource resource = (Resource)listSubjects.next();
                Object newInstance = beanClass.newInstance();
                HashMap<String, Object> visitedResources = new HashMap<String, Object>();
                JenaModelHelper.fromResource(classPropertyDefinitionsToSetMethods, beanClass, newInstance, resource, visitedResources);
                results.add(newInstance);
            }
        }
        return results.toArray((Object[])Array.newInstance(beanClass, results.size()));
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void fromResource(Map<Class<?>, Map<String, Method>> classPropertyDefinitionsToSetMethods, Class<?> beanClass, Object bean, Resource resource, Map<String, Object> visitedResources) throws DatatypeConfigurationException, IllegalAccessException, IllegalArgumentException, InstantiationException, InvocationTargetException, OslcCoreApplicationException, URISyntaxException, SecurityException, NoSuchMethodException {
        Method setMethod;
        HashMap<QName, Object> extendedProperties;
        IExtendedResource extendedResource;
        String aboutURIString;
        Map<String, Method> setMethodMap = classPropertyDefinitionsToSetMethods.get(beanClass);
        if (setMethodMap == null) {
            setMethodMap = JenaModelHelper.createPropertyDefinitionToSetMethods(beanClass);
            classPropertyDefinitionsToSetMethods.put(beanClass, setMethodMap);
        }
        visitedResources.put(JenaModelHelper.getVisitedResourceName(resource), bean);
        if (bean instanceof IResource && (aboutURIString = resource.getURI()) != null) {
            URI aboutURI = new URI(aboutURIString);
            if (aboutURI.isAbsolute()) {
                ((IResource)bean).setAbout(aboutURI);
            } else if (!(bean instanceof AbstractResource)) {
                throw new OslcCoreRelativeURIException(beanClass, "setAbout", aboutURI);
            }
        }
        HashMap<String, ArrayList<String>> propertyDefinitionsToArrayValues = new HashMap<String, ArrayList<String>>();
        HashSet<Method> singleValueMethodsUsed = new HashSet<Method>();
        StmtIterator listProperties = resource.listProperties();
        if (bean instanceof IExtendedResource) {
            extendedResource = (IExtendedResource)bean;
            extendedProperties = new HashMap<QName, Object>();
            extendedResource.setExtendedProperties(extendedProperties);
        } else {
            extendedResource = null;
            extendedProperties = null;
        }
        while (listProperties.hasNext()) {
            boolean bl;
            Statement statement = (Statement)listProperties.next();
            Property predicate = statement.getPredicate();
            RDFNode object = statement.getObject();
            String uri = predicate.getURI();
            setMethod = setMethodMap.get(uri);
            if (setMethod == null) {
                ArrayList<Object> collection;
                if (RDF_TYPE_URI.equals(uri)) {
                    if (extendedResource == null) continue;
                    URI type = new URI(object.asResource().getURI());
                    extendedResource.addType(type);
                    continue;
                }
                if (extendedProperties == null) {
                    logger.fine("Set method not found for object type:  " + beanClass.getName() + ", uri:  " + uri);
                    continue;
                }
                String prefix = resource.getModel().getNsURIPrefix(predicate.getNameSpace());
                if (prefix == null) {
                    prefix = JenaModelHelper.generatePrefix(resource.getModel(), predicate.getNameSpace());
                }
                QName qName = new QName(predicate.getNameSpace(), predicate.getLocalName(), prefix);
                Object value = JenaModelHelper.handleExtendedPropertyValue(beanClass, object, visitedResources);
                Object previous = extendedProperties.get(qName);
                if (previous == null) {
                    extendedProperties.put(qName, value);
                    continue;
                }
                if (previous instanceof Collection) {
                    collection = (ArrayList<Object>)previous;
                } else {
                    collection = new ArrayList<Object>();
                    collection.add(previous);
                    extendedProperties.put(qName, collection);
                }
                collection.add(value);
                continue;
            }
            Class setMethodComponentParameterClass = setMethod.getParameterTypes()[0];
            boolean bl2 = setMethodComponentParameterClass.isArray();
            if (bl2) {
                setMethodComponentParameterClass = setMethodComponentParameterClass.getComponentType();
            } else if (Collection.class.isAssignableFrom(setMethodComponentParameterClass)) {
                Type actualTypeArgument;
                ParameterizedType parameterizedType;
                Type[] actualTypeArguments;
                bl = true;
                Type genericParameterType = setMethod.getGenericParameterTypes()[0];
                if (genericParameterType instanceof ParameterizedType && (actualTypeArguments = (parameterizedType = (ParameterizedType)genericParameterType).getActualTypeArguments()).length == 1 && (actualTypeArgument = actualTypeArguments[0]) instanceof Class) {
                    setMethodComponentParameterClass = (Class)actualTypeArgument;
                }
            }
            Class reifiedClass = null;
            if (IReifiedResource.class.isAssignableFrom(setMethodComponentParameterClass)) {
                Type actualTypeArgument;
                ParameterizedType parameterizedType;
                Type[] actualTypeArguments;
                reifiedClass = setMethodComponentParameterClass;
                Type genericType = setMethodComponentParameterClass.getGenericSuperclass();
                if (genericType instanceof ParameterizedType && (actualTypeArguments = (parameterizedType = (ParameterizedType)genericType).getActualTypeArguments()).length == 1 && (actualTypeArgument = actualTypeArguments[0]) instanceof Class) {
                    setMethodComponentParameterClass = (Class)actualTypeArgument;
                }
            }
            Object parameter = null;
            if (object.isLiteral()) {
                Literal literal = object.asLiteral();
                String stringValue = literal.getString();
                if (String.class == setMethodComponentParameterClass) {
                    parameter = stringValue;
                } else if (Boolean.class == setMethodComponentParameterClass || Boolean.TYPE == setMethodComponentParameterClass) {
                    if (Boolean.TRUE.toString().equals(stringValue) || "1".equals(stringValue)) {
                        parameter = Boolean.TRUE;
                    } else {
                        if (!Boolean.FALSE.toString().equals(stringValue) && !"0".equals(stringValue)) throw new IllegalArgumentException("'" + stringValue + "' has wrong format for Boolean.");
                        parameter = Boolean.FALSE;
                    }
                } else if (Byte.class == setMethodComponentParameterClass || Byte.TYPE == setMethodComponentParameterClass) {
                    parameter = Byte.valueOf(stringValue);
                } else if (Short.class == setMethodComponentParameterClass || Short.TYPE == setMethodComponentParameterClass) {
                    parameter = Short.valueOf(stringValue);
                } else if (Integer.class == setMethodComponentParameterClass || Integer.TYPE == setMethodComponentParameterClass) {
                    parameter = Integer.valueOf(stringValue);
                } else if (Long.class == setMethodComponentParameterClass || Long.TYPE == setMethodComponentParameterClass) {
                    parameter = Long.valueOf(stringValue);
                } else if (BigInteger.class == setMethodComponentParameterClass) {
                    parameter = new BigInteger(stringValue);
                } else if (Float.class == setMethodComponentParameterClass || Float.TYPE == setMethodComponentParameterClass) {
                    parameter = Float.valueOf(stringValue);
                } else if (Double.class == setMethodComponentParameterClass || Double.TYPE == setMethodComponentParameterClass) {
                    parameter = Double.valueOf(stringValue);
                } else if (Date.class == setMethodComponentParameterClass) {
                    parameter = DatatypeFactory.newInstance().newXMLGregorianCalendar(stringValue).toGregorianCalendar().getTime();
                }
            } else if (object.isResource()) {
                Resource nestedResource = object.asResource();
                if (URI.class == setMethodComponentParameterClass) {
                    String nestedResourceURIString = nestedResource.getURI();
                    if (nestedResourceURIString != null) {
                        URI nestedResourceURI = new URI(nestedResourceURIString);
                        if (!nestedResourceURI.isAbsolute()) {
                            throw new OslcCoreRelativeURIException(beanClass, setMethod.getName(), nestedResourceURI);
                        }
                        parameter = nestedResourceURI;
                    }
                } else {
                    Object nestedBean = setMethodComponentParameterClass.newInstance();
                    JenaModelHelper.fromResource(classPropertyDefinitionsToSetMethods, setMethodComponentParameterClass, nestedBean, nestedResource, visitedResources);
                    parameter = nestedBean;
                }
            }
            if (parameter == null) continue;
            if (reifiedClass != null) {
                Object reifiedResource = reifiedClass.newInstance();
                for (Method method : reifiedClass.getMethods()) {
                    Class<?>[] parameterTypes;
                    if (!"setValue".equals(method.getName()) || (parameterTypes = method.getParameterTypes()).length != 1 || !parameterTypes[0].isAssignableFrom(setMethodComponentParameterClass)) continue;
                    method.invoke(reifiedResource, parameter);
                    break;
                }
                RSIterator rsIter = statement.listReifiedStatements();
                while (rsIter.hasNext()) {
                    ReifiedStatement reifiedStatement = (ReifiedStatement)rsIter.next();
                    JenaModelHelper.fromResource(classPropertyDefinitionsToSetMethods, reifiedClass, reifiedResource, (Resource)reifiedStatement, visitedResources);
                }
                parameter = reifiedResource;
            }
            if (bl) {
                ArrayList<String> values = (ArrayList<String>)propertyDefinitionsToArrayValues.get(uri);
                if (values == null) {
                    values = new ArrayList<String>();
                    propertyDefinitionsToArrayValues.put(uri, values);
                }
                values.add((String)parameter);
                continue;
            }
            if (singleValueMethodsUsed.contains(setMethod)) {
                throw new OslcCoreMisusedOccursException(beanClass, setMethod);
            }
            setMethod.invoke(bean, parameter);
            singleValueMethodsUsed.add(setMethod);
        }
        for (Map.Entry propertyDefinitionToArrayValues : propertyDefinitionsToArrayValues.entrySet()) {
            void var17_26;
            String uri = (String)propertyDefinitionToArrayValues.getKey();
            List values = (List)propertyDefinitionToArrayValues.getValue();
            setMethod = setMethodMap.get(uri);
            Class<?> parameterClass = setMethod.getParameterTypes()[0];
            if (parameterClass.isArray()) {
                Class<?> clazz = parameterClass.getComponentType();
                Object array = Array.newInstance(clazz, values.size());
                int index = 0;
                for (Object value : values) {
                    Array.set(array, index++, value);
                }
                setMethod.invoke(bean, array);
                continue;
            }
            if (Collection.class == parameterClass || List.class == parameterClass || Deque.class == parameterClass || Queue.class == parameterClass || AbstractCollection.class == parameterClass || AbstractList.class == parameterClass || AbstractSequentialList.class == parameterClass) {
                LinkedList linkedList = new LinkedList();
            } else if (Set.class == parameterClass || AbstractSet.class == parameterClass) {
                HashSet hashSet = new HashSet();
            } else if (SortedSet.class == parameterClass || NavigableSet.class == parameterClass) {
                TreeSet treeSet = new TreeSet();
            } else {
                Collection tempCollection;
                Collection collection = tempCollection = (Collection)parameterClass.newInstance();
            }
            var17_26.addAll(values);
            setMethod.invoke(bean, var17_26);
        }
    }

    private static String generatePrefix(Model model, String namespace) {
        String candidatePrefix;
        Map map = model.getNsPrefixMap();
        int i = 0;
        do {
            candidatePrefix = GENERATED_PREFIX_START + i;
            ++i;
        } while (map.containsKey(candidatePrefix));
        model.setNsPrefix(candidatePrefix, namespace);
        return candidatePrefix;
    }

    private static Object handleExtendedPropertyValue(Class<?> beanClass, RDFNode object, Map<String, Object> visitedResources) throws URISyntaxException, IllegalArgumentException, SecurityException, DatatypeConfigurationException, IllegalAccessException, InstantiationException, InvocationTargetException, OslcCoreApplicationException, NoSuchMethodException {
        if (object.isLiteral()) {
            try {
                Object literalValue = object.asLiteral().getValue();
                if (literalValue instanceof XSDDateTime) {
                    XSDDateTime xsdDateTime = (XSDDateTime)literalValue;
                    return xsdDateTime.asCalendar().getTime();
                }
                return literalValue;
            }
            catch (DatatypeFormatException e) {
                return object.asLiteral().getString();
            }
        }
        Resource nestedResource = object.asResource();
        if ((nestedResource.getURI() == null || nestedResource.listProperties().hasNext()) && !visitedResources.containsKey(JenaModelHelper.getVisitedResourceName(nestedResource))) {
            AnyResource any = new AnyResource();
            HashMap classPropertyDefinitionsToSetMethods = new HashMap();
            JenaModelHelper.fromResource(classPropertyDefinitionsToSetMethods, AnyResource.class, any, nestedResource, visitedResources);
            return any;
        }
        if (nestedResource.getURI() == null || nestedResource.listProperties().hasNext()) {
            return visitedResources.get(JenaModelHelper.getVisitedResourceName(nestedResource));
        }
        URI nestedResourceURI = new URI(nestedResource.getURI());
        if (!nestedResourceURI.isAbsolute()) {
            throw new OslcCoreRelativeURIException(beanClass, "<none>", nestedResourceURI);
        }
        return nestedResourceURI;
    }

    private static Map<String, Method> createPropertyDefinitionToSetMethods(Class<?> beanClass) throws OslcCoreApplicationException {
        Method[] methods;
        HashMap<String, Method> result = new HashMap<String, Method>();
        for (Method method : methods = beanClass.getMethods()) {
            OslcPropertyDefinition oslcPropertyDefinitionAnnotation;
            String getMethodName;
            if (method.getParameterTypes().length != 0 || (!(getMethodName = method.getName()).startsWith(METHOD_NAME_START_GET) || getMethodName.length() <= METHOD_NAME_START_GET_LENGTH) && (!getMethodName.startsWith(METHOD_NAME_START_IS) || getMethodName.length() <= METHOD_NAME_START_IS_LENGTH) || (oslcPropertyDefinitionAnnotation = (OslcPropertyDefinition)InheritedMethodAnnotationHelper.getAnnotation((Method)method, OslcPropertyDefinition.class)) == null) continue;
            String setMethodName = getMethodName.startsWith(METHOD_NAME_START_GET) ? METHOD_NAME_START_SET + getMethodName.substring(METHOD_NAME_START_GET_LENGTH) : METHOD_NAME_START_SET + getMethodName.substring(METHOD_NAME_START_IS_LENGTH);
            Class<?> getMethodReturnType = method.getReturnType();
            try {
                Method setMethod = beanClass.getMethod(setMethodName, getMethodReturnType);
                result.put(oslcPropertyDefinitionAnnotation.value(), setMethod);
            }
            catch (NoSuchMethodException exception) {
                throw new OslcCoreMissingSetMethodException(beanClass, method, (Exception)exception);
            }
        }
        return result;
    }

    private static void buildResource(Object object, Class<?> resourceClass, Model model, Resource mainResource, Map<String, Object> properties) throws DatatypeConfigurationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, OslcCoreApplicationException {
        if (properties == OSLC4JConstants.OSL4J_PROPERTY_SINGLETON) {
            return;
        }
        for (Method method : resourceClass.getMethods()) {
            Object value;
            OslcPropertyDefinition oslcPropertyDefinitionAnnotation;
            String methodName;
            if (method.getParameterTypes().length != 0 || (!(methodName = method.getName()).startsWith(METHOD_NAME_START_GET) || methodName.length() <= METHOD_NAME_START_GET_LENGTH) && (!methodName.startsWith(METHOD_NAME_START_IS) || methodName.length() <= METHOD_NAME_START_IS_LENGTH) || (oslcPropertyDefinitionAnnotation = (OslcPropertyDefinition)InheritedMethodAnnotationHelper.getAnnotation((Method)method, OslcPropertyDefinition.class)) == null || (value = method.invoke(object, new Object[0])) == null) continue;
            Map nestedProperties = null;
            boolean onlyNested = false;
            if (properties != null) {
                Map map = (Map)properties.get(oslcPropertyDefinitionAnnotation.value());
                if (map != null) {
                    nestedProperties = map;
                } else if (properties instanceof SingletonWildcardProperties && !(properties instanceof NestedWildcardProperties)) {
                    nestedProperties = OSLC4JConstants.OSL4J_PROPERTY_SINGLETON;
                } else {
                    if (!(properties instanceof NestedWildcardProperties)) continue;
                    nestedProperties = ((NestedWildcardProperties)properties).commonNestedProperties();
                    onlyNested = !(properties instanceof SingletonWildcardProperties);
                }
            }
            JenaModelHelper.buildAttributeResource(resourceClass, method, oslcPropertyDefinitionAnnotation, model, mainResource, value, nestedProperties, onlyNested);
        }
        if (object instanceof IExtendedResource) {
            IExtendedResource extendedResource = (IExtendedResource)object;
            HashMap<IExtendedResource, Resource> visitedResources = new HashMap<IExtendedResource, Resource>();
            JenaModelHelper.handleExtendedProperties(resourceClass, model, mainResource, extendedResource, properties, visitedResources);
        }
    }

    protected static void handleExtendedProperties(Class<?> resourceClass, Model model, Resource mainResource, IExtendedResource extendedResource, Map<String, Object> properties, Map<IExtendedResource, Resource> visitedResources) throws DatatypeConfigurationException, IllegalAccessException, InvocationTargetException, OslcCoreApplicationException {
        visitedResources.put(extendedResource, mainResource);
        for (URI type : extendedResource.getTypes()) {
            Resource typeResource;
            String propertyName = type.toString();
            if (properties != null && properties.get(propertyName) == null && !(properties instanceof NestedWildcardProperties) && !(properties instanceof SingletonWildcardProperties) || mainResource.hasProperty(RDF.type, (RDFNode)(typeResource = model.createResource(propertyName)))) continue;
            mainResource.addProperty(RDF.type, (RDFNode)typeResource);
        }
        Transformer transformer = JenaModelHelper.createTransformer();
        for (Map.Entry extendedProperty : extendedResource.getExtendedProperties().entrySet()) {
            QName qName = (QName)extendedProperty.getKey();
            String propertyName = qName.getNamespaceURI() + qName.getLocalPart();
            Map nestedProperties = null;
            boolean onlyNested = false;
            if (properties != null) {
                Map map = (Map)properties.get(propertyName);
                if (map != null) {
                    nestedProperties = map;
                } else if (properties instanceof SingletonWildcardProperties && !(properties instanceof NestedWildcardProperties)) {
                    nestedProperties = OSLC4JConstants.OSL4J_PROPERTY_SINGLETON;
                } else {
                    if (!(properties instanceof NestedWildcardProperties)) continue;
                    nestedProperties = ((NestedWildcardProperties)properties).commonNestedProperties();
                    onlyNested = !(properties instanceof SingletonWildcardProperties);
                }
            }
            Property property = model.createProperty(propertyName);
            Object value = extendedProperty.getValue();
            if (value instanceof Collection) {
                Collection collection = (Collection)value;
                for (Object next : collection) {
                    JenaModelHelper.handleExtendedValue(resourceClass, next, model, mainResource, property, nestedProperties, onlyNested, visitedResources, transformer);
                }
                continue;
            }
            JenaModelHelper.handleExtendedValue(resourceClass, value, model, mainResource, property, nestedProperties, onlyNested, visitedResources, transformer);
        }
    }

    private static void handleExtendedValue(Class<?> objectClass, Object value, Model model, Resource resource, Property property, Map<String, Object> nestedProperties, boolean onlyNested, Map<IExtendedResource, Resource> visitedResources, Transformer transformer) throws DatatypeConfigurationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, OslcCoreApplicationException {
        if (value instanceof AnyResource) {
            AbstractResource any = (AbstractResource)value;
            if (!visitedResources.containsKey(any)) {
                Resource nestedResource;
                URI aboutURI = any.getAbout();
                if (aboutURI != null) {
                    if (!aboutURI.isAbsolute()) {
                        throw new OslcCoreRelativeURIException(AnyResource.class, "getAbout", aboutURI);
                    }
                    nestedResource = model.createResource(aboutURI.toString());
                } else {
                    nestedResource = model.createResource();
                }
                for (URI type : any.getTypes()) {
                    String propertyName = type.toString();
                    if (nestedProperties != null && nestedProperties.get(propertyName) == null && !(nestedProperties instanceof NestedWildcardProperties) && !(nestedProperties instanceof SingletonWildcardProperties)) continue;
                    nestedResource.addProperty(RDF.type, (RDFNode)model.createResource(propertyName));
                }
                JenaModelHelper.handleExtendedProperties(AnyResource.class, model, nestedResource, (IExtendedResource)any, nestedProperties, visitedResources);
                resource.addProperty(property, (RDFNode)nestedResource);
            } else {
                resource.addProperty(property, (RDFNode)visitedResources.get(any));
            }
        } else if (value.getClass().getAnnotation(OslcResourceShape.class) != null || value instanceof URI) {
            boolean xmlliteral = false;
            JenaModelHelper.handleLocalResource(objectClass, null, xmlliteral, value, model, resource, property, nestedProperties, onlyNested);
        } else if (value instanceof Date) {
            if (onlyNested) {
                return;
            }
            Calendar cal = Calendar.getInstance();
            cal.setTime((Date)value);
            resource.addProperty(property, (RDFNode)model.createTypedLiteral(cal));
        } else if (value instanceof Element) {
            StreamResult result = new StreamResult(new StringWriter());
            DOMSource source = new DOMSource((Element)value);
            try {
                transformer.transform(source, result);
            }
            catch (TransformerException e) {
                throw new RuntimeException(e);
            }
            Literal xmlString = model.createLiteral(result.getWriter().toString(), true);
            resource.addProperty(property, (RDFNode)xmlString);
        } else {
            if (onlyNested) {
                return;
            }
            resource.addProperty(property, (RDFNode)model.createTypedLiteral(value));
        }
    }

    private static void buildAttributeResource(Class<?> resourceClass, Method method, OslcPropertyDefinition propertyDefinitionAnnotation, Model model, Resource resource, Object value, Map<String, Object> nestedProperties, boolean onlyNested) throws DatatypeConfigurationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, OslcCoreApplicationException {
        OslcName nameAnnotation;
        String name;
        String propertyDefinition = propertyDefinitionAnnotation.value();
        if (!propertyDefinition.endsWith(name = (nameAnnotation = (OslcName)InheritedMethodAnnotationHelper.getAnnotation((Method)method, OslcName.class)) != null ? nameAnnotation.value() : JenaModelHelper.getDefaultPropertyName(method))) {
            throw new OslcCoreInvalidPropertyDefinitionException(resourceClass, method, propertyDefinitionAnnotation);
        }
        OslcValueType valueTypeAnnotation = (OslcValueType)InheritedMethodAnnotationHelper.getAnnotation((Method)method, OslcValueType.class);
        boolean xmlLiteral = valueTypeAnnotation == null ? false : ValueType.XMLLiteral.equals((Object)valueTypeAnnotation.value());
        Property attribute = model.createProperty(propertyDefinition);
        Class<?> returnType = method.getReturnType();
        if (returnType.isArray()) {
            int length = Array.getLength(value);
            for (int index = 0; index < length; ++index) {
                Object object = Array.get(value, index);
                JenaModelHelper.handleLocalResource(resourceClass, method, xmlLiteral, object, model, resource, attribute, nestedProperties, onlyNested);
            }
        } else if (Collection.class.isAssignableFrom(returnType)) {
            Collection collection = (Collection)value;
            for (Object object : collection) {
                JenaModelHelper.handleLocalResource(resourceClass, method, xmlLiteral, object, model, resource, attribute, nestedProperties, onlyNested);
            }
        } else {
            JenaModelHelper.handleLocalResource(resourceClass, method, xmlLiteral, value, model, resource, attribute, nestedProperties, onlyNested);
        }
    }

    private static void handleLocalResource(Class<?> resourceClass, Method method, boolean xmlLiteral, Object object, Model model, Resource resource, Property attribute, Map<String, Object> nestedProperties, boolean onlyNested) throws DatatypeConfigurationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, OslcCoreApplicationException {
        Object value;
        Class<?> objectClass = object.getClass();
        Statement statement = null;
        IReifiedResource reifiedResource = object instanceof IReifiedResource ? (IReifiedResource)object : null;
        Object object2 = value = reifiedResource == null ? object : reifiedResource.getValue();
        if (value instanceof String) {
            if (onlyNested) {
                return;
            }
            statement = xmlLiteral ? model.createStatement(resource, attribute, (RDFNode)model.createTypedLiteral(value.toString(), (RDFDatatype)RDF_TYPE_XMLLITERAL)) : model.createStatement(resource, attribute, value.toString());
        } else if (value instanceof Boolean || value instanceof Number) {
            if (onlyNested) {
                return;
            }
            statement = model.createStatement(resource, attribute, value.toString());
        } else if (value instanceof URI) {
            if (onlyNested) {
                return;
            }
            URI uri = (URI)value;
            if (!uri.isAbsolute()) {
                throw new OslcCoreRelativeURIException(resourceClass, method == null ? "<none>" : method.getName(), uri);
            }
            statement = model.createStatement(resource, attribute, (RDFNode)model.createResource(value.toString()));
        } else if (value instanceof Date) {
            if (onlyNested) {
                return;
            }
            GregorianCalendar calendar = new GregorianCalendar();
            calendar.setTime((Date)value);
            String string = DatatypeFactory.newInstance().newXMLGregorianCalendar(calendar).toString();
            statement = model.createStatement(resource, attribute, string);
        } else if (objectClass.getAnnotation(OslcResourceShape.class) != null) {
            Resource nestedResource;
            String namespace = TypeFactory.getNamespace(objectClass);
            String name = TypeFactory.getName(objectClass);
            URI aboutURI = null;
            if (value instanceof IResource) {
                aboutURI = ((IResource)value).getAbout();
            }
            if (aboutURI != null) {
                if (!aboutURI.isAbsolute()) {
                    throw new OslcCoreRelativeURIException(objectClass, "getAbout", aboutURI);
                }
                nestedResource = model.createResource(aboutURI.toString(), (Resource)model.createProperty(namespace, name));
            } else {
                nestedResource = model.createResource((Resource)model.createProperty(namespace, name));
            }
            JenaModelHelper.buildResource(value, objectClass, model, nestedResource, nestedProperties);
            statement = model.createStatement(resource, attribute, (RDFNode)nestedResource);
        }
        if (statement != null) {
            if (reifiedResource != null && nestedProperties != OSLC4JConstants.OSL4J_PROPERTY_SINGLETON) {
                JenaModelHelper.addReifiedStatements(model, statement, reifiedResource, nestedProperties);
            }
            model.add(statement);
        }
    }

    private static void addReifiedStatements(Model model, Statement statement, IReifiedResource<?> reifiedResource, Map<String, Object> nestedProperties) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, DatatypeConfigurationException, OslcCoreApplicationException {
        ReifiedStatement reifiedStatement = statement.createReifiedStatement();
        JenaModelHelper.buildResource(reifiedResource, reifiedResource.getClass(), model, (Resource)reifiedStatement, nestedProperties);
    }

    private static String getDefaultPropertyName(Method method) {
        String methodName = method.getName();
        int startingIndex = methodName.startsWith(METHOD_NAME_START_GET) ? METHOD_NAME_START_GET_LENGTH : METHOD_NAME_START_IS_LENGTH;
        int endingIndex = startingIndex + 1;
        String lowercasedFirstCharacter = methodName.substring(startingIndex, endingIndex).toLowerCase();
        if (methodName.length() == endingIndex) {
            return lowercasedFirstCharacter;
        }
        return lowercasedFirstCharacter + methodName.substring(endingIndex);
    }

    private static void recursivelyCollectNamespaceMappings(Map<String, String> namespaceMappings, Class<? extends Object> resourceClass) {
        Class<?>[] interfaces;
        Class<? extends Object> superClass;
        OslcSchema oslcSchemaAnnotation = resourceClass.getPackage().getAnnotation(OslcSchema.class);
        if (oslcSchemaAnnotation != null) {
            OslcNamespaceDefinition[] oslcNamespaceDefinitionAnnotations;
            for (OslcNamespaceDefinition oslcNamespaceDefinitionAnnotation : oslcNamespaceDefinitionAnnotations = oslcSchemaAnnotation.value()) {
                String prefix = oslcNamespaceDefinitionAnnotation.prefix();
                String namespaceURI = oslcNamespaceDefinitionAnnotation.namespaceURI();
                namespaceMappings.put(prefix, namespaceURI);
            }
        }
        if ((superClass = resourceClass.getSuperclass()) != null) {
            JenaModelHelper.recursivelyCollectNamespaceMappings(namespaceMappings, superClass);
        }
        if ((interfaces = resourceClass.getInterfaces()) != null) {
            for (Class<?> interfac : interfaces) {
                JenaModelHelper.recursivelyCollectNamespaceMappings(namespaceMappings, interfac);
            }
        }
    }

    private static void ensureNamespacePrefix(String prefix, String namespace, Map<String, String> namespaceMappings) {
        if (!namespaceMappings.containsValue(namespace)) {
            if (!namespaceMappings.containsKey(prefix)) {
                namespaceMappings.put(prefix, namespace);
            } else {
                int index = 1;
                while (true) {
                    String newPrefix;
                    if (!namespaceMappings.containsKey(newPrefix = prefix + index)) {
                        namespaceMappings.put(newPrefix, namespace);
                        return;
                    }
                    ++index;
                }
            }
        }
    }

    private static String getVisitedResourceName(Resource resource) {
        String visitedResourceName = null;
        visitedResourceName = resource.getURI() != null ? resource.getURI() : resource.getId().toString();
        return visitedResourceName;
    }

    private static Transformer createTransformer() {
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            return transformer;
        }
        catch (TransformerException e) {
            throw new RuntimeException(e);
        }
    }
}

