/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lyo.oslc4j.client;

import java.net.InetAddress;
import java.util.logging.Logger;

public final class ServiceProviderRegistryURIs {
    private static final Logger LOGGER = Logger.getLogger(ServiceProviderRegistryURIs.class.getName());
    private static final String SYSTEM_PROPERTY_NAME_REGISTRY_URI = ServiceProviderRegistryURIs.class.getPackage().getName() + ".registryuri";
    private static final String SYSTEM_PROPERTY_NAME_UI_URI = ServiceProviderRegistryURIs.class.getPackage().getName() + ".uiuri";
    private static final String SERVICE_PROVIDER_REGISTRY_URI;
    private static final String UI_URI;

    private ServiceProviderRegistryURIs() {
    }

    public static String getServiceProviderRegistryURI() {
        return SERVICE_PROVIDER_REGISTRY_URI;
    }

    public static String getUIURI() {
        return UI_URI;
    }

    static {
        String registryURI = System.getProperty(SYSTEM_PROPERTY_NAME_REGISTRY_URI);
        String uiURI = System.getProperty(SYSTEM_PROPERTY_NAME_UI_URI);
        String defaultBase = null;
        if (registryURI == null || uiURI == null) {
            String hostName = "localhost";
            try {
                hostName = InetAddress.getLocalHost().getCanonicalHostName();
            }
            catch (Exception exception) {
                // empty catch block
            }
            defaultBase = "http://" + hostName + ":8080/";
        }
        if (registryURI != null) {
            SERVICE_PROVIDER_REGISTRY_URI = registryURI;
        } else {
            SERVICE_PROVIDER_REGISTRY_URI = defaultBase + "OSLC4JRegistry/catalog/singleton";
            LOGGER.warning("System property '" + SYSTEM_PROPERTY_NAME_REGISTRY_URI + "' not set.  Using calculated value '" + SERVICE_PROVIDER_REGISTRY_URI + "'");
        }
        if (uiURI != null) {
            UI_URI = uiURI;
        } else {
            UI_URI = defaultBase + "OSLC4JUI";
            LOGGER.warning("System property '" + SYSTEM_PROPERTY_NAME_UI_URI + "' not set.  Using calculated value '" + UI_URI + "'");
        }
    }
}

