/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lyo.oslc4j.application;

import java.net.URISyntaxException;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.wink.common.AbstractDynamicResource;
import org.eclipse.lyo.oslc4j.core.OSLC4JUtils;
import org.eclipse.lyo.oslc4j.core.exception.OslcCoreApplicationException;
import org.eclipse.lyo.oslc4j.core.model.ResourceShape;
import org.eclipse.lyo.oslc4j.core.model.ResourceShapeFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OslcResourceShapeResource
extends AbstractDynamicResource {
    private static final String BASE_URI = "http://localhost/validatingResourceShapes";
    private final String resourceShapesPath;
    private final Map<String, Class<?>> resourcePathToResourceClassMap;

    public OslcResourceShapeResource(String resourceShapesPath, Map<String, Class<?>> resourcePathToResourceClassMap) throws OslcCoreApplicationException, URISyntaxException {
        this.resourceShapesPath = resourceShapesPath;
        this.resourcePathToResourceClassMap = resourcePathToResourceClassMap;
        this.setPath(resourceShapesPath);
        for (Map.Entry<String, Class<?>> entry : resourcePathToResourceClassMap.entrySet()) {
            ResourceShapeFactory.createResourceShape((String)BASE_URI, (String)resourceShapesPath, (String)entry.getKey(), entry.getValue());
        }
    }

    @GET
    @Path(value="{resourceShapePath}")
    @Produces(value={"application/rdf+xml", "application/xml", "text/xml", "application/json"})
    public ResourceShape getResourceShape(@Context HttpServletRequest httpServletRequest, @PathParam(value="resourceShapePath") String resourceShapePath) throws OslcCoreApplicationException, URISyntaxException {
        String baseURI = OSLC4JUtils.resolveURI((HttpServletRequest)httpServletRequest, (boolean)false);
        Class<?> resourceClass = this.resourcePathToResourceClassMap.get(resourceShapePath);
        if (resourceClass != null) {
            return ResourceShapeFactory.createResourceShape((String)baseURI, (String)this.resourceShapesPath, (String)resourceShapePath, resourceClass);
        }
        throw new WebApplicationException(Response.Status.NOT_FOUND);
    }
}

