/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.eef.core.api.controllers;

import java.util.Optional;
import org.eclipse.eef.EEFCustomExpression;
import org.eclipse.eef.EEFCustomWidgetDescription;
import org.eclipse.eef.EefPackage;
import org.eclipse.eef.core.api.EditingContextAdapter;
import org.eclipse.eef.core.api.controllers.AbstractEEFWidgetController;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.sirius.common.interpreter.api.IInterpreter;
import org.eclipse.sirius.common.interpreter.api.IVariableManager;

public abstract class AbstractEEFCustomWidgetController
extends AbstractEEFWidgetController {
    protected final EEFCustomWidgetDescription description;

    public AbstractEEFCustomWidgetController(EEFCustomWidgetDescription description, IVariableManager variableManager, IInterpreter interpreter, EditingContextAdapter contextAdapter) {
        super(variableManager, interpreter, contextAdapter);
        this.description = description;
    }

    protected EEFCustomWidgetDescription getDescription() {
        return this.description;
    }

    protected Optional<String> getCustomExpression(String customExpressionId) {
        Optional<String> optionalCustomExpression = this.getDescription().getCustomExpressions().stream().filter(eefCustomExpression -> customExpressionId != null && customExpressionId.equals(eefCustomExpression.getIdentifier())).map(EEFCustomExpression::getCustomExpression).findFirst();
        return optionalCustomExpression;
    }

    protected void executeCommandExpression(String customExpressionId) {
        this.editingContextAdapter.performModelChange(() -> this.getCustomExpression(customExpressionId).ifPresent(expression -> {
            EAttribute attr = EefPackage.Literals.EEF_CUSTOM_EXPRESSION__CUSTOM_EXPRESSION;
            this.newEval().logIfBlank(attr).call((String)expression);
        }));
    }
}

