/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.properties.core.internal.migration;

import java.util.Optional;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xml.type.AnyType;
import org.eclipse.sirius.business.api.migration.AbstractVSMMigrationParticipant;
import org.eclipse.sirius.properties.Category;
import org.eclipse.sirius.properties.GroupDescription;
import org.eclipse.sirius.properties.PageDescription;
import org.eclipse.sirius.properties.PropertiesFactory;
import org.eclipse.sirius.properties.PropertiesPackage;
import org.eclipse.sirius.properties.ViewExtensionDescription;
import org.eclipse.sirius.properties.core.internal.migration.AnyTypeConverterRegistry;
import org.eclipse.sirius.properties.core.internal.migration.IAnyTypeConverter;
import org.eclipse.sirius.viewpoint.description.DescriptionPackage;
import org.eclipse.sirius.viewpoint.description.Group;
import org.osgi.framework.Version;

public abstract class AbstractCategoryMigrationParticipant
extends AbstractVSMMigrationParticipant {
    private static final String PAGES_FEATURE_NAME = "pages";
    private static final String GROUPS_FEATURE_NAME = "groups";
    private static final String IDENTIFIER = "identifier";
    private static final String DOMAIN_CLASS_EXPRESSION = "domainClassExpression";

    public EClassifier getType(EPackage ePackage, String name, String loadedVersion) {
        EClass eClassifier = null;
        if ("DynamicMappingFor".equals(name)) {
            eClassifier = PropertiesPackage.Literals.DYNAMIC_MAPPING_FOR_DESCRIPTION;
        } else if ("DynamicMappingIf".equals(name)) {
            eClassifier = PropertiesPackage.Literals.DYNAMIC_MAPPING_IF_DESCRIPTION;
        }
        if (eClassifier != null) {
            return eClassifier;
        }
        return super.getType(ePackage, name, loadedVersion);
    }

    public EStructuralFeature getAttribute(EClass eClass, String name, String loadedVersion) {
        Object eStructuralFeature = null;
        eStructuralFeature = IDENTIFIER.equals(name) && DescriptionPackage.Literals.IDENTIFIED_ELEMENT.isSuperTypeOf(eClass) ? DescriptionPackage.Literals.IDENTIFIED_ELEMENT__NAME : (DOMAIN_CLASS_EXPRESSION.equals(name) && PropertiesPackage.Literals.ABSTRACT_DYNAMIC_MAPPING_FOR_DESCRIPTION.isSuperTypeOf(eClass) ? PropertiesPackage.Literals.ABSTRACT_DYNAMIC_MAPPING_FOR_DESCRIPTION__ITERABLE_EXPRESSION : super.getAttribute(eClass, name, loadedVersion));
        return eStructuralFeature;
    }

    protected void handleFeature(EObject owner, EStructuralFeature unknownFeature, Object valueOfUnknownFeature) {
        if (owner instanceof ViewExtensionDescription && unknownFeature instanceof EReference && valueOfUnknownFeature instanceof AnyType) {
            ViewExtensionDescription viewExtensionDescription = (ViewExtensionDescription)owner;
            boolean shouldMigrate = true;
            EObject eContainer = owner.eContainer();
            if (eContainer instanceof Group) {
                Group group = (Group)eContainer;
                boolean bl = shouldMigrate = shouldMigrate && this.getMigrationVersion().compareTo(Version.parseVersion((String)group.getVersion())) > 0;
            }
            if (shouldMigrate) {
                AnyType anyType = (AnyType)valueOfUnknownFeature;
                if (PAGES_FEATURE_NAME.equals(unknownFeature.getName())) {
                    this.handlePages(viewExtensionDescription, anyType);
                } else if (GROUPS_FEATURE_NAME.equals(unknownFeature.getName())) {
                    this.handleGroups(viewExtensionDescription, anyType);
                }
            }
        }
        super.handleFeature(owner, unknownFeature, valueOfUnknownFeature);
    }

    private void handlePages(ViewExtensionDescription viewExtensionDescription, AnyType anyType) {
        Category category = this.getOrCreateFirstCategory(viewExtensionDescription);
        Resource eResource = viewExtensionDescription.eResource();
        Optional<IAnyTypeConverter> optionalConverter = AnyTypeConverterRegistry.getConverter(eResource, anyType, PropertiesPackage.Literals.PAGE_DESCRIPTION);
        Optional optionalEObject = optionalConverter.flatMap(converter -> converter.convert(eResource, anyType, PropertiesPackage.Literals.PAGE_DESCRIPTION));
        optionalEObject.filter(PageDescription.class::isInstance).map(PageDescription.class::cast).ifPresent(arg_0 -> category.getPages().add(arg_0));
    }

    private void handleGroups(ViewExtensionDescription viewExtensionDescription, AnyType anyType) {
        Category category = this.getOrCreateFirstCategory(viewExtensionDescription);
        Resource eResource = viewExtensionDescription.eResource();
        Optional<IAnyTypeConverter> optionalConverter = AnyTypeConverterRegistry.getConverter(eResource, anyType, PropertiesPackage.Literals.GROUP_DESCRIPTION);
        Optional optionalEObject = optionalConverter.flatMap(converter -> converter.convert(eResource, anyType, PropertiesPackage.Literals.GROUP_DESCRIPTION));
        optionalEObject.filter(GroupDescription.class::isInstance).map(GroupDescription.class::cast).ifPresent(arg_0 -> category.getGroups().add(arg_0));
    }

    private Category getOrCreateFirstCategory(ViewExtensionDescription viewExtensionDescription) {
        return viewExtensionDescription.getCategories().stream().findFirst().orElseGet(() -> {
            Category category = PropertiesFactory.eINSTANCE.createCategory();
            category.setName("Default");
            viewExtensionDescription.getCategories().add((Object)category);
            return category;
        });
    }
}

