/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.internal.helper.task.operations;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.sirius.business.api.logger.RuntimeLoggerManager;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.internal.helper.task.ModelOperationToTask;
import org.eclipse.sirius.business.internal.helper.task.operations.AbstractOperationTask;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.ecore.extender.business.api.accessor.ModelAccessor;
import org.eclipse.sirius.tools.api.command.CommandContext;
import org.eclipse.sirius.tools.api.command.ui.UICallBack;
import org.eclipse.sirius.viewpoint.SiriusPlugin;
import org.eclipse.sirius.viewpoint.description.tool.Case;
import org.eclipse.sirius.viewpoint.description.tool.ModelOperation;
import org.eclipse.sirius.viewpoint.description.tool.Switch;
import org.eclipse.sirius.viewpoint.description.tool.ToolPackage;

public class SwitchTask
extends AbstractOperationTask {
    private Switch switchOperation;
    private UICallBack uiCallback;
    private Session session;

    public SwitchTask(CommandContext context, ModelAccessor extPackage, Switch switchOperation, Session session, UICallBack uiCallback) {
        super(context, extPackage, session.getInterpreter());
        this.switchOperation = switchOperation;
        this.uiCallback = uiCallback;
        this.session = session;
    }

    @Override
    public void execute() {
        EObject context = this.getContext().getCurrentTarget();
        IInterpreter interpreter = SiriusPlugin.getDefault().getInterpreterRegistry().getInterpreter(this.getContext().getCurrentTarget());
        boolean conditionAccepted = false;
        EList<ModelOperation> operations = Lists.newArrayList();
        Iterator it = this.switchOperation.getCases().iterator();
        while (!conditionAccepted && it.hasNext()) {
            Case caseOperation = (Case)it.next();
            conditionAccepted = RuntimeLoggerManager.INSTANCE.decorate(interpreter).evaluateBoolean(context, caseOperation, (EStructuralFeature)ToolPackage.eINSTANCE.getCase_ConditionExpression(), true);
            if (!conditionAccepted) continue;
            operations = caseOperation.getSubModelOperations();
        }
        if (!conditionAccepted && this.switchOperation.getDefault() != null) {
            operations = this.switchOperation.getDefault().getSubModelOperations();
        }
        Collection childTasks = Collections2.transform(operations, (Function)new ModelOperationToTask(this.extPackage, this.uiCallback, this.session, this.context));
        this.getChildrenTasks().addAll(childTasks);
    }

    @Override
    public String getLabel() {
        return "";
    }
}

