/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.op;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.egit.core.Activator;
import org.eclipse.egit.core.internal.CoreText;
import org.eclipse.egit.core.internal.job.RuleUtil;
import org.eclipse.egit.core.op.IEGitOperation;
import org.eclipse.egit.core.project.GitProjectData;
import org.eclipse.egit.core.project.RepositoryMapping;
import org.eclipse.jgit.dircache.DirCacheEditor;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.osgi.util.NLS;

public class UntrackOperation
implements IEGitOperation {
    private final Collection<? extends IResource> rsrcList;
    private final Collection<IPath> locations;
    private Repository db;
    private final IdentityHashMap<Repository, DirCacheEditor> edits;

    public UntrackOperation(Collection<? extends IResource> rsrcs) {
        this.rsrcList = rsrcs;
        this.locations = Collections.emptyList();
        this.edits = new IdentityHashMap();
    }

    public UntrackOperation(Repository repository, Collection<IPath> locations) {
        this.rsrcList = Collections.emptyList();
        this.locations = locations;
        this.db = repository;
        this.edits = new IdentityHashMap();
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    @Override
    public void execute(IProgressMonitor monitor) throws CoreException {
        progress = SubMonitor.convert((IProgressMonitor)monitor, (int)((this.rsrcList.size() + this.locations.size()) * 2));
        progress.setTaskName(CoreText.UntrackOperation_adding);
        this.edits.clear();
        try {
            try {
                for (IResource obj : this.rsrcList) {
                    this.remove(obj);
                    progress.worked(1);
                }
                for (IPath location : this.locations) {
                    this.remove(location);
                    progress.worked(1);
                }
                progress.setWorkRemaining(this.edits.size());
                for (Map.Entry e : this.edits.entrySet()) {
                    editor = (DirCacheEditor)e.getValue();
                    progress.setTaskName(NLS.bind((String)CoreText.UntrackOperation_writingIndex, (Object)this.db.getDirectory()));
                    editor.commit();
                    progress.worked(1);
                }
            }
            catch (RuntimeException e) {
                throw new CoreException(Activator.error(CoreText.UntrackOperation_failed, e));
            }
            catch (IOException e) {
                throw new CoreException(Activator.error(CoreText.UntrackOperation_failed, e));
            }
        }
        finally {
            ** for (editor : this.edits.values())
        }
lbl-1000:
        // 1 sources

        {
            if (editor.getDirCache() == null) continue;
            editor.getDirCache().unlock();
            continue;
        }
lbl33:
        // 1 sources

        this.edits.clear();
    }

    @Override
    public ISchedulingRule getSchedulingRule() {
        return RuleUtil.getRuleForRepositories(this.rsrcList.toArray(new IResource[this.rsrcList.size()]));
    }

    private void remove(IResource resource) throws CoreException {
        IProject proj = resource.getProject();
        if (proj == null) {
            return;
        }
        GitProjectData pd = GitProjectData.get(proj);
        if (pd == null) {
            return;
        }
        RepositoryMapping rm = pd.getRepositoryMapping(resource);
        if (rm == null) {
            return;
        }
        this.db = rm.getRepository();
        this.remove(resource.getLocation());
    }

    private void remove(IPath location) throws CoreException {
        DirCacheEditor e = this.edits.get(this.db);
        if (e == null) {
            try {
                e = this.db.lockDirCache().editor();
            }
            catch (IOException err) {
                throw new CoreException(Activator.error(CoreText.UntrackOperation_failed, err));
            }
            this.edits.put(this.db, e);
        }
        Path dbDir = new Path(this.db.getWorkTree().getAbsolutePath());
        String path = location.makeRelativeTo((IPath)dbDir).toString();
        if (location.toFile().isDirectory()) {
            e.add((DirCacheEditor.PathEdit)new DirCacheEditor.DeleteTree(path));
        } else {
            e.add((DirCacheEditor.PathEdit)new DirCacheEditor.DeletePath(path));
        }
    }
}

