/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.parser.cst.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.eclipse.acceleo.internal.parser.cst.utils.Region;
import org.eclipse.acceleo.internal.parser.cst.utils.Sequence;

public final class FileContent {
    private FileContent() {
    }

    public static StringBuffer getFileContent(File file) {
        String encoding;
        StringBuffer buffer = FileContent.getEncodedFileContent(file, null);
        if (file.getName() != null && file.getName().endsWith("mtl") && (encoding = FileContent.getEncoding(buffer)) != null) {
            buffer = FileContent.getEncodedFileContent(file, encoding);
        }
        return buffer;
    }

    private static StringBuffer getEncodedFileContent(File file, String encodingCode) {
        StringBuffer buffer;
        block18: {
            buffer = new StringBuffer();
            FileInputStream input = null;
            InputStreamReader reader = null;
            try {
                try {
                    input = new FileInputStream(file);
                    reader = encodingCode != null ? new InputStreamReader((InputStream)input, encodingCode) : new InputStreamReader(input);
                    int size = 0;
                    char[] buff = new char[8192];
                    while ((size = reader.read(buff)) >= 0) {
                        buffer.append(buff, 0, size);
                    }
                }
                catch (IOException iOException) {
                    try {
                        if (input != null) {
                            input.close();
                        }
                        if (reader != null) {
                            reader.close();
                        }
                        break block18;
                    }
                    catch (IOException iOException2) {}
                    break block18;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (input != null) {
                        input.close();
                    }
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                if (input != null) {
                    input.close();
                }
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException iOException) {}
        }
        return buffer;
    }

    public static String getEncoding(StringBuffer buffer) {
        String result = null;
        Sequence bSequence = new Sequence("[", "comment", "encoding", "=");
        result = FileContent.getEncoding(buffer, bSequence);
        if (result == null) {
            bSequence = new Sequence("[", "**", "encoding", "=");
            result = FileContent.getEncoding(buffer, bSequence);
        }
        return result;
    }

    private static String getEncoding(StringBuffer buffer, Sequence bSequence) {
        Region b = bSequence.search(buffer);
        if (b.e() != -1) {
            int bEncoding = b.e();
            while (bEncoding < buffer.length() && Character.isWhitespace(buffer.charAt(bEncoding))) {
                ++bEncoding;
            }
            if (bEncoding < buffer.length() && (buffer.charAt(bEncoding) == '-' || Character.isJavaIdentifierStart(buffer.charAt(bEncoding)))) {
                int eEncoding = bEncoding + 1;
                while (eEncoding < buffer.length() && (buffer.charAt(eEncoding) == '-' || Character.isJavaIdentifierPart(buffer.charAt(eEncoding)))) {
                    ++eEncoding;
                }
                return buffer.substring(bEncoding, eEncoding).trim();
            }
        }
        return null;
    }

    public static int columnNumber(StringBuffer buffer, int index) {
        if (buffer != null && index < buffer.length()) {
            int column = 1;
            int i = index - 1;
            while (i >= 0) {
                if (buffer.charAt(i) == '\n') break;
                ++column;
                --i;
            }
            return column;
        }
        return 0;
    }

    public static int lineNumber(StringBuffer buffer, int index) {
        if (buffer != null && index < buffer.length()) {
            int line = 1;
            int i = index - 1;
            while (i >= 0) {
                if (buffer.charAt(i) == '\n') {
                    ++line;
                }
                --i;
            }
            return line;
        }
        return 0;
    }
}

