/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.api.figure;

import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.FlowLayout;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.text.FlowPage;
import org.eclipse.draw2d.text.TextFlow;
import org.eclipse.sirius.diagram.ui.tools.api.figure.AbstractTransparentNode;
import org.eclipse.sirius.diagram.ui.tools.internal.figure.TransparentFigureGraphicsModifier;

public class GaugeSectionFigure
extends AbstractTransparentNode {
    private int min;
    private int max;
    private int value;
    private final TextFlow textFlow = new TextFlow("");

    public GaugeSectionFigure(int min, int max, int value) {
        this.setLayoutManager((LayoutManager)new FlowLayout());
        FlowPage flowPage = new FlowPage();
        flowPage.add((IFigure)this.textFlow);
        this.add((IFigure)flowPage);
        this.textFlow.setForegroundColor(ColorConstants.white);
        this.min = min;
        this.max = max;
        this.value = value;
        this.setBorder((Border)new LineBorder());
    }

    public int getMin() {
        return this.min;
    }

    public void setMin(int min) {
        this.min = min;
    }

    public int getMax() {
        return this.max;
    }

    public void setMax(int max) {
        this.max = max;
    }

    public int getValue() {
        return this.value;
    }

    public void setValue(int value) {
        this.value = value;
    }

    protected boolean useLocalCoordinates() {
        return true;
    }

    public void setLabel(String label) {
        this.textFlow.setText(label);
    }

    protected void paintFigure(Graphics graphics) {
        int val;
        TransparentFigureGraphicsModifier modifier = new TransparentFigureGraphicsModifier(this, graphics);
        modifier.pushState();
        super.paintFigure(graphics);
        Rectangle bounds = new Rectangle(this.getBounds());
        int divisor = this.max < this.min ? 1 : this.max - this.min;
        int n = val = this.value > this.max ? this.max - this.min : this.value - this.min;
        int y = divisor == 0 ? (val == 0 ? 0 : bounds.height) : (int)((double)bounds.height * ((double)val / (double)divisor));
        graphics.setLineWidth(0);
        graphics.setBackgroundColor(this.getBackgroundColor());
        graphics.setForegroundColor(this.getBackgroundColor());
        graphics.fillRectangle(bounds.x, bounds.y, bounds.width, bounds.height - y);
        graphics.setForegroundColor(this.getForegroundColor());
        graphics.setBackgroundColor(this.getForegroundColor());
        graphics.fillRectangle(bounds.x, bounds.y + bounds.height - y, bounds.width, y);
        modifier.popState();
    }

    protected void paintBorder(Graphics graphics) {
        graphics.setBackgroundColor(ColorConstants.white);
        graphics.setForegroundColor(ColorConstants.white);
        super.paintBorder(graphics);
    }

    public static GaugeSectionFigure createDefaultSection() {
        return new GaugeSectionFigure(1, 10, 5);
    }
}

