/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.internal.componentization;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.resource.impl.URIMappingRegistryImpl;
import org.eclipse.emf.ecore.util.ECrossReferenceAdapter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.sirius.business.api.componentization.ISiriusComponent;
import org.eclipse.sirius.business.api.componentization.ViewpointFileCollector;
import org.eclipse.sirius.business.api.componentization.ViewpointRegistry;
import org.eclipse.sirius.business.api.componentization.ViewpointRegistryFilter;
import org.eclipse.sirius.business.api.componentization.ViewpointRegistryListener2;
import org.eclipse.sirius.business.api.dialect.DialectManager;
import org.eclipse.sirius.business.api.query.RepresentationDescriptionQuery;
import org.eclipse.sirius.business.api.query.ViewpointQuery;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.common.tools.DslCommonPlugin;
import org.eclipse.sirius.common.tools.api.util.EclipseUtil;
import org.eclipse.sirius.common.tools.api.util.EqualityHelper;
import org.eclipse.sirius.common.tools.api.util.StringUtil;
import org.eclipse.sirius.ecore.extender.tool.api.ModelUtils;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;
import org.eclipse.sirius.tools.api.profiler.SiriusTasksKey;
import org.eclipse.sirius.tools.internal.uri.ViewpointProtocolException;
import org.eclipse.sirius.tools.internal.uri.ViewpointProtocolParser;
import org.eclipse.sirius.viewpoint.Messages;
import org.eclipse.sirius.viewpoint.SiriusPlugin;
import org.eclipse.sirius.viewpoint.description.Component;
import org.eclipse.sirius.viewpoint.description.Group;
import org.eclipse.sirius.viewpoint.description.RepresentationDescription;
import org.eclipse.sirius.viewpoint.description.Viewpoint;

public class ViewpointRegistryImpl
extends ViewpointRegistry {
    private ResourceSet resourceSet;
    private Map<URI, Viewpoint> viewpointsFromPlugin;
    private Set<Viewpoint> viewpointsFromWorkspace;
    private Set<ViewpointRegistryFilter> filters;
    private Set<ViewpointRegistryListener2> newListeners;
    private ECrossReferenceAdapter crossReferencer;
    private boolean shouldInvalidateCache;
    private LoadingCache<EObject, EObject> foundCache = this.prepareFoundCache();
    private Map<String, ViewpointFileCollector> collectors = new HashMap<String, ViewpointFileCollector>();

    public ViewpointRegistryImpl() {
        this.collectors.put("odesign", new ViewpointFileCollector(){

            @Override
            public boolean isValid(EObject descRoot) {
                boolean result;
                block3: {
                    List<Resource.Diagnostic> errors;
                    block1: {
                        block2: {
                            result = false;
                            errors = this.getErrors(descRoot);
                            if (!errors.isEmpty()) break block1;
                            if (!(descRoot instanceof Group)) break block2;
                            result = true;
                            break block3;
                        }
                        if (descRoot == null) break block3;
                        SiriusPlugin.getDefault().warning(MessageFormat.format(Messages.ViewpointRegistryImpl_cantLoadVSMErrorMsg, descRoot.eResource().getURI()), new RuntimeException(Messages.ViewpointRegistryImpl_cantDeployVSMErrorMsg));
                        break block3;
                    }
                    for (Resource.Diagnostic diagnostic : errors) {
                        SiriusPlugin.getDefault().warning(diagnostic.getMessage(), new RuntimeException(Messages.ViewpointRegistryImpl_cantDeployVSMErrorMsg));
                    }
                }
                return result;
            }

            private List<Resource.Diagnostic> getErrors(EObject descRoot) {
                if (descRoot == null || descRoot.eResource() == null) {
                    return Collections.emptyList();
                }
                return descRoot.eResource().getErrors();
            }

            @Override
            public Collection<Viewpoint> collect(EObject root) {
                return Lists.newArrayList((Iterator)Iterators.filter((Iterator)root.eAllContents(), Viewpoint.class));
            }
        });
        this.prepareFoundCache();
    }

    public void addViewpointFileCollector(String fileExtension, ViewpointFileCollector collector) {
        this.collectors.put(fileExtension, collector);
    }

    @Deprecated
    public void addSiriusFileCollector(String fileExtension, ViewpointFileCollector collector) {
        this.addViewpointFileCollector(fileExtension, collector);
    }

    @Override
    public void init(int size) {
        this.viewpointsFromPlugin = new LinkedHashMap<URI, Viewpoint>();
        this.viewpointsFromWorkspace = new HashSet<Viewpoint>(size);
        this.resourceSet = new ResourceSetImpl();
        this.crossReferencer = new ECrossReferenceAdapter();
        this.resourceSet.eAdapters().add((Object)this.crossReferencer);
        IWorkspaceRoot workspaceRoot = EcorePlugin.getWorkspaceRoot();
        if (workspaceRoot != null) {
            workspaceRoot.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 1);
        }
        this.initViewpointsFromPlugins();
        this.refreshComponentsFromWorkspace();
    }

    @Override
    public Viewpoint getViewpoint(URI viewpointUri) throws ViewpointProtocolException {
        return ViewpointProtocolParser.getViewpoint(viewpointUri);
    }

    private void invalidateCache() {
        DialectManager.INSTANCE.invalidateMappingCache();
        this.prepareFoundCache();
    }

    private LoadingCache<EObject, EObject> prepareFoundCache() {
        return CacheBuilder.newBuilder().weakKeys().build(CacheLoader.from((Function)new Function<EObject, EObject>(){

            public EObject apply(EObject from) {
                return ViewpointRegistryImpl.this.lookForEquivalentInRegistry(from);
            }
        }));
    }

    @Override
    public boolean addFilter(ViewpointRegistryFilter filter) {
        if (this.filters == null) {
            this.filters = new HashSet<ViewpointRegistryFilter>(4);
        }
        this.invalidateCache();
        return this.filters.add(filter);
    }

    @Override
    public boolean removeFilter(ViewpointRegistryFilter filter) {
        this.invalidateCache();
        if (this.filters != null) {
            return this.filters.remove(filter);
        }
        return false;
    }

    @Override
    public void removeFilter(String id) {
        if (this.filters != null) {
            this.invalidateCache();
            HashSet<ViewpointRegistryFilter> toRemove = new HashSet<ViewpointRegistryFilter>(this.filters.size());
            for (ViewpointRegistryFilter filter : this.filters) {
                if (!filter.getId().equals(id)) continue;
                toRemove.add(filter);
            }
            this.filters.removeAll(toRemove);
        }
    }

    @Override
    public boolean addListener(ViewpointRegistryListener2 listener) {
        if (this.newListeners == null) {
            this.newListeners = new HashSet<ViewpointRegistryListener2>(4);
        }
        return this.newListeners.add(listener);
    }

    @Override
    public boolean removeListener(ViewpointRegistryListener2 listener) {
        if (this.newListeners != null) {
            return this.newListeners.remove(listener);
        }
        return false;
    }

    @Override
    public Set<Viewpoint> registerFromPlugin(String modelerModelResourcePath) {
        HashSet<Viewpoint> addedViewpoints = new HashSet<Viewpoint>();
        try {
            URI resourceURI = URI.createPlatformPluginURI((String)modelerModelResourcePath, (boolean)true);
            Resource resource = this.resourceSet.getResource(resourceURI, false);
            if (resource != null) {
                this.unloadAndRemove(resource);
            }
            EObject root = this.load(resourceURI, this.resourceSet);
            Option<ViewpointFileCollector> collector = this.getCollectorFromURI(resourceURI);
            if (collector.some() && ((ViewpointFileCollector)collector.get()).isValid(root)) {
                for (Viewpoint viewpoint : ((ViewpointFileCollector)collector.get()).collect(root)) {
                    Option<URI> uri = new ViewpointQuery(viewpoint).getViewpointURI();
                    if (uri.some()) {
                        this.viewpointsFromPlugin.put((URI)uri.get(), viewpoint);
                    } else {
                        this.viewpointsFromPlugin.put(EcoreUtil.getURI((EObject)viewpoint), viewpoint);
                    }
                    this.mapToViewpointProtocol(viewpoint);
                    addedViewpoints.add(viewpoint);
                }
                this.unloadInExistingSessions(resourceURI.toPlatformString(true), false);
                this.addCrossReferencer(root.eResource());
            } else {
                this.unloadAndRemove(resourceURI);
            }
        }
        catch (IOException e) {
            SiriusPlugin.getDefault().error(MessageFormat.format(Messages.ViewpointRegistryImpl_FileLoadingErrorMsg, modelerModelResourcePath), e);
        }
        catch (WrappedException e) {
            SiriusPlugin.getDefault().warning(MessageFormat.format(Messages.ViewpointRegistryImpl_FileLoadingErrorMsg, modelerModelResourcePath), e.exception());
        }
        catch (RuntimeException e) {
            SiriusPlugin.getDefault().warning(MessageFormat.format(Messages.ViewpointRegistryImpl_FileLoadingErrorMsg, modelerModelResourcePath), e);
        }
        this.invalidateCache();
        return addedViewpoints;
    }

    @Override
    public void reloadAllFromPlugins() {
        boolean[] touched = new boolean[1];
        this.viewpointsFromPlugin.values().stream().map(vp -> vp.eResource()).distinct().filter(r -> r != null).forEach(res -> {
            URI uri = res.getURI();
            if (uri != null) {
                String path = uri.toPlatformString(true);
                this.registerFromPlugin(path);
                blArray[0] = true;
            }
        });
        if (touched[0] && this.newListeners != null) {
            for (ViewpointRegistryListener2 listener : this.newListeners) {
                listener.modelerDesciptionFilesLoaded();
            }
        }
    }

    private Option<ViewpointFileCollector> getCollectorFromURI(URI fileURI) {
        Option result = Options.newNone();
        if (!StringUtil.isEmpty((String)fileURI.fileExtension())) {
            result = Options.newSome((Object)this.collectors.get(fileURI.fileExtension()));
        }
        return result;
    }

    private Option<ViewpointFileCollector> getCollectorFromIFile(IFile file) {
        Option result = Options.newNone();
        if (!StringUtil.isEmpty((String)file.getFileExtension())) {
            result = Options.newSome((Object)this.collectors.get(file.getFileExtension()));
        }
        return result;
    }

    @Override
    public <T extends Component> void registerFromWorkspace(Set<T> components) {
        this.viewpointsFromWorkspace.clear();
        for (Component c : components) {
            if (!(c instanceof Viewpoint)) continue;
            Viewpoint viewpoint = (Viewpoint)c;
            this.viewpointsFromWorkspace.add(viewpoint);
            this.mapToViewpointProtocol(viewpoint);
        }
        this.invalidateCache();
    }

    @Override
    public void disposeFromPlugin(Viewpoint viewpoint) {
        this.viewpointsFromPlugin.remove(viewpoint);
        URI vpURI = ViewpointProtocolParser.buildViewpointUri(EcoreUtil.getURI((EObject)viewpoint));
        URI mappedURI = (URI)URIMappingRegistryImpl.INSTANCE.get((Object)vpURI);
        Resource vpResource = viewpoint.eResource();
        if (mappedURI != null && mappedURI.isPlatformPlugin() && vpResource != null && mappedURI.toPlatformString(true).equals(vpResource.getURI().toPlatformString(true))) {
            Iterable sameNameAndPluginViewpoints;
            Iterator iterator;
            final String vpName = viewpoint.getName();
            final String pluginName = vpResource.getURI().segment(1);
            if (vpName != null && pluginName != null && (iterator = (sameNameAndPluginViewpoints = Iterables.filter(this.viewpointsFromPlugin.values(), (Predicate)new Predicate<Viewpoint>(){

                public boolean apply(Viewpoint input) {
                    return vpName.equals(input.getName()) && pluginName.equals(input.eResource().getURI().segment(1));
                }
            })).iterator()).hasNext()) {
                Viewpoint sameNameAndPluginSirius = (Viewpoint)iterator.next();
                this.mapToViewpointProtocol(sameNameAndPluginSirius);
            }
        }
        for (Viewpoint viewpointFromPlugin : this.viewpointsFromPlugin.values()) {
            if (!viewpointFromPlugin.eResource().equals(vpResource)) continue;
            return;
        }
        this.removeCrossReferencer(viewpoint.eResource());
        this.invalidateCache();
    }

    @Override
    public Set<Viewpoint> getViewpoints() {
        HashSet<Viewpoint> all = new HashSet<Viewpoint>(this.viewpointsFromPlugin.size() + this.viewpointsFromWorkspace.size());
        all.addAll(this.viewpointsFromWorkspace);
        all.addAll(this.viewpointsFromPlugin.values());
        if (this.filters != null) {
            LinkedHashSet<Viewpoint> toRemove = new LinkedHashSet<Viewpoint>();
            for (ViewpointRegistryFilter filter : this.filters) {
                for (Viewpoint viewpoint : this.viewpointsFromWorkspace) {
                    if (!filter.filter(viewpoint)) continue;
                    toRemove.add(viewpoint);
                }
                for (Viewpoint viewpoint : this.viewpointsFromPlugin.values()) {
                    if (!filter.filter(viewpoint)) continue;
                    toRemove.add(viewpoint);
                }
            }
            all.removeAll(toRemove);
        }
        return Collections.unmodifiableSet(all);
    }

    @Override
    public Viewpoint getViewpoint(RepresentationDescription description) {
        return new RepresentationDescriptionQuery(description).getParentViewpoint();
    }

    @Override
    public boolean isFromPlugin(Viewpoint viewpoint) {
        if (this.viewpointsFromPlugin != null) {
            return this.viewpointsFromPlugin.containsValue(viewpoint);
        }
        return false;
    }

    @Override
    public void dispose() {
        IWorkspaceRoot workspaceRoot;
        this.disposeViewpointsFromPlugins();
        this.viewpointsFromWorkspace.clear();
        if (this.filters != null) {
            this.filters.clear();
        }
        if ((workspaceRoot = EcorePlugin.getWorkspaceRoot()) != null) {
            workspaceRoot.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        }
        this.invalidateCache();
    }

    protected void disposeViewpointsFromPlugins() {
        this.viewpointsFromPlugin.clear();
        this.invalidateCache();
    }

    private void refreshComponentsFromWorkspace() {
        List<IFile> files = this.collectFilesContainingViewpoints();
        Iterator<IFile> fileIt = files.iterator();
        HashSet<Viewpoint> viewpoints = new HashSet<Viewpoint>();
        HashSet<Resource> resourcesToResolve = new HashSet<Resource>();
        while (fileIt.hasNext()) {
            IFile file = fileIt.next();
            EObject descRoot = this.load(file, this.resourceSet);
            if (descRoot == null) continue;
            Option<ViewpointFileCollector> collector = this.getCollectorFromIFile(file);
            if (collector.some() && ((ViewpointFileCollector)collector.get()).isValid(descRoot)) {
                viewpoints.addAll(((ViewpointFileCollector)collector.get()).collect(descRoot));
                this.mapToSiriusProtocol(((ViewpointFileCollector)collector.get()).collect(descRoot));
                resourcesToResolve.add(descRoot.eResource());
                continue;
            }
            this.unloadAndRemove(file);
        }
        for (Resource res : resourcesToResolve) {
            this.addCrossReferencer(res);
            DslCommonPlugin.PROFILER.startWork(SiriusTasksKey.RESOLVE_ALL_KEY);
            try {
                ModelUtils.resolveAll((ResourceSet)this.resourceSet);
            }
            catch (RuntimeException e) {
                SiriusPlugin.getDefault().error(MessageFormat.format(Messages.ViewpointRegistryImpl_FileLoadingErrorMsg, res.getURI().toString()), e);
            }
            DslCommonPlugin.PROFILER.stopWork(SiriusTasksKey.RESOLVE_ALL_KEY);
        }
        HashSet<Viewpoint> components = new HashSet<Viewpoint>(viewpoints.size());
        components.addAll(viewpoints);
        this.registerFromWorkspace(components);
    }

    private List<IFile> collectFilesContainingViewpoints() {
        return EclipseUtil.getFilesFromWorkspace(null, (String)".odesign");
    }

    private void mapToSiriusProtocol(Collection<Viewpoint> viewpoints) {
        for (Viewpoint viewpoint : viewpoints) {
            this.mapToViewpointProtocol(viewpoint);
        }
    }

    private void mapToViewpointProtocol(Viewpoint viewpoint) {
        Resource resource = viewpoint.eResource();
        if (resource != null && resource.getURI() != null) {
            URI uri = EcoreUtil.getURI((EObject)viewpoint);
            URIMappingRegistryImpl.INSTANCE.put((Object)ViewpointProtocolParser.buildViewpointUri(uri), (Object)resource.getURI());
        }
    }

    private void unloadAndRemove(IFile file) {
        this.unloadAndRemove(URI.createPlatformResourceURI((String)file.getFullPath().toOSString(), (boolean)true));
    }

    private void unloadAndRemove(URI resourceURI) {
        Resource resource = this.resourceSet.getResource(resourceURI, false);
        this.unloadAndRemove(resource);
    }

    private void unloadAndRemove(Resource resource) {
        if (resource != null) {
            try {
                this.removeCrossReferencer(resource);
            }
            catch (ClassCastException classCastException) {}
            try {
                resource.unload();
            }
            catch (IllegalArgumentException e) {
                SiriusPlugin.getDefault().error(MessageFormat.format(Messages.ViewpointRegistryImpl_unableToUnloadFileErrorMsg, resource.getURI().toString()), e);
            }
            catch (NullPointerException e) {
                SiriusPlugin.getDefault().error(MessageFormat.format(Messages.ViewpointRegistryImpl_unableToUnloadFileErrorMsg, resource.getURI().toString()), e);
            }
            this.resourceSet.getResources().remove((Object)resource);
        }
    }

    private EObject load(IFile file, ResourceSet set) {
        try {
            URI fileURI = URI.createPlatformResourceURI((String)file.getFullPath().toOSString(), (boolean)true);
            return this.load(fileURI, set);
        }
        catch (IOException e) {
            SiriusPlugin.getDefault().error(MessageFormat.format(Messages.ViewpointRegistryImpl_FileLoadingErrorMsg, file.getName()), e);
        }
        catch (WrappedException e) {
            SiriusPlugin.getDefault().warning(MessageFormat.format(Messages.ViewpointRegistryImpl_FileLoadingErrorMsg, file.getName()), e.exception());
        }
        catch (RuntimeException e) {
            SiriusPlugin.getDefault().warning(MessageFormat.format(Messages.ViewpointRegistryImpl_FileLoadingErrorMsg, file.getName()), e);
        }
        return null;
    }

    private EObject load(URI resourceURI, ResourceSet set) throws IOException, WrappedException, RuntimeException {
        Resource resource = set.getResource(resourceURI, true);
        resource.load(Collections.EMPTY_MAP);
        if (Boolean.getBoolean("org.eclipse.sirius.viewpoint.registry.forceResolveOnLoad")) {
            EcoreUtil.resolveAll((ResourceSet)set);
        }
        return (EObject)resource.getContents().get(0);
    }

    private void initViewpointsFromPlugins() {
        EclipseUtil.getExtensionPlugins(ISiriusComponent.CLASS_TO_EXTEND, (String)"org.eclipse.sirius.componentization", (String)"class");
        this.invalidateCache();
    }

    @Override
    public void resourceChanged(IResourceChangeEvent event) {
        this.refreshWorkspaceComponents(event.getDelta());
        if (this.shouldInvalidateCache) {
            this.invalidateCache();
            if (this.newListeners != null) {
                for (ViewpointRegistryListener2 listener : this.newListeners) {
                    listener.modelerDesciptionFilesLoaded();
                }
            }
            this.shouldInvalidateCache = false;
        }
    }

    private void refreshWorkspaceComponents(IResourceDelta resourceDelta) {
        IResource resource = resourceDelta.getResource();
        if (resource.getType() == 1) {
            IFile file = (IFile)resourceDelta.getResource();
            if (this.mightContainViewpoints(resource)) {
                switch (resourceDelta.getKind()) {
                    case 1: {
                        this.fileAdded(file);
                        break;
                    }
                    case 2: {
                        this.fileRemoved(file);
                        break;
                    }
                    case 262144: {
                        this.invalidateCacheAndReloadFile(file);
                        break;
                    }
                    case 4: {
                        if (this.onlyMarkerChanged(resourceDelta)) break;
                        this.invalidateCacheAndReloadFile(file);
                        break;
                    }
                    case 256: {
                        this.invalidateCacheAndReloadFile(file);
                        break;
                    }
                }
            }
        }
        IResourceDelta[] iResourceDeltaArray = resourceDelta.getAffectedChildren();
        int n = iResourceDeltaArray.length;
        int n2 = 0;
        while (n2 < n) {
            IResourceDelta child = iResourceDeltaArray[n2];
            this.refreshWorkspaceComponents(child);
            ++n2;
        }
    }

    private boolean mightContainViewpoints(IResource resource) {
        return resource instanceof IFile && this.getCollectorFromIFile((IFile)resource).some();
    }

    private boolean onlyMarkerChanged(IResourceDelta resourceDelta) {
        return resourceDelta.getMarkerDeltas().length != 0;
    }

    protected void fileAdded(IFile file) {
        this.shouldInvalidateCache = true;
        EObject descRoot = this.load(file, this.resourceSet);
        Option<ViewpointFileCollector> collector = this.getCollectorFromIFile(file);
        if (collector.some() && ((ViewpointFileCollector)collector.get()).isValid(descRoot)) {
            this.viewpointsFromWorkspace.addAll(((ViewpointFileCollector)collector.get()).collect(descRoot));
            this.mapToSiriusProtocol(((ViewpointFileCollector)collector.get()).collect(descRoot));
            this.addCrossReferencer(descRoot.eResource());
        } else {
            this.unloadAndRemove(file);
        }
    }

    private void invalidateCacheAndReloadFile(IFile file) {
        this.shouldInvalidateCache = true;
        this.reloadFile(file);
    }

    protected void fileRemoved(IFile file) {
        this.shouldInvalidateCache = true;
        if (!file.exists()) {
            this.removeViewpointsNotPersistedInAFile();
            this.unloadInExistingSessions(file, true);
            this.unloadAndRemove(file);
        } else {
            EObject descRoot = this.load(file, this.resourceSet);
            Option<ViewpointFileCollector> collector = this.getCollectorFromIFile(file);
            if (collector.some() && ((ViewpointFileCollector)collector.get()).isValid(descRoot)) {
                for (Viewpoint toRemove : ((ViewpointFileCollector)collector.get()).collect(descRoot)) {
                    for (Viewpoint loadedSirius : new ArrayList<Viewpoint>(this.viewpointsFromWorkspace)) {
                        if (!EqualityHelper.areEquals((EObject)toRemove, (EObject)loadedSirius)) continue;
                        this.removeFromWorkspaceAndUpdateURiMapping(toRemove);
                    }
                }
            }
            this.unloadAndRemove(file);
            this.unloadInExistingSessions(file, true);
        }
    }

    private void removeViewpointsNotPersistedInAFile() {
        for (Viewpoint viewpoint : new ArrayList<Viewpoint>(this.viewpointsFromWorkspace)) {
            Resource viewpointResource = viewpoint.eResource();
            if (viewpointResource == null) {
                this.removeFromWorkspaceAndUpdateURiMapping(viewpoint);
                continue;
            }
            Path path = new Path(viewpointResource.getURI().toPlatformString(true));
            IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)path);
            if (file.exists()) continue;
            this.removeFromWorkspaceAndUpdateURiMapping(viewpoint);
        }
    }

    private void reloadFile(IFile odesignFile) {
        for (Viewpoint viewpoint : new ArrayList<Viewpoint>(this.viewpointsFromWorkspace)) {
            Resource viewpointResource = viewpoint.eResource();
            if (viewpointResource == null || !viewpointResource.getURI().toPlatformString(true).equals(odesignFile.getFullPath().toString())) continue;
            this.removeFromWorkspaceAndUpdateURiMapping(viewpoint);
        }
        this.unloadAndRemove(odesignFile);
        EObject descRoot = this.load(odesignFile, this.resourceSet);
        Option<ViewpointFileCollector> collector = this.getCollectorFromIFile(odesignFile);
        if (collector.some() && ((ViewpointFileCollector)collector.get()).isValid(descRoot)) {
            this.viewpointsFromWorkspace.addAll(((ViewpointFileCollector)collector.get()).collect(descRoot));
            this.mapToSiriusProtocol(((ViewpointFileCollector)collector.get()).collect(descRoot));
            this.unloadInExistingSessions(odesignFile, false);
            this.addCrossReferencer(descRoot.eResource());
        } else {
            this.unloadAndRemove(odesignFile);
        }
    }

    private void unloadInExistingSessions(IFile file, boolean remove) {
        this.unloadInExistingSessions(file.getFullPath().toString(), remove);
    }

    private void unloadInExistingSessions(String resourcePath, boolean remove) {
        for (Session session : SessionManager.INSTANCE.getSessions()) {
            ResourceSet sessionResourceSet = session.getTransactionalEditingDomain().getResourceSet();
            for (Resource resource : new ArrayList(sessionResourceSet.getResources())) {
                URI resourceURI = resource.getURI();
                if (resourceURI == null || resourceURI.toPlatformString(true) == null || !resourceURI.toPlatformString(true).equals(resourcePath)) continue;
                resource.unload();
                if (!remove) continue;
                sessionResourceSet.getResources().remove((Object)resource);
            }
        }
    }

    private void removeFromWorkspaceAndUpdateURiMapping(Viewpoint viewpoint) {
        this.viewpointsFromWorkspace.remove(viewpoint);
        URI viewpointUri = ViewpointProtocolParser.buildViewpointUri(EcoreUtil.getURI((EObject)viewpoint));
        for (Viewpoint vp : this.viewpointsFromPlugin.values()) {
            URI vpURI;
            if (!StringUtil.equals((CharSequence)vp.getName(), (CharSequence)viewpoint.getName()) || (vpURI = ViewpointProtocolParser.buildViewpointUri(EcoreUtil.getURI((EObject)vp))) == null || viewpointUri == null || !StringUtil.equals((CharSequence)vpURI.toString(), (CharSequence)viewpointUri.toString())) continue;
            this.mapToViewpointProtocol(vp);
            return;
        }
        URIMappingRegistryImpl.INSTANCE.removeKey((Object)ViewpointProtocolParser.buildViewpointUri(viewpointUri));
    }

    @Override
    public ECrossReferenceAdapter getCrossReferencer() {
        return this.crossReferencer;
    }

    @Override
    public EObject find(EObject eObject) {
        try {
            return (EObject)this.foundCache.get((Object)eObject);
        }
        catch (ExecutionException executionException) {
            return eObject;
        }
    }

    private EObject lookForEquivalentInRegistry(EObject eObject) {
        EObject eObj = null;
        try {
            eObj = this.resourceSet.getEObject(EcoreUtil.getURI((EObject)eObject), true);
            if (eObj != null) {
                this.addCrossReferencer(eObj.eResource());
            }
        }
        catch (WrappedException wrappedException) {}
        return eObj != null ? eObj : eObject;
    }

    private void removeCrossReferencer(Resource eResource) {
        if (eResource != null) {
            eResource.eAdapters().remove((Object)this.crossReferencer);
        }
    }

    private void addCrossReferencer(Resource eResource) {
        if (eResource != null && !eResource.eAdapters().contains((Object)this.crossReferencer)) {
            eResource.eAdapters().add((Object)this.crossReferencer);
        }
    }
}

