/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lyo.tools.toolchain.design;

import ToolChainModel.design.Activator;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Properties;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.lyo.oslc4j.codegenerator.main.Generate;
import org.eclipse.lyo.oslc4j.codegenerator.main.GenerateSpecification;
import org.eclipse.lyo.tools.toolchain.design.DialogInputServices;

public class GeneratorServices {
    private final ILog logger = Activator.getDefault().getLog();

    private String getFolderPath(EObject self) {
        EObject rootContainer = EcoreUtil.getRootContainer((EObject)self);
        URI rootUri = EcoreUtil.getURI((EObject)rootContainer);
        URI resolvedRootUri = CommonPlugin.resolve((URI)rootUri);
        Path rootPath = new Path(resolvedRootUri.toFileString());
        return rootPath.removeLastSegments(1).toOSString();
    }

    private String identifyGenerationPath(EObject self) {
        DialogInputServices dialogInputServices = new DialogInputServices();
        String folderPath = this.getFolderPath(self);
        String propertiesFilePath = String.valueOf(folderPath) + File.separator + "generator.properties";
        String generationPath = null;
        try {
            Properties props = new Properties();
            File propertiesFile = new File(propertiesFilePath);
            if (propertiesFile.exists() && !propertiesFile.isDirectory()) {
                props.load(new FileInputStream(propertiesFile));
                generationPath = props.getProperty("generationPath");
            }
        }
        catch (IOException e) {
            Status status = new Status(4, "org.eclipse.lyo.tools.toolchain.design", e.getMessage(), (Throwable)e);
            this.logger.log((IStatus)status);
            dialogInputServices.showMessage(self, "Exception!", "an Exception occurred reading the properties file:\"" + propertiesFilePath + "\". Please see the error log.");
            return null;
        }
        if (generationPath == null || generationPath.length() == 0) {
            generationPath = dialogInputServices.promptForFolder(self, "Enter Generation Base Folder", "Select the base folder for your generation.\nNOTE: To provide a default path, set a \"generationPath\" property in a \"generator.properties\" file, in the same location as your toolchain model.", folderPath);
        }
        if (generationPath == null || generationPath.length() == 0) {
            return null;
        }
        File generationPathFile = new File(generationPath);
        if (!generationPathFile.exists() || !generationPathFile.isDirectory()) {
            dialogInputServices.showMessage(self, "Exception!", "Generation path " + generationPath + " must be an existing directory.");
            return null;
        }
        return generationPath;
    }

    private boolean generateAdaptorInterface(EObject self, String targetFolder) {
        try {
            File folder = new File(targetFolder);
            ArrayList arguments = new ArrayList();
            Generate generator = new Generate(self, folder, arguments);
            generator.doGenerate((Monitor)new BasicMonitor());
        }
        catch (IOException e) {
            Status status = new Status(4, "org.eclipse.lyo.tools.toolchain.design", e.getMessage(), (Throwable)e);
            this.logger.log((IStatus)status);
            DialogInputServices dialogInputServices = new DialogInputServices();
            dialogInputServices.showMessage(self, "Exception!", "an Exception occurred during the generation process. Please see the error log.");
            return false;
        }
        return true;
    }

    public EObject generateAdaptorInterface(EObject self) {
        DialogInputServices dialogInputServices = new DialogInputServices();
        String generationPath = this.identifyGenerationPath(self);
        if (generationPath == null) {
            return self;
        }
        if (this.generateAdaptorInterface(self, generationPath)) {
            dialogInputServices.showMessage(self, "Generation Success", "Generation completed on \"" + generationPath + "\".");
        }
        return self;
    }

    private boolean generateSpecification(EObject self, String targetFolder) {
        try {
            File folder = new File(targetFolder);
            ArrayList arguments = new ArrayList();
            GenerateSpecification generator = new GenerateSpecification(self, folder, arguments);
            generator.doGenerate((Monitor)new BasicMonitor());
        }
        catch (IOException e) {
            Status status = new Status(4, "org.eclipse.lyo.tools.toolchain.design", e.getMessage(), (Throwable)e);
            this.logger.log((IStatus)status);
            DialogInputServices dialogInputServices = new DialogInputServices();
            dialogInputServices.showMessage(self, "Exception!", "an Exception occurred during the generation process. Please see the error log.");
            return false;
        }
        return true;
    }

    public EObject generateSpecification(EObject self) {
        DialogInputServices dialogInputServices = new DialogInputServices();
        String generationPath = this.identifyGenerationPath(self);
        if (generationPath == null) {
            return self;
        }
        if (this.generateSpecification(self, generationPath)) {
            dialogInputServices.showMessage(self, "Generation Success", "Generation completed on \"" + generationPath + "\".");
        }
        return self;
    }
}

