/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.shex.writer;

import java.io.OutputStream;
import java.util.List;
import java.util.Locale;
import java.util.function.Consumer;
import org.apache.jena.atlas.io.AWriter;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.graph.Node;
import org.apache.jena.riot.out.NodeFormatter;
import org.apache.jena.riot.out.NodeFormatterTTL;
import org.apache.jena.riot.system.PrefixMap;
import org.apache.jena.riot.system.RiotLib;
import org.apache.jena.shex.ShexSchema;
import org.apache.jena.shex.ShexShape;
import org.apache.jena.shex.expressions.DatatypeConstraint;
import org.apache.jena.shex.expressions.NodeConstraintComponent;
import org.apache.jena.shex.expressions.NodeConstraintVisitor;
import org.apache.jena.shex.expressions.NodeKindConstraint;
import org.apache.jena.shex.expressions.NumLengthConstraint;
import org.apache.jena.shex.expressions.NumRangeConstraint;
import org.apache.jena.shex.expressions.ShapeExprAND;
import org.apache.jena.shex.expressions.ShapeExprAtom;
import org.apache.jena.shex.expressions.ShapeExprDot;
import org.apache.jena.shex.expressions.ShapeExprExternal;
import org.apache.jena.shex.expressions.ShapeExprFalse;
import org.apache.jena.shex.expressions.ShapeExprNOT;
import org.apache.jena.shex.expressions.ShapeExprNone;
import org.apache.jena.shex.expressions.ShapeExprOR;
import org.apache.jena.shex.expressions.ShapeExprRef;
import org.apache.jena.shex.expressions.ShapeExprTripleExpr;
import org.apache.jena.shex.expressions.ShapeExprTrue;
import org.apache.jena.shex.expressions.ShapeExprVisitor;
import org.apache.jena.shex.expressions.ShapeExpression;
import org.apache.jena.shex.expressions.ShapeNodeConstraint;
import org.apache.jena.shex.expressions.StrLengthConstraint;
import org.apache.jena.shex.expressions.StrRegexConstraint;
import org.apache.jena.shex.expressions.TripleConstraint;
import org.apache.jena.shex.expressions.TripleExprCardinality;
import org.apache.jena.shex.expressions.TripleExprEachOf;
import org.apache.jena.shex.expressions.TripleExprNone;
import org.apache.jena.shex.expressions.TripleExprOneOf;
import org.apache.jena.shex.expressions.TripleExprRef;
import org.apache.jena.shex.expressions.TripleExprVisitor;
import org.apache.jena.shex.expressions.TripleExpression;
import org.apache.jena.shex.expressions.ValueConstraint;
import org.apache.jena.shex.expressions.ValueSetItem;
import org.apache.jena.shex.expressions.ValueSetRange;
import org.apache.jena.shex.sys.SysShex;

public class WriterShExC {
    public static void print(OutputStream out, ShexSchema schema) {
        IndentedWriter iOut = new IndentedWriter(out);
        int row = iOut.getRow();
        int col = iOut.getCol();
        WriterShExC.print(iOut, schema);
        iOut.flush();
    }

    public static void print(IndentedWriter out, ShexSchema schema) {
        boolean hasHeader = false;
        if (schema.getBase() != null) {
            out.println("BASE   <" + schema.getBase() + ">");
            hasHeader = true;
        }
        if (schema.getPrefixMap() != null && !schema.getPrefixMap().isEmpty()) {
            RiotLib.writePrefixes((IndentedWriter)out, (PrefixMap)schema.getPrefixMap(), (boolean)true);
            hasHeader = true;
        }
        if (schema.getImports() != null && !schema.getImports().isEmpty()) {
            schema.getImports().forEach(importURI -> out.println("IMPORT <" + importURI + ">"));
            hasHeader = true;
        }
        boolean printNL = hasHeader;
        NodeFormatterTTL formatter = new NodeFormatterTTL(schema.getBase(), schema.getPrefixMap());
        schema.getShapes().forEach(arg_0 -> WriterShExC.lambda$print$1(out, (NodeFormatter)formatter, printNL, arg_0));
    }

    private static void print(IndentedWriter out, NodeFormatter formatter, ShexShape shape, boolean printNL) {
        if (printNL) {
            out.println();
        }
        if (shape.getLabel() != null) {
            Node n = shape.getLabel();
            if (n.equals((Object)SysShex.startNode)) {
                out.print("START=");
            } else {
                formatter.format((AWriter)out, n);
            }
            out.print(" ");
        }
        PrinterShExC shexPrinter = new PrinterShExC(out, formatter);
        ShapeExpression shapeEx = shape.getShapeExpression();
        shexPrinter.printShapeExpression(shapeEx);
    }

    static <X> void printList(IndentedWriter out, List<X> items, String start, String finish, String sep, Consumer<X> action) {
        if (items.isEmpty()) {
            return;
        }
        if (items.size() == 1) {
            action.accept(items.get(0));
            return;
        }
        if (start != null) {
            out.print(start);
            out.print(" ");
        }
        boolean first = true;
        for (X elt : items) {
            if (first) {
                first = false;
            } else {
                if (sep != null) {
                    out.print(sep);
                }
                out.print(" ");
            }
            action.accept(elt);
        }
        if (finish != null) {
            out.print(" ");
            out.print(finish);
        }
    }

    static void regexStringEsc(AWriter out, String s) {
        int len = s.length();
        block7: for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '\n': {
                    out.print("\\n");
                    continue block7;
                }
                case '\t': {
                    out.print("\\t");
                    continue block7;
                }
                case '\r': {
                    out.print("\\r");
                    continue block7;
                }
                case '\f': {
                    out.print("\\f");
                    continue block7;
                }
                case '/': {
                    out.print("\\");
                    out.print(c);
                    continue block7;
                }
                default: {
                    out.print(c);
                }
            }
        }
    }

    private static /* synthetic */ void lambda$print$1(IndentedWriter out, NodeFormatter formatter, boolean printNL, ShexShape shape) {
        WriterShExC.print(out, formatter, shape, printNL);
    }

    private static class PrinterShExC
    implements ShapeExprVisitor,
    TripleExprVisitor,
    NodeConstraintVisitor {
        final IndentedWriter out;
        final NodeFormatter formatter;
        private boolean inValueSet = false;

        public PrinterShExC(IndentedWriter out, NodeFormatter formatter) {
            this.out = out;
            this.formatter = formatter;
        }

        private void printShapeExpression(ShapeExpression shapeExpression) {
            shapeExpression.visit(this);
        }

        private void printTripleExpression(TripleExpression tripleExpr) {
            tripleExpr.visit(this);
            this.out.print(" ;");
        }

        private void printTripleExpressionNoSep(TripleExpression tripleExpr) {
            tripleExpr.visit(this);
        }

        private void printNodeConstraint(NodeConstraintComponent ncc) {
            ncc.visit(this);
        }

        private void printNode(Node node) {
            this.formatter.format((AWriter)this.out, node);
        }

        private void printValueSetRange(ValueSetRange vsr) {
            boolean b = this.inValueSet;
            if (!b) {
                this.out.print("[ ");
                this.inValueSet = true;
            }
            this.out.print(" ");
            String type = vsr.type();
            if (type.equals("unknown")) {
                this.out.print(".");
            } else {
                this.out.print(vsr.type());
            }
            this.printValueSetItem(vsr.item());
            if (vsr.numExclusions() > 0) {
                vsr.exclusions(vsi -> {
                    this.out.print(" -");
                    this.printValueSetItem((ValueSetItem)vsi);
                });
            }
            if (!b) {
                this.out.println(" ]");
                this.inValueSet = false;
            }
        }

        private void printValueSetItem(ValueSetItem item) {
            if (item.isEmpty()) {
                this.out.print(".");
                return;
            }
            item.print(this.out, this.formatter);
        }

        @Override
        public void visit(ShapeExprAND shape) {
            List<ShapeExpression> shapes = shape.expressions();
            WriterShExC.printList(this.out, shape.expressions(), null, null, " AND", x -> {
                boolean needParens;
                boolean bl = needParens = x instanceof ShapeExprAND || x instanceof ShapeExprOR;
                if (needParens) {
                    this.out.print("( ");
                }
                this.printShapeExpression((ShapeExpression)x);
                if (needParens) {
                    this.out.print(" )");
                }
            });
        }

        @Override
        public void visit(ShapeExprOR shape) {
            List<ShapeExpression> shapes = shape.expressions();
            WriterShExC.printList(this.out, shape.expressions(), null, null, " OR", x -> {
                boolean needParens;
                boolean bl = needParens = x instanceof ShapeExprAND || x instanceof ShapeExprOR;
                if (needParens) {
                    this.out.print("( ");
                }
                this.printShapeExpression((ShapeExpression)x);
                if (needParens) {
                    this.out.print(" )");
                }
            });
        }

        @Override
        public void visit(ShapeExprNOT shape) {
            this.out.print("NOT ");
            ShapeExpression shExpr = shape.subShape();
            boolean needParens = true;
            if (shExpr instanceof ShapeExprTripleExpr) {
                needParens = false;
            } else if (shExpr instanceof ShapeNodeConstraint) {
                needParens = false;
            } else if (shExpr instanceof ShapeExprAtom) {
                needParens = false;
            }
            if (needParens) {
                this.out.print("( ");
            }
            this.printShapeExpression(shape.subShape());
            if (needParens) {
                this.out.print(" ) ");
            }
        }

        @Override
        public void visit(ShapeExprDot shape) {
            this.out.print(". ");
        }

        @Override
        public void visit(ShapeExprAtom shape) {
            boolean multiLine = false;
            if (shape.getShape() == null) {
                return;
            }
            this.out.print("( ");
            this.out.incIndent();
            this.printShapeExpression(shape.getShape());
            this.out.decIndent();
            this.out.print(" ) ");
        }

        @Override
        public void visit(ShapeExprFalse shape) {
            this.out.print("FALSE");
        }

        @Override
        public void visit(ShapeExprNone shape) {
            this.out.print("{ }");
        }

        @Override
        public void visit(ShapeExprRef shape) {
            this.out.print("@");
            this.printNode(shape.getRef());
        }

        @Override
        public void visit(ShapeExprTrue shape) {
            this.out.print(" . ");
        }

        @Override
        public void visit(ShapeExprExternal shape) {
            this.out.println("EXTERNAL");
        }

        @Override
        public void visit(ShapeExprTripleExpr shape) {
            TripleExpression tripleExpr = shape.getTripleExpr();
            if (shape.isClosed()) {
                this.out.println("CLOSED ");
            }
            if (shape.getExtras() != null && !shape.getExtras().isEmpty()) {
                this.out.println("EXTRA ");
                shape.getExtras().forEach(n -> {
                    this.formatter.format((AWriter)this.out, n);
                    this.out.print(" ");
                });
            }
            this.out.println("{");
            this.out.incIndent();
            this.printTripleExpression(tripleExpr);
            this.out.decIndent();
            this.out.println("}");
        }

        @Override
        public void visit(StrRegexConstraint constraint) {
            this.out.print("/");
            String pattern = constraint.getPattern();
            WriterShExC.regexStringEsc((AWriter)this.out, pattern);
            this.out.print("/");
            if (constraint.getFlagsStr() != null) {
                this.out.print(constraint.getFlagsStr());
            }
        }

        @Override
        public void visit(StrLengthConstraint constraint) {
            this.out.print(constraint.getLengthType().label().toUpperCase(Locale.ROOT));
            this.out.print(" ");
            this.out.print(Integer.toString(constraint.getLength()));
        }

        @Override
        public void visit(DatatypeConstraint constraint) {
            this.formatter.formatURI((AWriter)this.out, constraint.getDatatypeURI());
        }

        @Override
        public void visit(NodeKindConstraint constraint) {
            this.out.print(constraint.getNodeKind().label().toUpperCase(Locale.ROOT));
        }

        @Override
        public void visit(NumLengthConstraint constraint) {
            this.out.print(constraint.getLengthType().label().toUpperCase(Locale.ROOT));
            this.out.print(" ");
            this.out.print(Integer.toString(constraint.getLength()));
        }

        @Override
        public void visit(NumRangeConstraint constraint) {
            this.out.print(constraint.getRangeKind().label().toUpperCase(Locale.ROOT));
            this.out.print(" ");
            this.printNode(constraint.getValue());
        }

        @Override
        public void visit(ValueConstraint constraint) {
            this.out.print("[ ");
            constraint.forEach(valueSetRange -> {
                this.printValueSetItem(valueSetRange.item());
                valueSetRange.exclusions(vsItem -> {
                    this.out.print(" -");
                    this.printValueSetItem((ValueSetItem)vsItem);
                });
            });
            this.out.print(" ]");
        }

        @Override
        public void visit(TripleExprCardinality tripleExpr) {
            this.out.incIndent();
            this.out.print("( ");
            this.printTripleExpressionNoSep(tripleExpr.target());
            this.out.print(" )");
            String x = tripleExpr.cardinalityString();
            this.out.print(x);
            this.out.decIndent();
        }

        @Override
        public void visit(TripleExprEachOf tripleExpr) {
            WriterShExC.printList(this.out, tripleExpr.expressions(), "(", ")", null, tExpr -> {
                this.out.incIndent();
                this.printTripleExpression((TripleExpression)tExpr);
                this.out.decIndent();
            });
            this.out.println();
        }

        @Override
        public void visit(TripleExprOneOf tripleExpr) {
            WriterShExC.printList(this.out, tripleExpr.expressions(), "(", ")", "|", tExpr -> {
                this.out.incIndent();
                this.printTripleExpression((TripleExpression)tExpr);
                this.out.decIndent();
            });
            this.out.println();
        }

        @Override
        public void visit(TripleExprNone tripleExpr) {
        }

        @Override
        public void visit(TripleExprRef tripleExpr) {
            this.out.print("&");
            this.printNode(tripleExpr.ref());
        }

        @Override
        public void visit(TripleConstraint tripleExpr) {
            Node predicate = tripleExpr.getPredicate();
            if (tripleExpr.reverse()) {
                this.out.print("^");
            }
            this.printNode(predicate);
            this.out.print(" ");
            this.printShapeExpression(tripleExpr.getShapeExpression());
            String x = tripleExpr.cardinalityString();
            if (x != null && !x.isEmpty()) {
                this.out.print(" ");
                this.out.print(x);
            }
        }

        @Override
        public void visit(ShapeNodeConstraint shape) {
            if (shape.getNodeConstraint() != null) {
                WriterShExC.printList(this.out, shape.getNodeConstraint().components(), null, null, null, nc -> {
                    this.out.incIndent();
                    this.printNodeConstraint((NodeConstraintComponent)nc);
                    this.out.decIndent();
                });
            }
        }
    }
}

