/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.arq.querybuilder.handlers;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.jena.arq.querybuilder.AbstractQueryBuilder;
import org.apache.jena.arq.querybuilder.Converters;
import org.apache.jena.arq.querybuilder.clauses.SelectClause;
import org.apache.jena.arq.querybuilder.handlers.Handler;
import org.apache.jena.arq.querybuilder.handlers.HandlerBlock;
import org.apache.jena.arq.querybuilder.handlers.PrologHandler;
import org.apache.jena.arq.querybuilder.handlers.ValuesHandler;
import org.apache.jena.arq.querybuilder.rewriters.BuildElementVisitor;
import org.apache.jena.arq.querybuilder.rewriters.ElementRewriter;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.Query;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.sparql.core.TriplePath;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.syntax.Element;
import org.apache.jena.sparql.syntax.ElementBind;
import org.apache.jena.sparql.syntax.ElementFilter;
import org.apache.jena.sparql.syntax.ElementGroup;
import org.apache.jena.sparql.syntax.ElementMinus;
import org.apache.jena.sparql.syntax.ElementNamedGraph;
import org.apache.jena.sparql.syntax.ElementOptional;
import org.apache.jena.sparql.syntax.ElementPathBlock;
import org.apache.jena.sparql.syntax.ElementSubQuery;
import org.apache.jena.sparql.syntax.ElementTriplesBlock;
import org.apache.jena.sparql.syntax.ElementUnion;
import org.apache.jena.sparql.syntax.ElementVisitor;
import org.apache.jena.sparql.util.ExprUtils;
import org.apache.jena.vocabulary.RDF;

public class WhereHandler
implements Handler {
    private final Query query;
    private final ValuesHandler valuesHandler;

    public WhereHandler(Query query) {
        this.query = query;
        this.valuesHandler = new ValuesHandler();
    }

    public WhereHandler() {
        this(new Query());
    }

    public Element getQueryPattern() {
        return this.query.getQueryPattern();
    }

    public Query getQuery() {
        return this.query;
    }

    public void addAll(WhereHandler whereHandler) {
        Element e = whereHandler.query.getQueryPattern();
        if (e != null) {
            ElementRewriter rewriter = new ElementRewriter(Collections.emptyMap());
            e.visit((ElementVisitor)rewriter);
            Element clone = (Element)rewriter.getResult();
            Element mine = this.query.getQueryPattern();
            if (mine == null) {
                this.query.setQueryPattern(clone);
            } else {
                ElementGroup eg = null;
                if (mine instanceof ElementGroup) {
                    eg = (ElementGroup)mine;
                } else {
                    eg = new ElementGroup();
                    eg.addElement(mine);
                }
                if (clone instanceof ElementGroup) {
                    for (Element ele : ((ElementGroup)clone).getElements()) {
                        eg.addElement(ele);
                    }
                } else {
                    eg.addElement(clone);
                }
                this.query.setQueryPattern((Element)eg);
            }
        }
        this.valuesHandler.addAll(whereHandler.valuesHandler);
    }

    public Element getElement() {
        Element result = this.query.getQueryPattern();
        if (result == null) {
            result = this.getClause();
        }
        return result;
    }

    public ElementGroup getClause() {
        Element e = this.query.getQueryPattern();
        if (e == null) {
            e = new ElementGroup();
            this.query.setQueryPattern(e);
        }
        if (e instanceof ElementGroup) {
            return (ElementGroup)e;
        }
        ElementGroup eg = new ElementGroup();
        eg.addElement(e);
        this.query.setQueryPattern((Element)eg);
        return eg;
    }

    private static void testTriple(TriplePath t) {
        boolean validObject;
        boolean validSubject;
        boolean bl = validSubject = t.getSubject().isURI() || t.getSubject().isBlank() || t.getSubject().isVariable() || t.getSubject().equals((Object)Node.ANY);
        boolean validPredicate = t.isTriple() ? t.getPredicate().isURI() || t.getPredicate().isVariable() || t.getPredicate().equals((Object)Node.ANY) : t.getPath() != null;
        boolean bl2 = validObject = t.getObject().isURI() || t.getObject().isLiteral() || t.getObject().isBlank() || t.getObject().isVariable() || t.getObject().equals((Object)Node.ANY);
        if (!(validSubject && validPredicate && validObject)) {
            StringBuilder sb = new StringBuilder();
            if (!validSubject) {
                sb.append(String.format("Subject (%s) must be a URI, blank, variable, or a wildcard. %n", t.getSubject()));
            }
            if (!validPredicate) {
                sb.append(String.format("Predicate (%s) must be a Path, URI , variable, or a wildcard. %n", t.getPredicate()));
            }
            if (!validObject) {
                sb.append(String.format("Object (%s) must be a URI, literal, blank, , variable, or a wildcard. %n", t.getObject()));
            }
            if (!validSubject || !validPredicate) {
                sb.append(String.format("Is a prefix missing?  Prefix must be defined before use. %n", new Object[0]));
            }
            throw new IllegalArgumentException(sb.toString());
        }
    }

    public void addWhere(TriplePath t) throws IllegalArgumentException {
        WhereHandler.testTriple(t);
        ElementGroup eg = this.getClause();
        List lst = eg.getElements();
        if (lst.isEmpty()) {
            ElementPathBlock epb = new ElementPathBlock();
            epb.addTriple(t);
            eg.addElement((Element)epb);
        } else {
            Element e = (Element)lst.get(lst.size() - 1);
            if (e instanceof ElementTriplesBlock && t.isTriple()) {
                ElementTriplesBlock etb = (ElementTriplesBlock)e;
                etb.addTriple(t.asTriple());
            } else if (e instanceof ElementPathBlock) {
                ElementPathBlock epb = (ElementPathBlock)e;
                epb.addTriple(t);
            } else {
                ElementPathBlock etb = new ElementPathBlock();
                etb.addTriple(t);
                eg.addElement((Element)etb);
            }
        }
    }

    public void addWhere(ValuesHandler values) throws IllegalArgumentException {
        this.valuesHandler.addAll(values);
    }

    public void addOptional(TriplePath t) throws IllegalArgumentException {
        WhereHandler.testTriple(t);
        ElementPathBlock epb = new ElementPathBlock();
        epb.addTriple(t);
        ElementOptional opt = new ElementOptional((Element)epb);
        this.getClause().addElement((Element)opt);
    }

    public void addOptional(WhereHandler whereHandler) {
        this.getClause().addElement((Element)new ElementOptional((Element)whereHandler.getClause()));
    }

    public void addFilter(String expression) {
        this.getClause().addElement((Element)new ElementFilter(ExprUtils.parse((Query)this.query, (String)expression, (boolean)true)));
    }

    public void addFilter(Expr expr) {
        this.getClause().addElement((Element)new ElementFilter(expr));
    }

    public void addSubQuery(AbstractQueryBuilder<?> subQuery) {
        this.getClause().addElement((Element)this.makeSubQuery(subQuery));
    }

    public ElementSubQuery makeSubQuery(AbstractQueryBuilder<?> subQuery) {
        Query q = new Query();
        q.setQuerySelectType();
        PrologHandler ph = new PrologHandler(this.query);
        ph.addPrefixes(subQuery.getPrologHandler().getPrefixes());
        HandlerBlock handlerBlock = new HandlerBlock(q);
        handlerBlock.addAll(subQuery.getHandlerBlock());
        handlerBlock.getPrologHandler().clearPrefixes();
        if (q.getQueryPattern() == null) {
            q.setQueryPattern((Element)new ElementGroup());
        }
        handlerBlock.build();
        return new ElementSubQuery(q);
    }

    public void addUnion(AbstractQueryBuilder<?> subQuery) {
        ElementUnion union = null;
        ElementGroup clause = this.getClause();
        if (!clause.isEmpty()) {
            Element lastElement = (Element)clause.getElements().get(clause.getElements().size() - 1);
            if (lastElement instanceof ElementUnion) {
                union = (ElementUnion)lastElement;
            } else {
                union = new ElementUnion();
                union.addElement((Element)clause);
                this.query.setQueryPattern((Element)union);
            }
        } else {
            union = new ElementUnion();
            clause.addElement((Element)union);
        }
        if (subQuery instanceof SelectClause && ((SelectClause)((Object)subQuery)).getVars().size() > 0) {
            union.addElement((Element)this.makeSubQuery(subQuery));
        } else {
            PrologHandler ph = new PrologHandler(this.query);
            ph.addPrefixes(subQuery.getPrologHandler().getPrefixes());
            union.addElement((Element)subQuery.getWhereHandler().getClause());
        }
    }

    public void addGraph(Node graph, WhereHandler subQuery) {
        this.getClause().addElement((Element)new ElementNamedGraph(graph, subQuery.getElement()));
    }

    public void addGraph(Node graph, TriplePath subQuery) {
        ElementPathBlock epb = new ElementPathBlock();
        epb.addTriple(subQuery);
        this.getClause().addElement((Element)new ElementNamedGraph(graph, (Element)epb));
    }

    public void addBind(Expr expr, Var var) {
        this.getClause().addElement((Element)new ElementBind(var, expr));
    }

    public void addBind(String expression, Var var) {
        this.getClause().addElement((Element)new ElementBind(var, ExprUtils.parse((Query)this.query, (String)expression, (boolean)true)));
    }

    @Override
    public void setVars(Map<Var, Node> values) {
        if (values.isEmpty()) {
            return;
        }
        Element e = this.query.getQueryPattern();
        if (e != null) {
            ElementRewriter r = new ElementRewriter(values);
            e.visit((ElementVisitor)r);
            this.query.setQueryPattern((Element)r.getResult());
        }
        this.valuesHandler.setVars(values);
    }

    @Override
    public void build() {
        BuildElementVisitor visitor = new BuildElementVisitor();
        this.getElement().visit((ElementVisitor)visitor);
        if (!this.valuesHandler.isEmpty()) {
            if (visitor.getResult() instanceof ElementGroup) {
                ((ElementGroup)visitor.getResult()).addElement((Element)this.valuesHandler.asElement());
            } else {
                ElementGroup eg = new ElementGroup();
                eg.addElement(visitor.getResult());
                eg.addElement((Element)this.valuesHandler.asElement());
                visitor.setResult((Element)eg);
            }
        }
        this.query.setQueryPattern(visitor.getResult());
    }

    public Node list(Object ... objs) {
        Node retval;
        Node lastObject = retval = NodeFactory.createBlankNode();
        for (int i = 0; i < objs.length; ++i) {
            Node n = Converters.makeNode(objs[i], this.query.getPrefixMapping());
            this.addWhere(new TriplePath(Triple.create((Node)lastObject, (Node)RDF.first.asNode(), (Node)n)));
            if (i + 1 < objs.length) {
                Node nextObject = NodeFactory.createBlankNode();
                this.addWhere(new TriplePath(Triple.create((Node)lastObject, (Node)RDF.rest.asNode(), (Node)nextObject)));
                lastObject = nextObject;
                continue;
            }
            this.addWhere(new TriplePath(Triple.create((Node)lastObject, (Node)RDF.rest.asNode(), (Node)RDF.nil.asNode())));
        }
        return retval;
    }

    public void addMinus(AbstractQueryBuilder<?> qb) {
        PrologHandler ph = new PrologHandler(this.query);
        ph.addPrefixes(qb.getPrologHandler().getPrefixes());
        ElementGroup clause = this.getClause();
        ElementMinus minus = new ElementMinus((Element)qb.getWhereHandler().getClause());
        clause.addElement((Element)minus);
    }

    public void addValueVar(PrefixMapping prefixMapping, Object var) {
        if (var == null) {
            throw new IllegalArgumentException("var must not be null.");
        }
        if (var instanceof Collection) {
            Collection column = (Collection)var;
            if (column.size() == 0) {
                throw new IllegalArgumentException("column must have at least one entry.");
            }
            Iterator iter = column.iterator();
            Var v = Converters.makeVar(iter.next());
            this.valuesHandler.addValueVar(v, Converters.makeValueNodes(iter, prefixMapping));
        } else {
            this.valuesHandler.addValueVar(Converters.makeVar(var), null);
        }
    }

    public void addValueVar(PrefixMapping prefixMapping, Object var, Object ... objects) {
        Collection<Node> values = null;
        if (objects != null) {
            values = Converters.makeValueNodes(Arrays.asList(objects).iterator(), prefixMapping);
        }
        this.valuesHandler.addValueVar(Converters.makeVar(var), values);
    }

    public <K extends Collection<?>> void addValueVars(PrefixMapping prefixMapping, Map<?, K> dataTable) {
        ValuesHandler hdlr = new ValuesHandler();
        for (Map.Entry<?, K> entry : dataTable.entrySet()) {
            Collection<Node> values = null;
            if (entry.getValue() != null) {
                values = Converters.makeValueNodes(((Collection)entry.getValue()).iterator(), prefixMapping);
            }
            hdlr.addValueVar(Converters.makeVar(entry.getKey()), values);
        }
        this.valuesHandler.addAll(hdlr);
    }

    public void addValueRow(PrefixMapping prefixMapping, Object ... values) {
        this.valuesHandler.addValueRow(Converters.makeValueNodes(Arrays.asList(values).iterator(), prefixMapping));
    }

    public void addValueRow(PrefixMapping prefixMapping, Collection<?> values) {
        this.valuesHandler.addValueRow(Converters.makeValueNodes(values.iterator(), prefixMapping));
    }

    public List<Var> getValuesVars() {
        return this.valuesHandler.getValuesVars();
    }

    public Map<Var, List<Node>> getValuesMap() {
        return this.valuesHandler.getValuesMap();
    }

    public void clearValues() {
        this.valuesHandler.clear();
    }
}

