/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.iri.impl;

import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.jena.iri.IRI;
import org.apache.jena.iri.IRIComponents;
import org.apache.jena.iri.MalformedIDNException;
import org.apache.jena.iri.Violation;
import org.apache.jena.iri.ViolationCodes;
import org.apache.jena.iri.impl.IDNP;
import org.apache.jena.iri.impl.IRIImpl;
import org.apache.jena.iri.impl.Parser;
import org.apache.jena.iri.impl.ResolvedRelativeIRI;
import org.apache.jena.iri.impl.SchemeSpecificPart;
import org.apache.jena.iri.impl.ViolationImpl;

public abstract class AbsIRIImpl
extends IRI
implements ViolationCodes,
IRIComponents {
    private static final int defaultRelative = 61;
    private long foundExceptionMask;
    long allErrors;
    private ArrayList<Violation> foundExceptions;
    protected String path;
    private static final char[] hex = "0123456789ABCDEF".toCharArray();
    static final Iterator<Violation> nullIterator = new ArrayList(0).iterator();
    protected static final int NO_EXCEPTIONS = 1;
    protected static final int ALL_EXCEPTIONS = 2;
    protected static final int NOT_RELATIVE_EXCEPTIONS = 3;
    protected static final int PATH_INDEX = Parser.invFields[11];
    static long ToAsciiMask = -1L;
    private static final PathRelativize child = new PathRelativize(8, 56, "."){

        @Override
        String descendentMatch(String descendent) {
            return AbsIRIImpl.maybeDotSlash(descendent);
        }
    };
    private static final PathRelativize parent = new PathRelativize(16, 48, "..");
    private static final PathRelativize grandparent = new PathRelativize(32, 32, "../..");

    static String removeDotSegments(String path) {
        int inputBufferStart = 0;
        int inputBufferEnd = path.length();
        StringBuffer output = new StringBuffer();
        while (inputBufferStart < inputBufferEnd) {
            String in = path.substring(inputBufferStart);
            if (in.startsWith("./")) {
                inputBufferStart += 2;
                continue;
            }
            if (in.startsWith("../")) {
                inputBufferStart += 3;
                continue;
            }
            if (in.startsWith("/./")) {
                inputBufferStart += 2;
                continue;
            }
            if (in.equals("/.")) {
                in = "/";
                inputBufferStart += 2;
            }
            if (in.startsWith("/../")) {
                inputBufferStart += 3;
                AbsIRIImpl.removeLastSeqment(output);
                continue;
            }
            if (in.equals("/..")) {
                in = "/";
                inputBufferStart += 3;
                AbsIRIImpl.removeLastSeqment(output);
            }
            if (in.equals(".")) {
                ++inputBufferStart;
                continue;
            }
            if (in.equals("..")) {
                inputBufferStart += 2;
                continue;
            }
            int nextSlash = in.indexOf(47, 1);
            if (nextSlash == -1) {
                nextSlash = in.length();
            }
            inputBufferStart += nextSlash;
            output.append(in.substring(0, nextSlash));
        }
        return output.toString();
    }

    private static void removeLastSeqment(StringBuffer output) {
        int ix = output.length();
        while (ix > 0 && output.charAt(--ix) != '/') {
        }
        output.setLength(ix);
    }

    abstract long errors(int var1);

    abstract SchemeSpecificPart getSchemeSpec();

    abstract Exception getIDNAException();

    boolean hasExceptionMask(long mask) {
        return (this.allErrors & mask) != 0L;
    }

    Iterator<Violation> exceptionsMask(final long mask) {
        this.createExceptions(mask);
        return this.foundExceptions == null ? nullIterator : new Iterator<Violation>(){
            private Iterator<Violation> underlying;
            private Violation next;
            {
                this.underlying = AbsIRIImpl.this.foundExceptions.iterator();
            }

            @Override
            public boolean hasNext() {
                if (this.next == null) {
                    while (this.underlying.hasNext()) {
                        this.next = this.underlying.next();
                        if ((1L << this.next.getViolationCode() & mask) == 0L) continue;
                        return true;
                    }
                    this.next = null;
                    return false;
                }
                return true;
            }

            @Override
            public Violation next() {
                if (this.hasNext()) {
                    Violation rslt = this.next;
                    this.next = null;
                    return rslt;
                }
                throw new NoSuchElementException();
            }
        };
    }

    private void createExceptions(long m) {
        if ((this.allErrors & (m &= this.foundExceptionMask ^ 0xFFFFFFFFFFFFFFFFL)) != 0L) {
            if (this.foundExceptions == null) {
                this.foundExceptions = new ArrayList();
            }
            for (int i = 0; i < Parser.fields.length; ++i) {
                int f = Parser.fields[i];
                if ((this.errors(f) & m) == 0L) continue;
                for (int e = 0; e < 64; ++e) {
                    if ((1L << e & m & this.errors(f)) == 0L) continue;
                    this.foundExceptions.add(new ViolationImpl(this, f, e));
                }
            }
        }
        this.foundExceptionMask |= m;
    }

    @Override
    public boolean isAbsolute() {
        return this.has(2);
    }

    abstract boolean has(int var1);

    @Override
    public boolean isRelative() {
        return !this.has(2);
    }

    @Override
    public boolean hasViolation(boolean includeWarnings) {
        return this.hasExceptionMask(this.getSchemeSpec().getMask(includeWarnings));
    }

    @Override
    public Iterator<Violation> violations(boolean includeWarnings) {
        return this.exceptionsMask(this.getSchemeSpec().getMask(includeWarnings));
    }

    @Override
    public URL toURL() throws MalformedURLException {
        return new URL(this.toASCIIString());
    }

    @Override
    public URI toURI() throws URISyntaxException {
        try {
            String x = this.createASCIIString();
            return new URI(x);
        }
        catch (MalformedIDNException ex) {
            throw new URISyntaxException(this.toDisplayString(), ex.getMessage());
        }
    }

    @Override
    public String toASCIIString() throws MalformedIDNException {
        if (this.hasExceptionMask(ToAsciiMask)) {
            return this.createASCIIString();
        }
        return this.toString();
    }

    private String createASCIIString() throws MalformedIDNException {
        StringBuffer asciiString = new StringBuffer();
        if (this.has(2)) {
            this.toAscii(asciiString, this.getScheme(), this.errors(2));
            asciiString.append(':');
        }
        if (this.has(4)) {
            asciiString.append("//");
            if (this.has(6)) {
                this.toAscii(asciiString, this.getRawUserinfo(), this.errors(6));
                asciiString.append('@');
            }
            String host = this.getRawHost();
            this.regNameToAscii(asciiString, host);
            if (this.has(10)) {
                asciiString.append(':');
                this.toAscii(asciiString, this.get(10), this.errors(6));
            }
        }
        this.toAscii(asciiString, this.getRawPath(), this.errors(11));
        if (this.has(13)) {
            asciiString.append('?');
            this.toAscii(asciiString, this.getRawQuery(), this.errors(13));
        }
        if (this.has(15)) {
            asciiString.append('#');
            this.toAscii(asciiString, this.getRawFragment(), this.errors(15));
        }
        return asciiString.toString();
    }

    private void regNameToAscii(StringBuffer asciiString, String host) throws MalformedIDNException {
        if ((this.errors(7) & ToAsciiMask) == 0L) {
            asciiString.append(host);
            return;
        }
        asciiString.append(AbsIRIImpl.domainToAscii(host));
    }

    private static CharSequence domainToAscii(String host) throws MalformedIDNException {
        try {
            return IDNP.toASCII(host, 3);
        }
        catch (IllegalArgumentException ex) {
            throw new MalformedIDNException(ex);
        }
    }

    private void toAscii(StringBuffer asciiString, String field, long errs) {
        if ((errs & ToAsciiMask) == 0L) {
            asciiString.append(field);
            return;
        }
        for (int i = 0; i < field.length(); ++i) {
            char ch = field.charAt(i);
            if (ch > '\u007f' || "<>\" {}|\\^`".indexOf(ch) != -1 || ch < ' ') {
                byte[] b;
                try {
                    b = field.substring(i, i + 1).getBytes("utf-8");
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException("Impossible - utf-8 unsupported");
                }
                for (byte aB : b) {
                    char[] buf = new char[]{'%', hex[(aB & 0xF0) >> 4], hex[aB & 0xF]};
                    asciiString.append(buf);
                }
                continue;
            }
            asciiString.append(new char[]{ch});
        }
    }

    private boolean relativizePaths(String in, String[] out, int flags, String rel) {
        if (child.check(in, out, flags, rel)) {
            return true;
        }
        if (parent.check(out[0], out, flags, rel)) {
            return true;
        }
        return grandparent.check(out[0], out, flags, rel);
    }

    @Override
    public IRI relativize(String abs, int flags) {
        return this.relativize(new IRIImpl(this.getFactory(), abs), flags);
    }

    @Override
    public IRI relativize(String abs) {
        return this.relativize(abs, 61);
    }

    @Override
    public IRI relativize(IRI abs) {
        return this.relativize(abs, 61);
    }

    @Override
    public IRI relativize(IRI abs, int flags) {
        String rslt = this.relativize(abs, null, flags);
        return rslt == null ? abs : this.getFactory().create(rslt);
    }

    private String relativize(IRI r, String def, int flags) {
        Object rslt;
        if (!this.has(4)) {
            return def;
        }
        if (!((AbsIRIImpl)r).has(4)) {
            return def;
        }
        boolean net = this.equal(r.getScheme(), this.getScheme());
        boolean absl = net && this.equal(r.getRawHost(), this.getRawHost()) && this.equal(this.getRawUserinfo(), r.getRawUserinfo()) && this.equal(this.getPort(), r.getPort());
        boolean same = absl && this.equal(this.getRawPath(), r.getRawPath()) && this.equal(this.getRawQuery(), r.getRawQuery());
        Object object = rslt = r.getRawFragment() == null ? "" : "#" + r.getRawFragment();
        if (same && (flags & 1) != 0) {
            return rslt;
        }
        String thisPath = this.getRawPath();
        String pathToRel = r.getRawPath();
        if (r.getRawQuery() != null) {
            rslt = "?" + r.getRawQuery() + (String)rslt;
            if (this.equal(thisPath, pathToRel) && (flags & 8) != 0) {
                return rslt;
            }
        }
        if (absl) {
            if (pathToRel.length() > 0) {
                String[] out;
                if (thisPath.length() > 0 && this.relativizePaths(thisPath, out = new String[]{null}, flags, pathToRel)) {
                    return out[0] + (String)rslt;
                }
                rslt = r.getRawPath() + (String)rslt;
                if (absl && (flags & 4) != 0) {
                    return rslt;
                }
            }
        } else {
            rslt = r.getRawPath() + (String)rslt;
        }
        if (net && (flags & 2) != 0) {
            return "//" + (String)(r.getRawUserinfo() == null ? "" : r.getRawUserinfo() + "@") + r.getRawHost() + (String)(r.getPort() == -1 ? "" : ":" + ((AbsIRIImpl)r).get(10)) + (String)rslt;
        }
        return def;
    }

    private static String maybeDotSlash(String path) {
        int colon = path.indexOf(58);
        if (colon == -1) {
            return path;
        }
        int slash = path.indexOf(47);
        if (slash == -1 || slash > colon) {
            return "./" + path;
        }
        return path;
    }

    private static String getLastSlash(String s) {
        int ix = s.lastIndexOf(47, s.length() - 2);
        return s.substring(0, ix + 1);
    }

    private boolean equal(String s1, String s2) {
        return s1 == null ? s2 == null : s1.equals(s2);
    }

    private boolean equal(int s1, int s2) {
        return s1 == s2;
    }

    public Iterator<Violation> allViolations() {
        return this.exceptionsMask(-1L);
    }

    @Override
    public String getRawUserinfo() {
        return this.get(6);
    }

    @Override
    public int getPort() {
        String port = this.get(10);
        if (port == null) {
            return -1;
        }
        try {
            int v = Integer.parseInt(port);
            if (v < 0) {
                return -2;
            }
            return v;
        }
        catch (Exception e) {
            return -2;
        }
    }

    @Override
    public String getRawQuery() {
        return this.get(13);
    }

    @Override
    public String getRawFragment() {
        return this.get(15);
    }

    @Override
    public String getRawHost() {
        return this.get(7);
    }

    @Override
    public String getScheme() {
        return this.get(2);
    }

    abstract String get(int var1);

    @Override
    public String getRawPath() {
        return this.path;
    }

    @Override
    public boolean isRootless() {
        if (!this.has(2)) {
            return false;
        }
        if (this.has(4)) {
            return false;
        }
        if (this.path.equals("")) {
            return false;
        }
        return this.path.charAt(0) != '/';
    }

    abstract String pathRemoveDots();

    abstract boolean dotsOK();

    @Override
    public String getRawAuthority() {
        return this.get(4);
    }

    @Override
    public IRI create(IRI i) {
        return new ResolvedRelativeIRI(this, (AbsIRIImpl)this.getFactory().create(i));
    }

    @Override
    public IRI create(String s) {
        return this.create(new IRIImpl(this.getFactory(), s));
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof IRI)) {
            return false;
        }
        return this.toString().equals(o.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    @Override
    public String getAuthority() {
        return this.getCooked(4);
    }

    @Override
    public String getFragment() {
        return this.getCooked(15);
    }

    @Override
    public String getHost() {
        return this.getCooked(7);
    }

    @Override
    public String getPath() {
        return this.getCooked(11);
    }

    @Override
    public String getQuery() {
        return this.getCooked(13);
    }

    @Override
    public String getUserinfo() {
        return this.getCooked(6);
    }

    private String getCooked(int component) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    @Override
    public IRI normalize(boolean useDns) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    @Override
    public String toDisplayString() {
        return "\u202a" + this.toString() + "\u202c";
    }

    @Override
    public String getASCIIHost() throws MalformedURLException {
        StringBuffer asciiString = new StringBuffer();
        String host = this.getRawHost();
        if (host == null) {
            return null;
        }
        this.regNameToAscii(asciiString, host);
        return asciiString.toString();
    }

    @Override
    public boolean ladderEquals(IRI iri, int other) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    @Override
    public int ladderEquals(IRI iri) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    static class PathRelativize {
        private final int flag;
        private final int allFlags;
        private final String replacement;

        PathRelativize(int flag, int allFlags, String replacement) {
            this.flag = flag;
            this.replacement = replacement;
            this.allFlags = allFlags;
        }

        boolean check(String in, String[] out, int flags, String rel) {
            out[0] = null;
            if (in == null) {
                return false;
            }
            if ((flags & this.allFlags) == 0) {
                return false;
            }
            int ix = in.lastIndexOf(47);
            if (ix == -1) {
                return false;
            }
            if (ix == 0 && (flags & 4) != 0 && this.flag != 8) {
                return false;
            }
            in = in.substring(0, ix + 1);
            out[0] = in.substring(0, ix);
            if ((flags & this.flag) == 0) {
                return false;
            }
            if (!rel.startsWith(in)) {
                return false;
            }
            if (rel.length() == ix + 1) {
                out[0] = this.replacement;
                return true;
            }
            out[0] = this.descendentMatch(rel.substring(ix + 1));
            return true;
        }

        String descendentMatch(String descendent) {
            return this.replacement + "/" + descendent;
        }
    }
}

