/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.rdf.model;

import java.util.Calendar;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.xsd.XSDDatatype;
import org.apache.jena.datatypes.xsd.XSDDateTime;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.impl.LiteralLabel;
import org.apache.jena.graph.impl.LiteralLabelFactory;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.impl.LiteralImpl;
import org.apache.jena.rdf.model.impl.PropertyImpl;
import org.apache.jena.rdf.model.impl.ResourceImpl;
import org.apache.jena.rdf.model.impl.StatementImpl;

public class ResourceFactory {
    protected static Interface instance = new Impl();

    private ResourceFactory() {
    }

    public static Interface getInstance() {
        return instance;
    }

    public static Interface setInstance(Interface newInstance) {
        Interface previousInstance = instance;
        instance = newInstance;
        return previousInstance;
    }

    public static Resource createResource() {
        return instance.createResource();
    }

    public static Resource createResource(String uriref) {
        return instance.createResource(uriref);
    }

    public static Resource createStmtResource(Statement statement) {
        return instance.createStmtResource(statement);
    }

    public static Literal createPlainLiteral(String string) {
        return instance.createStringLiteral(string);
    }

    public static Literal createStringLiteral(String string) {
        return instance.createStringLiteral(string);
    }

    public static Literal createLangLiteral(String string, String lang) {
        return instance.createLangLiteral(string, lang);
    }

    public static Literal createTypedLiteral(String string, RDFDatatype dType) {
        return instance.createTypedLiteral(string, dType);
    }

    public static Literal createTypedLiteral(Object value) {
        return instance.createTypedLiteral(value);
    }

    public static Property createProperty(String uriref) {
        return instance.createProperty(uriref);
    }

    public static Property createProperty(String namespace, String localName) {
        return instance.createProperty(namespace, localName);
    }

    public static Statement createStatement(Resource subject, Property predicate, RDFNode object) {
        return instance.createStatement(subject, predicate, object);
    }

    public static interface Interface {
        public Resource createResource();

        public Resource createResource(String var1);

        public Resource createStmtResource(Statement var1);

        public Literal createStringLiteral(String var1);

        @Deprecated
        default public Literal createPlainLiteral(String string) {
            return this.createStringLiteral(string);
        }

        public Literal createLangLiteral(String var1, String var2);

        public Literal createTypedLiteral(String var1, RDFDatatype var2);

        public Literal createTypedLiteral(Object var1);

        public Property createProperty(String var1);

        public Property createProperty(String var1, String var2);

        public Statement createStatement(Resource var1, Property var2, RDFNode var3);
    }

    static class Impl
    implements Interface {
        Impl() {
        }

        @Override
        public Resource createResource() {
            return new ResourceImpl();
        }

        @Override
        public Resource createResource(String uriref) {
            return new ResourceImpl(uriref);
        }

        @Override
        public Resource createStmtResource(Statement statement) {
            return new ResourceImpl(statement, null);
        }

        @Override
        public Literal createStringLiteral(String string) {
            return new LiteralImpl(NodeFactory.createLiteral(string, ""), null);
        }

        @Override
        public Literal createLangLiteral(String string, String lang) {
            return new LiteralImpl(NodeFactory.createLiteral(string, lang), null);
        }

        @Override
        public Literal createTypedLiteral(String string, RDFDatatype dType) {
            return new LiteralImpl(NodeFactory.createLiteral(string, dType), null);
        }

        @Override
        public Literal createTypedLiteral(Object value) {
            LiteralLabel ll = null;
            if (value instanceof Calendar) {
                XSDDateTime valuec = new XSDDateTime((Calendar)value);
                ll = LiteralLabelFactory.createByValue(valuec, "", XSDDatatype.XSDdateTime);
            } else {
                ll = LiteralLabelFactory.createTypedLiteral(value);
            }
            return new LiteralImpl(NodeFactory.createLiteral(ll), null);
        }

        @Override
        public Property createProperty(String uriref) {
            return new PropertyImpl(uriref);
        }

        @Override
        public Property createProperty(String namespace, String localName) {
            return new PropertyImpl(namespace, localName);
        }

        @Override
        public Statement createStatement(Resource subject, Property predicate, RDFNode object) {
            return new StatementImpl(subject, predicate, object);
        }
    }
}

