/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.procedure;

import org.apache.jena.graph.Node;
import org.apache.jena.sparql.algebra.op.OpProcedure;
import org.apache.jena.sparql.engine.ExecutionContext;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.expr.ExprList;
import org.apache.jena.sparql.pfunction.ProcedurePF;
import org.apache.jena.sparql.pfunction.PropFuncArg;
import org.apache.jena.sparql.pfunction.PropertyFunction;
import org.apache.jena.sparql.pfunction.PropertyFunctionFactory;
import org.apache.jena.sparql.pfunction.PropertyFunctionRegistry;
import org.apache.jena.sparql.procedure.Procedure;
import org.apache.jena.sparql.procedure.ProcedureFactory;
import org.apache.jena.sparql.procedure.ProcedureRegistry;
import org.apache.jena.sparql.util.Context;

public class ProcEval {
    public static Procedure build(OpProcedure opProc, ExecutionContext execCxt) {
        return ProcEval.build(opProc.getProcId(), opProc.getArgs(), execCxt);
    }

    public static Procedure build(Node procId, ExprList args, ExecutionContext execCxt) {
        Context context2 = execCxt.getContext();
        ProcedureRegistry reg = ProcEval.chooseProcedureRegistry(context2);
        ProcedureFactory f = reg.get(procId.getURI());
        Procedure proc = f.create(procId.getURI());
        args.prepareExprs(context2);
        proc.build(procId, args, execCxt);
        return proc;
    }

    private static ProcedureRegistry chooseProcedureRegistry(Context context2) {
        ProcedureRegistry registry = ProcedureRegistry.get(context2);
        if (registry == null) {
            registry = ProcedureRegistry.get();
        }
        return registry;
    }

    public static Procedure build(Node procId, PropFuncArg subjArg, PropFuncArg objArg, ExecutionContext execCxt) {
        Context context2 = execCxt.getContext();
        PropertyFunctionRegistry reg = PropertyFunctionRegistry.chooseRegistry(context2);
        PropertyFunctionFactory f = reg.get(procId.getURI());
        PropertyFunction pf = f.create(procId.getURI());
        pf.build(subjArg, procId, objArg, execCxt);
        return new ProcedurePF(pf, subjArg, procId, objArg);
    }

    public static QueryIterator eval(QueryIterator queryIterator, Procedure proc, ExecutionContext execCxt) {
        return proc.proc(queryIterator, execCxt);
    }
}

