/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.core.mem;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.apache.jena.sparql.core.mem.PMapTripleTable;
import org.apache.jena.sparql.core.mem.TripleTable;
import org.apache.jena.sparql.core.mem.TupleSlot;

public enum TripleTableForm implements Supplier<TripleTable>,
Predicate<Set<TupleSlot>>
{
    SPO(EnumSet.of(TupleSlot.SUBJECT, TupleSlot.PREDICATE), TupleSlot.SUBJECT),
    POS(EnumSet.of(TupleSlot.PREDICATE, TupleSlot.OBJECT), TupleSlot.PREDICATE),
    OSP(EnumSet.of(TupleSlot.OBJECT, TupleSlot.SUBJECT), TupleSlot.OBJECT);

    public final Set<TupleSlot> twoPrefix;
    public final Set<TupleSlot> onePrefix;

    private TripleTableForm(Set<TupleSlot> tp, TupleSlot op) {
        this.twoPrefix = tp;
        this.onePrefix = EnumSet.of(op);
    }

    @Override
    public TripleTable get() {
        return new PMapTripleTable(this.name());
    }

    @Override
    public boolean test(Set<TupleSlot> pattern) {
        return this.twoPrefix.equals(pattern) || this.onePrefix.equals(pattern) || pattern.size() == 3;
    }

    public static TripleTableForm chooseFrom(Set<TupleSlot> pattern) {
        return TripleTableForm.tableForms().filter(f -> f.test(pattern)).findFirst().orElse(SPO);
    }

    public static Stream<TripleTableForm> tableForms() {
        return Arrays.stream(TripleTableForm.values());
    }
}

