/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.rowset.rw;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import org.apache.jena.atlas.csv.CSVParser;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.logging.FmtLog;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.riot.resultset.ResultSetLang;
import org.apache.jena.riot.rowset.RowSetReader;
import org.apache.jena.riot.rowset.RowSetReaderFactory;
import org.apache.jena.sparql.ARQException;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingBuilder;
import org.apache.jena.sparql.exec.QueryExecResult;
import org.apache.jena.sparql.exec.RowSet;
import org.apache.jena.sparql.exec.RowSetStream;
import org.apache.jena.sparql.resultset.ResultSetException;
import org.apache.jena.sparql.util.Context;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RowSetReaderCSV
implements RowSetReader {
    private static Logger log = LoggerFactory.getLogger(RowSetReaderCSV.class);
    public static final RowSetReaderFactory factory = lang -> {
        if (!Objects.equals(lang, ResultSetLang.RS_CSV)) {
            throw new ResultSetException("RowSetReaderCSV for CSV asked for a " + lang);
        }
        return new RowSetReaderCSV();
    };

    private RowSetReaderCSV() {
    }

    @Override
    public QueryExecResult readAny(InputStream in, Context context2) {
        return RowSetReaderCSV.csvResult(in);
    }

    @Override
    public RowSet read(InputStream in, Context context2) {
        return RowSetReaderCSV.resultSetFromCSV(in);
    }

    private static QueryExecResult csvResult(InputStream in) {
        CSVParser parser = CSVParser.create(in);
        List<Var> vars = RowSetReaderCSV.vars(parser);
        if (RowSetReaderCSV.isBooleanResult(vars)) {
            boolean booleanResult = RowSetReaderCSV.booleanFromCSV(parser);
            return new QueryExecResult(booleanResult);
        }
        RowSet resultSet = RowSetReaderCSV.resultSetFromCSV(vars, parser);
        return new QueryExecResult(resultSet);
    }

    private static RowSet resultSetFromCSV(InputStream in) {
        CSVParser parser = CSVParser.create(in);
        List<Var> vars = RowSetReaderCSV.vars(parser);
        return RowSetReaderCSV.resultSetFromCSV(vars, parser);
    }

    private static RowSet resultSetFromCSV(final List<Var> vars, CSVParser parser) {
        final BindingBuilder builder = Binding.builder();
        Function<List<String>, Binding> transform = new Function<List<String>, Binding>(){
            private int count = 1;

            @Override
            public Binding apply(List<String> row) {
                if (row.size() != vars.size()) {
                    FmtLog.warn((Logger)log, (String)"Row %d: Length=%d: expected=%d", (Object[])new Object[]{this.count, row.size(), vars.size()});
                }
                builder.reset();
                for (int i = 0; i < vars.size(); ++i) {
                    Var v = (Var)((Object)vars.get(i));
                    String field = i < row.size() ? row.get(i) : "";
                    Node n = NodeFactory.createLiteral((String)field);
                    builder.add(v, n);
                }
                ++this.count;
                return builder.build();
            }
        };
        Iterator bindings = Iter.map(parser.iterator(), (Function)transform);
        return RowSetStream.create(vars, bindings);
    }

    private static List<Var> vars(CSVParser parser) {
        ArrayList<Var> vars = new ArrayList<Var>();
        List<String> varNames = parser.parse1();
        if (varNames == null) {
            throw new ARQException("SPARQL CSV Results malformed, input is empty");
        }
        for (String vn : varNames) {
            vars.add(Var.alloc(vn));
        }
        return vars;
    }

    private static boolean isBooleanResult(List<Var> vars) {
        if (vars.size() != 1) {
            return false;
        }
        return vars.get(0).getName().equals("_askResult");
    }

    private static boolean booleanFromCSV(CSVParser parser) {
        boolean b;
        List<String> line = parser.parse1();
        if (line.size() != 1) {
            throw new ARQException("CSV Boolean Results malformed: data line='" + line + "'");
        }
        String str2 = line.get(0);
        if (str2.equalsIgnoreCase("true") || str2.equalsIgnoreCase("yes")) {
            b = true;
        } else if (str2.equalsIgnoreCase("false") || str2.equalsIgnoreCase("no")) {
            b = false;
        } else {
            throw new ARQException("CSV Boolean Results malformed, expected one of - true yes false no - but got " + str2);
        }
        List<String> line2 = parser.parse1();
        if (line2 != null) {
            FmtLog.warn((Logger)log, (String)("Extra rows: first is " + line2), (Object[])new Object[0]);
        }
        return b;
    }
}

