/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lyo.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultRedirectStrategy;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.eclipse.lyo.client.OslcClient;
import org.eclipse.lyo.client.exception.ResourceNotFoundException;
import org.eclipse.lyo.client.exception.RootServicesException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RootServicesHelper {
    private String baseUrl;
    private String rootServicesUrl;
    private String catalogDomain;
    private String catalogNamespace;
    private String catalogProperty;
    private String catalogUrl;
    private Model rdfModel;
    String authorizationRealm;
    String requestTokenUrl;
    String authorizationTokenUrl;
    String accessTokenUrl;
    String requestConsumerKeyUrl;
    String consumerApprovalUrl;
    public static final String JFS_NAMESPACE = "http://jazz.net/xmlns/prod/jazz/jfs/1.0/";
    public static final String JD_NAMESPACE = "http://jazz.net/xmlns/prod/jazz/discovery/1.0/";
    private static final Logger logger = LoggerFactory.getLogger(RootServicesHelper.class);

    public RootServicesHelper(String url, String catalogDomain, OslcClient client) throws RootServicesException {
        this.baseUrl = url;
        this.rootServicesUrl = UriBuilder.fromUri((String)this.baseUrl).path("rootservices").build(new Object[0]).toString();
        logger.debug(String.format("Fetching rootservices document at URL <%s>", this.rootServicesUrl));
        this.catalogDomain = catalogDomain;
        logger.debug(String.format("Using catalog domain <%s>", this.catalogDomain));
        if (this.catalogDomain.equalsIgnoreCase("http://open-services.net/xmlns/cm/1.0/") || this.catalogDomain.equalsIgnoreCase("http://open-services.net/ns/cm#")) {
            this.catalogNamespace = "http://open-services.net/xmlns/cm/1.0/";
            this.catalogProperty = "cmServiceProviders";
        } else if (this.catalogDomain.equalsIgnoreCase("http://open-services.net/xmlns/qm/1.0/") || this.catalogDomain.equalsIgnoreCase("http://open-services.net/ns/qm#")) {
            this.catalogNamespace = "http://open-services.net/xmlns/qm/1.0/";
            this.catalogProperty = "qmServiceProviders";
        } else if (this.catalogDomain.equalsIgnoreCase("http://open-services.net/xmlns/rm/1.0/") || this.catalogDomain.equalsIgnoreCase("http://open-services.net/ns/rm#")) {
            this.catalogNamespace = "http://open-services.net/xmlns/rm/1.0/";
            this.catalogProperty = "rmServiceProviders";
        } else if (this.catalogDomain.equalsIgnoreCase("http://open-services.net/ns/am#")) {
            this.catalogNamespace = "http://open-services.net/ns/am#";
            this.catalogProperty = "amServiceProviders";
        } else if (this.catalogDomain.equalsIgnoreCase("http://open-services.net/ns/auto#")) {
            this.catalogNamespace = "http://open-services.net/ns/auto#";
            this.catalogProperty = "autoServiceProviders";
        } else if (this.catalogDomain.equalsIgnoreCase("http://open-services.net/ns/config#")) {
            this.catalogNamespace = "http://open-services.net/ns/config#";
            this.catalogProperty = "cmServiceProviders";
        } else {
            logger.error("Jazz rootservices only supports CM, RM, QM, GC and Automation catalogs");
        }
        this.processRootServices(client);
    }

    public String getCatalogUrl() {
        return this.catalogUrl;
    }

    private void processRootServices(OslcClient rootServicesClient) throws RootServicesException {
        try {
            Response response = rootServicesClient.getResource(this.rootServicesUrl, "application/rdf+xml");
            InputStream is = (InputStream)response.readEntity(InputStream.class);
            this.rdfModel = ModelFactory.createDefaultModel();
            this.rdfModel.read(is, this.rootServicesUrl);
            is.close();
            this.catalogUrl = this.getRootServicesProperty(this.rdfModel, this.catalogNamespace, this.catalogProperty);
            this.requestTokenUrl = this.getRootServicesProperty(this.rdfModel, JFS_NAMESPACE, "oauthRequestTokenUrl");
            this.authorizationTokenUrl = this.getRootServicesProperty(this.rdfModel, JFS_NAMESPACE, "oauthUserAuthorizationUrl");
            this.accessTokenUrl = this.getRootServicesProperty(this.rdfModel, JFS_NAMESPACE, "oauthAccessTokenUrl");
            try {
                this.authorizationRealm = this.getRootServicesProperty(this.rdfModel, JFS_NAMESPACE, "oauthRealmName");
            }
            catch (ResourceNotFoundException e) {
                logger.debug(String.format("OAuth authorization realm not found in rootservices <%s>", this.rootServicesUrl));
            }
            try {
                this.requestConsumerKeyUrl = this.getRootServicesProperty(this.rdfModel, JFS_NAMESPACE, "oauthRequestConsumerKeyUrl");
            }
            catch (ResourceNotFoundException e) {
                logger.debug(String.format("OAuth request consumer key URL not found in rootservices <%s>", this.rootServicesUrl));
            }
            try {
                this.consumerApprovalUrl = this.getRootServicesProperty(this.rdfModel, JFS_NAMESPACE, "oauthApprovalModuleUrl");
            }
            catch (ResourceNotFoundException e) {
                logger.debug(String.format("OAuth approval module URL not found in rootservices <%s>", this.rootServicesUrl));
            }
        }
        catch (Exception e) {
            throw new RootServicesException(this.baseUrl, e);
        }
    }

    private String getRootServicesProperty(Model rdfModel, String namespace, String predicate) throws ResourceNotFoundException {
        String returnVal = null;
        Property prop = rdfModel.createProperty(namespace, predicate);
        Statement stmt = rdfModel.getProperty((Resource)null, prop);
        if (stmt != null && stmt.getObject() != null) {
            returnVal = stmt.getObject().toString();
        }
        if (returnVal == null) {
            throw new ResourceNotFoundException(this.baseUrl, namespace + predicate);
        }
        return returnVal;
    }

    public Model getRdfModel() {
        return this.rdfModel;
    }

    public String getAuthorizationRealm() {
        return this.authorizationRealm;
    }

    public String getRequestTokenUrl() {
        return this.requestTokenUrl;
    }

    public String getAuthorizationTokenUrl() {
        return this.authorizationTokenUrl;
    }

    public String getAccessTokenUrl() {
        return this.accessTokenUrl;
    }

    public String getRequestConsumerKeyUrl() {
        return this.requestConsumerKeyUrl;
    }

    public String getConsumerApprovalUrl() {
        return this.consumerApprovalUrl;
    }

    public String getConsumerApprovalUrl(String consumerKey) {
        return UriBuilder.fromUri((String)this.consumerApprovalUrl).queryParam("key", new Object[]{consumerKey}).build(new Object[0]).toString();
    }

    public String requestConsumerKey(String consumerName, String consumerSecret) throws ClientProtocolException, IOException {
        String postData = "{\"trusted\":true, \"secretType\":\"string\", \"name\":\"" + consumerName + "\", \"secret\":\"" + consumerSecret + "\"}";
        HttpResponse response = null;
        StringEntity postDataEntity = new StringEntity(postData);
        CloseableHttpClient client = HttpClientBuilder.create().setRedirectStrategy((RedirectStrategy)new DefaultRedirectStrategy()).build();
        HttpPost request = new HttpPost(this.requestConsumerKeyUrl);
        request.addHeader("Content-Type", "application/json");
        request.addHeader("Accept", "application/json");
        request.setEntity((HttpEntity)postDataEntity);
        response = client.execute((HttpUriRequest)request);
        HttpEntity entity = response.getEntity();
        StatusLine statusLine = response.getStatusLine();
        if (statusLine.getStatusCode() > 399) {
            throw new IllegalStateException(String.format("Server reported an error: %s %s", statusLine.getStatusCode(), statusLine.getReasonPhrase()));
        }
        if (statusLine.getStatusCode() > 299) {
            String newLocation = response.getFirstHeader("Location").getValue();
            if (this.requestConsumerKeyUrl.equals(newLocation)) {
                throw new IllegalStateException("Redirect loop detected while trying to request consumer key");
            }
            this.requestConsumerKeyUrl = newLocation;
            logger.debug("Following the redirect for consumer key to {}", (Object)this.requestConsumerKeyUrl);
            return this.requestConsumerKey(consumerName, consumerSecret);
        }
        InputStream content = entity.getContent();
        if (!response.getFirstHeader("Content-Type").getValue().toLowerCase().contains("json")) {
            throw new IllegalStateException("Server returned something else than JSON in the response");
        }
        ObjectMapper mapper = new ObjectMapper();
        Map jsonData = new HashMap();
        jsonData = (Map)mapper.readValue(content, Map.class);
        String consumerKey = (String)jsonData.get("key");
        logger.debug("Consumer should redirect user to this approval URL, to approve the OAuth consumer: " + this.getConsumerApprovalUrl(consumerKey));
        return consumerKey;
    }
}

