/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb2.store;

import java.nio.file.Path;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.jena.atlas.lib.Cache;
import org.apache.jena.atlas.lib.CacheFactory;
import org.apache.jena.dboe.base.file.Location;
import org.apache.jena.dboe.storage.system.DatasetGraphTxnCtl;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.riot.system.PrefixMap;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.tdb2.store.GraphViewSwitchable;
import org.apache.jena.tdb2.store.PrefixMapSwitchable;

public final class DatasetGraphSwitchable
extends DatasetGraphTxnCtl {
    private final AtomicReference<DatasetGraph> dsgx = new AtomicReference();
    private final Path basePath;
    private final Location location;
    private final PrefixMapSwitchable prefixes;
    private Graph dftGraph = GraphViewSwitchable.createDefaultGraphSwitchable(this);
    private Cache<Node, Graph> ngCache = CacheFactory.createOneSlotCache();

    public DatasetGraphSwitchable(Path base, Location location, DatasetGraph dsg) {
        super(null, dsg.getContext());
        this.dsgx.set(dsg);
        this.basePath = base;
        this.location = location;
        this.prefixes = new PrefixMapSwitchable(this);
    }

    public DatasetGraph get() {
        return this.dsgx.get();
    }

    public boolean hasContainerPath() {
        return this.basePath != null;
    }

    public Path getContainerPath() {
        return this.basePath;
    }

    public Location getLocation() {
        return this.location;
    }

    public DatasetGraph set(DatasetGraph dsg) {
        return this.dsgx.getAndSet(dsg);
    }

    public PrefixMap prefixes() {
        return this.prefixes;
    }

    public void close() {
    }

    public boolean change(DatasetGraph oldDSG, DatasetGraph newDSG) {
        return this.dsgx.compareAndSet(oldDSG, newDSG);
    }

    public Graph getDefaultGraph() {
        return this.dftGraph;
    }

    public Graph getUnionGraph() {
        return GraphViewSwitchable.createUnionGraphSwitchable(this);
    }

    public Graph getGraph(Node gn) {
        Node key = gn != null ? gn : Quad.defaultGraphNodeGenerated;
        return (Graph)this.ngCache.getOrFill((Object)key, () -> GraphViewSwitchable.createNamedGraphSwitchable(this, key));
    }
}

