/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lyo.store;

import java.net.URI;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import org.eclipse.lyo.store.Store;
import org.eclipse.lyo.store.StoreFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorePool {
    private URI defaultNamedGraphUri;
    private BlockingQueue<Store> storePool;
    private static final Logger log = LoggerFactory.getLogger(StorePool.class);

    public StorePool(int poolSize, URI defaultNamedGraphUri, URI sparqlQueryEndpoint, URI sparqlUpdateEndpoint, String userName, String password) {
        this.defaultNamedGraphUri = defaultNamedGraphUri;
        this.storePool = new ArrayBlockingQueue<Store>(poolSize);
        for (int i = 0; i < poolSize; ++i) {
            Store s = null;
            s = userName != null && password != null ? StoreFactory.sparql(sparqlQueryEndpoint.toString(), sparqlUpdateEndpoint.toString(), userName, password) : StoreFactory.sparql(sparqlQueryEndpoint.toString(), sparqlUpdateEndpoint.toString());
            this.storePool.add(s);
        }
    }

    public URI getDefaultNamedGraphUri() {
        return this.defaultNamedGraphUri;
    }

    public Store getStore() {
        try {
            return this.storePool.take();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            log.error("Failed to get a store from the pool", (Throwable)e);
            return null;
        }
    }

    public void releaseStore(Store store) {
        try {
            this.storePool.put(store);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            log.error("Failed to get a store from the pool", (Throwable)e);
        }
    }
}

