/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb.sys;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.List;
import org.apache.jena.tdb.sys.SystemTDB;

public class ProcessUtils {
    private static int myPid = -1;

    public static int getPid(int fallback) {
        if (myPid != -1) {
            return myPid;
        }
        String runtimeBeanName = ManagementFactory.getRuntimeMXBean().getName();
        if (runtimeBeanName == null) {
            return ProcessUtils.useFallbackPid(fallback);
        }
        int index = runtimeBeanName.indexOf("@");
        if (index < 0) {
            return ProcessUtils.useFallbackPid(fallback);
        }
        try {
            String pidData = runtimeBeanName.substring(0, index);
            myPid = Integer.parseInt(pidData);
            return myPid;
        }
        catch (NumberFormatException e) {
            return ProcessUtils.useFallbackPid(fallback);
        }
    }

    private static int useFallbackPid(int fallback) {
        myPid = fallback;
        return myPid;
    }

    public static boolean isAlive(int pid) {
        String pidStr = Integer.toString(pid);
        try {
            List<String> data = ProcessUtils.getProcessInfo(pidStr);
            for (String lineData : data) {
                if (!lineData.contains(pidStr)) continue;
                return true;
            }
            return false;
        }
        catch (IOException e) {
            SystemTDB.errlog.warn("Your platform does not support checking process liveness so TDB disk locations cannot be reliably locked to prevent possible corruption due to unsafe multi-JVM usage", (Throwable)e);
            return true;
        }
    }

    public static boolean negativePidsTreatedAsAlive() {
        return ProcessUtils.isAlive(-1);
    }

    private static List<String> getProcessInfo(String pidStr) throws IOException {
        Process p;
        ProcessBuilder builder;
        if (SystemTDB.isWindows) {
            builder = new ProcessBuilder("tasklist", "/FI", "PID eq " + pidStr);
            builder.redirectErrorStream(true);
            p = builder.start();
        } else {
            builder = new ProcessBuilder("ps", "-p", pidStr);
            builder.redirectErrorStream(true);
            p = builder.start();
        }
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(p.getInputStream()));){
            ArrayList<String> data = new ArrayList<String>();
            String line = null;
            while ((line = reader.readLine()) != null) {
                data.add(line);
            }
            ArrayList<String> arrayList = data;
            return arrayList;
        }
    }
}

