/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb.setup;

import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.jena.query.ARQ;
import org.apache.jena.sparql.engine.main.OpExecutorFactory;
import org.apache.jena.sparql.engine.main.QC;
import org.apache.jena.sparql.engine.optimizer.reorder.ReorderLib;
import org.apache.jena.sparql.engine.optimizer.reorder.ReorderTransformation;
import org.apache.jena.sparql.sse.SSEParseException;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.tdb.TDB;
import org.apache.jena.tdb.TDBException;
import org.apache.jena.tdb.base.block.BlockMgr;
import org.apache.jena.tdb.base.file.BufferChannel;
import org.apache.jena.tdb.base.file.FileSet;
import org.apache.jena.tdb.base.file.Location;
import org.apache.jena.tdb.base.objectfile.ObjectFile;
import org.apache.jena.tdb.base.record.RecordFactory;
import org.apache.jena.tdb.index.BuilderStdIndex;
import org.apache.jena.tdb.index.Index;
import org.apache.jena.tdb.index.IndexParams;
import org.apache.jena.tdb.index.RangeIndex;
import org.apache.jena.tdb.index.bplustree.BPlusTree;
import org.apache.jena.tdb.index.bplustree.BPlusTreeParams;
import org.apache.jena.tdb.lib.ColumnMap;
import org.apache.jena.tdb.setup.BlockMgrBuilder;
import org.apache.jena.tdb.setup.Build;
import org.apache.jena.tdb.setup.BuilderStdDB;
import org.apache.jena.tdb.setup.ObjectFileBuilder;
import org.apache.jena.tdb.setup.StoreParams;
import org.apache.jena.tdb.setup.StoreParamsBuilder;
import org.apache.jena.tdb.setup.StoreParamsCodec;
import org.apache.jena.tdb.solver.OpExecutorTDB1;
import org.apache.jena.tdb.store.DatasetGraphTDB;
import org.apache.jena.tdb.store.DatasetPrefixesTDB;
import org.apache.jena.tdb.store.QuadTable;
import org.apache.jena.tdb.store.StorageConfig;
import org.apache.jena.tdb.store.TripleTable;
import org.apache.jena.tdb.store.nodetable.NodeTable;
import org.apache.jena.tdb.store.nodetable.NodeTableCache;
import org.apache.jena.tdb.store.nodetable.NodeTableInline;
import org.apache.jena.tdb.store.nodetable.NodeTableNative;
import org.apache.jena.tdb.store.nodetupletable.NodeTupleTableConcrete;
import org.apache.jena.tdb.store.tupletable.TupleIndex;
import org.apache.jena.tdb.store.tupletable.TupleIndexRecord;
import org.apache.jena.tdb.sys.DatasetControl;
import org.apache.jena.tdb.sys.DatasetControlMRSW;
import org.apache.jena.tdb.sys.FileRef;
import org.apache.jena.tdb.sys.SystemTDB;
import org.apache.jena.tdb.sys.TDBInternal;
import org.slf4j.Logger;

public class DatasetBuilderStd {
    private static final Logger log = TDB.logInfo;
    private BlockMgrBuilder blockMgrBuilder = new BuilderStdIndex.BlockMgrBuilderStd();
    private ObjectFileBuilder objectFileBuilder = new BuilderStdDB.ObjectFileBuilderStd();
    private Recorder recorder = new Recorder();
    private static String DB_CONFIG_FILE = "tdb.cfg";
    private static boolean warnAboutOptimizer = true;

    private void setupRecord() {
        if (this.blockMgrBuilder instanceof BlockMgrBuilderRecorder) {
            throw new TDBException("Already recording (BlockMgrBuilder)");
        }
        if (this.objectFileBuilder instanceof ObjectFileBuilderRecorder) {
            throw new TDBException("Already recording (ObjectFileBuilder)");
        }
        this.blockMgrBuilder = new BlockMgrBuilderRecorder(this.blockMgrBuilder, this.recorder);
        this.objectFileBuilder = new ObjectFileBuilderRecorder(this.objectFileBuilder, this.recorder);
    }

    private RangeIndex buildRangeIndex(FileSet fileSet, RecordFactory recordFactory, IndexParams indexParams) {
        int blkSize = indexParams.getBlockSize();
        int order = BPlusTreeParams.calcOrder(blkSize, recordFactory.recordLength());
        RangeIndex rIndex = this.createBPTree(fileSet, order, this.blockMgrBuilder, this.blockMgrBuilder, recordFactory, indexParams);
        return rIndex;
    }

    private Index buildIndex(FileSet fileSet, RecordFactory recordFactory, IndexParams indexParams) {
        return this.buildRangeIndex(fileSet, recordFactory, indexParams);
    }

    private RangeIndex createBPTree(FileSet fileset, int order, BlockMgrBuilder blockMgrBuilderNodes, BlockMgrBuilder blockMgrBuilderRecords, RecordFactory factory, IndexParams indexParams) {
        int order2;
        int blockSize = indexParams.getBlockSize();
        if (blockSize < 0) {
            throw new IllegalArgumentException("Negative blocksize: " + blockSize);
        }
        if (blockSize < 0 && order < 0) {
            throw new IllegalArgumentException("Neither blocksize nor order specified");
        }
        if (blockSize >= 0 && order < 0) {
            order = BPlusTreeParams.calcOrder(blockSize, factory.recordLength());
        }
        if (blockSize >= 0 && order >= 0 && order != (order2 = BPlusTreeParams.calcOrder(blockSize, factory.recordLength()))) {
            throw new IllegalArgumentException("Wrong order (" + order + "), calculated = " + order2);
        }
        BPlusTreeParams params = new BPlusTreeParams(order, factory);
        BlockMgr blkMgrNodes = blockMgrBuilderNodes.buildBlockMgr(fileset, "idn", indexParams);
        BlockMgr blkMgrRecords = blockMgrBuilderRecords.buildBlockMgr(fileset, "dat", indexParams);
        return BPlusTree.create(params, blkMgrNodes, blkMgrRecords);
    }

    public static DatasetGraphTDB create(Location location) {
        return DatasetBuilderStd.create(location, null);
    }

    public static DatasetGraphTDB create(Location location, StoreParams appParams) {
        StoreParams locParams = StoreParamsCodec.read(location);
        StoreParams dftParams = StoreParams.getDftStoreParams();
        boolean newArea = TDBInternal.isNewDatabaseArea(location);
        StoreParams params = Build.decideStoreParams(location, newArea, appParams, locParams, dftParams);
        DatasetBuilderStd x = new DatasetBuilderStd();
        DatasetGraphTDB dsg = x.build(location, params);
        return dsg;
    }

    public static DatasetGraphTDB create(StoreParams params) {
        return DatasetBuilderStd.create(Location.mem(), params);
    }

    public static DatasetBuilderStd stdBuilder() {
        return new DatasetBuilderStd();
    }

    protected DatasetBuilderStd() {
        this(new BuilderStdIndex.BlockMgrBuilderStd(), new BuilderStdDB.ObjectFileBuilderStd());
    }

    public DatasetBuilderStd(BlockMgrBuilder blockMgrBuilder, ObjectFileBuilder objectFileBuilder) {
        this.blockMgrBuilder = blockMgrBuilder;
        this.objectFileBuilder = objectFileBuilder;
        this.recorder = new Recorder();
        this.setupRecord();
    }

    private static void checkLocation(Location location) {
        if (location.isMem()) {
            return;
        }
        String dirname = location.getDirectoryPath();
        File dir = new File(dirname);
        if (!dir.exists()) {
            DatasetBuilderStd.error(log, "Does not exist: " + dirname);
        }
        if (!dir.isDirectory()) {
            DatasetBuilderStd.error(log, "Not a directory: " + dirname);
        }
        if (!dir.canRead()) {
            DatasetBuilderStd.error(log, "Directory not readable: " + dirname);
        }
        if (!dir.canWrite()) {
            DatasetBuilderStd.error(log, "Directory not writeable: " + dirname);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DatasetGraphTDB build(Location location, StoreParams params) {
        Class<DatasetBuilderStd> clazz = DatasetBuilderStd.class;
        synchronized (DatasetBuilderStd.class) {
            log.debug("Build database: " + location.getDirectoryPath());
            DatasetBuilderStd.checkLocation(location);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return this._build(location, params, true, null);
        }
    }

    public DatasetGraphTDB _build(Location location, StoreParams params, boolean writeable, ReorderTransformation _transform) {
        return this.buildWorker(location, writeable, _transform, params);
    }

    private synchronized DatasetGraphTDB buildWorker(Location location, boolean writeable, ReorderTransformation _transform, StoreParams params) {
        this.recorder.start();
        DatasetControl policy = this.createConcurrencyPolicy();
        NodeTable nodeTable = this.makeNodeTable(location, params);
        TripleTable tripleTable = this.makeTripleTable(location, nodeTable, policy, params);
        QuadTable quadTable = this.makeQuadTable(location, nodeTable, policy, params);
        DatasetPrefixesTDB prefixes = this.makePrefixTable(location, policy, params);
        ReorderTransformation transform = _transform == null ? this.chooseReorderTransformation(location) : _transform;
        StorageConfig storageConfig = new StorageConfig(location, params, writeable, this.recorder.blockMgrs, this.recorder.objectFiles, this.recorder.bufferChannels);
        this.recorder.finish();
        DatasetGraphTDB dsg = new DatasetGraphTDB(tripleTable, quadTable, prefixes, transform, storageConfig);
        dsg.getContext().set(ARQ.optFilterPlacementBGP, false);
        QC.setFactory((Context)dsg.getContext(), (OpExecutorFactory)OpExecutorTDB1.OpExecFactoryTDB);
        return dsg;
    }

    private static <X, Y> Map<X, Y> freeze(Map<X, Y> map) {
        return Collections.unmodifiableMap(new HashMap<X, Y>(map));
    }

    protected DatasetControl createConcurrencyPolicy() {
        return new DatasetControlMRSW();
    }

    protected TripleTable makeTripleTable(Location location, NodeTable nodeTable, DatasetControl policy, StoreParams params) {
        String primary = params.getPrimaryIndexTriples();
        CharSequence[] indexes = params.getTripleIndexes();
        log.debug("Triple table: " + primary + " :: " + String.join((CharSequence)",", indexes));
        TupleIndex[] tripleIndexes = this.makeTupleIndexes(location, primary, (String[])indexes, params);
        if (tripleIndexes.length != indexes.length) {
            DatasetBuilderStd.error(log, "Wrong number of triple table tuples indexes: " + tripleIndexes.length);
        }
        TripleTable tripleTable = new TripleTable(tripleIndexes, nodeTable, policy);
        return tripleTable;
    }

    protected QuadTable makeQuadTable(Location location, NodeTable nodeTable, DatasetControl policy, StoreParams params) {
        String primary = params.getPrimaryIndexQuads();
        CharSequence[] indexes = params.getQuadIndexes();
        log.debug("Quad table: " + primary + " :: " + String.join((CharSequence)",", indexes));
        TupleIndex[] quadIndexes = this.makeTupleIndexes(location, primary, (String[])indexes, params);
        if (quadIndexes.length != indexes.length) {
            DatasetBuilderStd.error(log, "Wrong number of quad table tuples indexes: " + quadIndexes.length);
        }
        QuadTable quadTable = new QuadTable(quadIndexes, nodeTable, policy);
        return quadTable;
    }

    protected DatasetPrefixesTDB makePrefixTable(Location location, DatasetControl policy, StoreParams params) {
        String primary = params.getPrimaryIndexPrefix();
        CharSequence[] indexes = params.getPrefixIndexes();
        TupleIndex[] prefixIndexes = this.makeTupleIndexes(location, primary, (String[])indexes, new String[]{params.getIndexPrefix()}, params);
        if (prefixIndexes.length != 1) {
            DatasetBuilderStd.error(log, "Wrong number of prefix table tuples indexes: " + prefixIndexes.length);
        }
        String pnNode2Id = params.getPrefixNode2Id();
        String pnId2Node = params.getPrefixId2Node();
        NodeTable prefixNodes = this.makeNodeTableNoCache(location, pnNode2Id, pnId2Node, params);
        NodeTupleTableConcrete prefixTable = new NodeTupleTableConcrete(primary.length(), prefixIndexes, prefixNodes, policy);
        DatasetPrefixesTDB prefixes = new DatasetPrefixesTDB(prefixTable);
        log.debug("Prefixes: " + primary + " :: " + String.join((CharSequence)",", indexes));
        return prefixes;
    }

    protected ReorderTransformation chooseReorderTransformation(Location location) {
        return DatasetBuilderStd.chooseOptimizer(location);
    }

    private TupleIndex[] makeTupleIndexes(Location location, String primary, String[] indexNames, StoreParams params) {
        return this.makeTupleIndexes(location, primary, indexNames, indexNames, params);
    }

    private TupleIndex[] makeTupleIndexes(Location location, String primary, String[] indexNames, String[] filenames, StoreParams params) {
        if (primary.length() != 3 && primary.length() != 4) {
            DatasetBuilderStd.error(log, "Bad primary key length: " + primary.length());
        }
        int indexRecordLen = primary.length() * 8;
        TupleIndex[] indexes = new TupleIndex[indexNames.length];
        for (int i = 0; i < indexes.length; ++i) {
            indexes[i] = this.makeTupleIndex(location, filenames[i], primary, indexNames[i], params);
        }
        return indexes;
    }

    protected TupleIndex makeTupleIndex(Location location, String name, String primary, String indexOrder, StoreParams params) {
        FileSet fs = new FileSet(location, name);
        ColumnMap colMap = new ColumnMap(primary, indexOrder);
        return this.buildTupleIndex(fs, colMap, indexOrder, params);
    }

    private TupleIndex buildTupleIndex(FileSet fileSet, ColumnMap colMap, String name, StoreParams params) {
        RecordFactory recordFactory = new RecordFactory(8 * colMap.length(), 0);
        RangeIndex rIdx = this.buildRangeIndex(fileSet, recordFactory, params);
        TupleIndexRecord tIdx = new TupleIndexRecord(colMap.length(), colMap, name, recordFactory, rIdx);
        return tIdx;
    }

    public NodeTable makeNodeTable(Location location, StoreParams params) {
        return this.makeNodeTable$(location, params.getIndexNode2Id(), params.getIndexId2Node(), params);
    }

    private NodeTable makeNodeTable$(Location location, String indexNode2Id, String indexId2Node, StoreParams params) {
        FileSet fsNodeToId = new FileSet(location, indexNode2Id);
        FileSet fsId2Node = new FileSet(location, indexId2Node);
        NodeTable nt = this.buildNodeTable(fsNodeToId, fsId2Node, params);
        return nt;
    }

    private NodeTable buildNodeTable(FileSet fsIndex, FileSet fsObjectFile, StoreParams params) {
        RecordFactory recordFactory = new RecordFactory(16, 8);
        Index idx = this.buildIndex(fsIndex, recordFactory, params);
        ObjectFile objectFile = this.objectFileBuilder.buildObjectFile(fsObjectFile, "dat");
        NodeTable nodeTable = new NodeTableNative(idx, objectFile);
        nodeTable = NodeTableCache.create(nodeTable, params.getNode2NodeIdCacheSize(), params.getNodeId2NodeCacheSize(), params.getNodeMissCacheSize());
        nodeTable = NodeTableInline.create(nodeTable);
        return nodeTable;
    }

    protected NodeTable makeNodeTableNoCache(Location location, String indexNode2Id, String indexId2Node, StoreParams params) {
        StoreParamsBuilder spb = StoreParams.builder(params).node2NodeIdCacheSize(-1).nodeId2NodeCacheSize(-1).nodeMissCacheSize(-1);
        return this.makeNodeTable$(location, indexNode2Id, indexId2Node, spb.build());
    }

    private static void error(Logger log, String msg) {
        if (log != null) {
            log.error(msg);
        }
        throw new TDBException(msg);
    }

    private static int parseInt(String str, String messageBase) {
        try {
            return Integer.parseInt(str);
        }
        catch (NumberFormatException ex) {
            DatasetBuilderStd.error(log, messageBase + ": " + str);
            return -1;
        }
    }

    public static void setOptimizerWarningFlag(boolean b) {
        warnAboutOptimizer = b;
    }

    public static ReorderTransformation chooseOptimizer(Location location) {
        if (location == null) {
            return ReorderLib.identity();
        }
        ReorderTransformation reorder = null;
        if (location.exists("stats.opt")) {
            try {
                reorder = ReorderLib.weighted((String)location.getPath("stats.opt"));
                log.debug("Statistics-based BGP optimizer");
            }
            catch (SSEParseException ex) {
                log.warn("Error in stats file: " + ex.getMessage());
                reorder = null;
            }
        }
        if (reorder == null && location.exists("fixed.opt")) {
            reorder = ReorderLib.fixed();
            log.debug("Fixed pattern BGP optimizer");
        }
        if (location.exists("none.opt")) {
            reorder = ReorderLib.identity();
            log.debug("Optimizer explicitly turned off");
        }
        if (reorder == null) {
            reorder = SystemTDB.defaultReorderTransform;
        }
        if (reorder == null && warnAboutOptimizer) {
            ARQ.getExecLogger().warn("No BGP optimizer");
        }
        return reorder;
    }

    static class Recorder
    implements RecordBlockMgr,
    RecordObjectFile,
    RecordNodeTable {
        Map<FileRef, BlockMgr> blockMgrs = null;
        Map<FileRef, ObjectFile> objectFiles = null;
        Map<FileRef, BufferChannel> bufferChannels = null;
        Map<FileRef, NodeTable> nodeTables = null;
        boolean recording = false;

        Recorder() {
        }

        void start() {
            if (this.recording) {
                throw new TDBException("Recorder already recording");
            }
            this.recording = true;
            this.blockMgrs = new HashMap<FileRef, BlockMgr>();
            this.objectFiles = new HashMap<FileRef, ObjectFile>();
            this.bufferChannels = new HashMap<FileRef, BufferChannel>();
            this.nodeTables = new HashMap<FileRef, NodeTable>();
        }

        void finish() {
            if (!this.recording) {
                throw new TDBException("Recorder not recording");
            }
            this.blockMgrs = null;
            this.objectFiles = null;
            this.bufferChannels = null;
            this.recording = false;
        }

        @Override
        public void record(FileRef fileRef, BlockMgr blockMgr) {
            if (this.recording) {
                this.blockMgrs.put(fileRef, blockMgr);
            }
        }

        @Override
        public void record(FileRef fileRef, ObjectFile objFile) {
            if (this.recording) {
                this.objectFiles.put(fileRef, objFile);
            }
        }

        @Override
        public void record(FileRef fileRef, NodeTable nodeTable) {
            if (this.recording) {
                this.nodeTables.put(fileRef, nodeTable);
            }
        }
    }

    static class BlockMgrBuilderRecorder
    implements BlockMgrBuilder {
        private final BlockMgrBuilder builder;
        private final RecordBlockMgr recorder;

        BlockMgrBuilderRecorder(BlockMgrBuilder blkMgrBuilder, RecordBlockMgr recorder) {
            this.builder = blkMgrBuilder;
            this.recorder = recorder;
        }

        @Override
        public BlockMgr buildBlockMgr(FileSet fileSet, String ext, IndexParams params) {
            BlockMgr blkMgr = this.builder.buildBlockMgr(fileSet, ext, params);
            FileRef ref = FileRef.create(fileSet, ext);
            this.recorder.record(ref, blkMgr);
            return blkMgr;
        }
    }

    static class ObjectFileBuilderRecorder
    implements ObjectFileBuilder {
        private final ObjectFileBuilder builder;
        private final RecordObjectFile recorder;

        ObjectFileBuilderRecorder(ObjectFileBuilder objFileBuilder, RecordObjectFile recorder) {
            this.builder = objFileBuilder;
            this.recorder = recorder;
        }

        @Override
        public ObjectFile buildObjectFile(FileSet fsObjectFile, String ext) {
            ObjectFile objectFile = this.builder.buildObjectFile(fsObjectFile, ext);
            FileRef ref = FileRef.create(fsObjectFile, ext);
            this.recorder.record(ref, objectFile);
            return objectFile;
        }
    }

    static interface RecordNodeTable {
        public void record(FileRef var1, NodeTable var2);
    }

    static interface RecordObjectFile {
        public void record(FileRef var1, ObjectFile var2);
    }

    static interface RecordBlockMgr {
        public void record(FileRef var1, BlockMgr var2);
    }
}

