/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lyo.core.util;

import java.text.Normalizer;
import java.util.regex.Pattern;

public class StringUtils {
    private static final Pattern CONTROL_CHAR_PATTERN = Pattern.compile("^\\p{Cc}&&[^\\r\\n\\t]+$");

    public static String cleanWithoutNormalization(String str) {
        if (str == null) {
            return null;
        }
        return CONTROL_CHAR_PATTERN.matcher(str).replaceAll("").trim();
    }

    public static String cleanWithoutNormalizationNonNull(String str) {
        if (str == null) {
            return "";
        }
        return CONTROL_CHAR_PATTERN.matcher(str).replaceAll("").trim();
    }

    public static String clean(String str) {
        if (str == null) {
            return null;
        }
        return Normalizer.normalize(CONTROL_CHAR_PATTERN.matcher(str).replaceAll("").trim(), Normalizer.Form.NFC);
    }

    public static String cleanNonNull(String str) {
        if (str == null) {
            return "";
        }
        return Normalizer.normalize(CONTROL_CHAR_PATTERN.matcher(str).replaceAll("").trim(), Normalizer.Form.NFC);
    }

    public static boolean isNullOrWhitespace(String str) {
        return str == null || str.isBlank();
    }

    public static boolean isNullOrEmpty(String str) {
        return str == null || str.isEmpty();
    }
}

