/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.test.documentLink;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.operations.documentLink.DocumentLinkDetector;
import org.eclipse.lsp4e.test.utils.AbstractTestWithProject;
import org.eclipse.lsp4e.test.utils.TestUtils;
import org.eclipse.lsp4e.tests.mock.MockLanguageServer;
import org.eclipse.lsp4e.ui.UI;
import org.eclipse.lsp4j.DocumentLink;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.texteditor.ITextEditor;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DocumentLinkTest
extends AbstractTestWithProject {
    private final DocumentLinkDetector documentLinkDetector = new DocumentLinkDetector();

    @Test
    public void testDocumentLinkNoResults() throws Exception {
        IFile file = TestUtils.createUniqueTestFile(this.project, "Example Text");
        ITextViewer viewer = TestUtils.openTextViewer(file);
        Object[] hyperlinks = this.documentLinkDetector.detectHyperlinks(viewer, (IRegion)new Region(0, 0), true);
        Assertions.assertArrayEquals(null, (Object[])hyperlinks);
    }

    @Test
    public void testDocumentLink() throws Exception {
        ArrayList<DocumentLink> links = new ArrayList<DocumentLink>();
        links.add(new DocumentLink(new Range(new Position(0, 9), new Position(0, 15)), "file://test0"));
        MockLanguageServer.INSTANCE.setDocumentLinks(links);
        IFile file = TestUtils.createUniqueTestFile(this.project, "not_link <link>");
        ITextViewer viewer = TestUtils.openTextViewer(file);
        IHyperlink[] hyperlinks = this.documentLinkDetector.detectHyperlinks(viewer, (IRegion)new Region(13, 0), true);
        Assertions.assertEquals((int)1, (int)hyperlinks.length);
        Assertions.assertEquals((Object)"file://test0", (Object)hyperlinks[0].getHyperlinkText());
    }

    @Test
    public void testDocumentLinkExternalFile() throws Exception {
        ArrayList<DocumentLink> links = new ArrayList<DocumentLink>();
        links.add(new DocumentLink(new Range(new Position(0, 9), new Position(0, 15)), "file://test0"));
        MockLanguageServer.INSTANCE.setDocumentLinks(links);
        File file = TestUtils.createTempFile("testDocumentLinkExternalFile", ".lspt");
        ITextEditor editor = (ITextEditor)IDE.openInternalEditorOnFileStore((IWorkbenchPage)UI.getActivePage(), (IFileStore)EFS.getStore((URI)file.toURI()));
        ITextViewer viewer = LSPEclipseUtils.getTextViewer((IEditorPart)editor);
        viewer.getDocument().set("Long enough dummy content to match ranges");
        IHyperlink[] hyperlinks = this.documentLinkDetector.detectHyperlinks(viewer, (IRegion)new Region(13, 0), true);
        Assertions.assertEquals((int)1, (int)hyperlinks.length);
        Assertions.assertEquals((Object)"file://test0", (Object)hyperlinks[0].getHyperlinkText());
    }

    @Test
    public void testDocumentLinkWithEncodedUri() throws Exception {
        ArrayList<DocumentLink> links = new ArrayList<DocumentLink>();
        links.add(new DocumentLink(new Range(new Position(0, 9), new Position(0, 15)), "file:///tmp/fi%C3%A9le.ts"));
        MockLanguageServer.INSTANCE.setDocumentLinks(links);
        IFile file = TestUtils.createUniqueTestFile(this.project, "not_link <link>");
        ITextViewer viewer = TestUtils.openTextViewer(file);
        IHyperlink[] hyperlinks = this.documentLinkDetector.detectHyperlinks(viewer, (IRegion)new Region(13, 0), true);
        Assertions.assertEquals((int)1, (int)hyperlinks.length);
        Assertions.assertEquals((Object)"/tmp/fi\u00e9le.ts", (Object)hyperlinks[0].getHyperlinkText());
    }

    @Test
    public void testDocumentLinkWrongRegion() throws Exception {
        ArrayList<DocumentLink> links = new ArrayList<DocumentLink>();
        links.add(new DocumentLink(new Range(new Position(0, 9), new Position(0, 15)), "file://test0"));
        MockLanguageServer.INSTANCE.setDocumentLinks(links);
        IFile file = TestUtils.createUniqueTestFile(this.project, "not_link <link>");
        ITextViewer viewer = TestUtils.openTextViewer(file);
        Object[] hyperlinks = this.documentLinkDetector.detectHyperlinks(viewer, (IRegion)new Region(0, 0), true);
        Assertions.assertArrayEquals(null, (Object[])hyperlinks);
    }
}

