/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e;

import java.util.Collections;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.core.filebuffers.IDocumentSetupParticipant;
import org.eclipse.core.filebuffers.IDocumentSetupParticipantExtension;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.text.IDocument;
import org.eclipse.lsp4e.LanguageServerPlugin;
import org.eclipse.lsp4e.LanguageServers;

public class ConnectDocumentToLanguageServerSetupParticipant
implements IDocumentSetupParticipant,
IDocumentSetupParticipantExtension {
    private static final Set<CompletableFuture<?>> PENDING_CONNECTIONS = Collections.synchronizedSet(Collections.newSetFromMap(new WeakHashMap()));

    public void setup(IDocument document) {
        ITextFileBuffer buffer = ITextFileBufferManager.DEFAULT.getTextFileBuffer(document);
        if (buffer == null || buffer.getLocation() == null) {
            return;
        }
        this.setup(document, buffer.getLocation(), LocationKind.IFILE);
    }

    public void setup(IDocument document, IPath location, LocationKind locationKind) {
        CompletableFuture.runAsync(() -> {
            boolean bl = PENDING_CONNECTIONS.add(LanguageServers.forDocument(document).collectAll(ls -> CompletableFuture.completedFuture(null)));
        }, CompletableFuture.delayedExecutor(1L, TimeUnit.SECONDS));
    }

    public static void waitForAll() {
        PENDING_CONNECTIONS.forEach(cf -> {
            try {
                cf.get(1000L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                LanguageServerPlugin.logInfo("Interrupted trying to cancel document setup");
            }
        });
    }
}

