/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.gprof.view;

import java.util.LinkedList;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.linuxtools.internal.gprof.parser.GmonDecoder;
import org.eclipse.linuxtools.internal.gprof.view.histogram.CGCategory;
import org.eclipse.linuxtools.internal.gprof.view.histogram.HistFunction;
import org.eclipse.linuxtools.internal.gprof.view.histogram.HistRoot;
import org.eclipse.linuxtools.internal.gprof.view.histogram.TreeElement;

public class CallGraphContentProvider
implements ITreeContentProvider {
    public static final CallGraphContentProvider sharedInstance = new CallGraphContentProvider();

    private CallGraphContentProvider() {
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof HistRoot) {
            HistRoot root = (HistRoot)parentElement;
            LinkedList<? extends TreeElement> ret = this.getFunctionChildrenList(root);
            return ret.toArray();
        }
        if (parentElement instanceof HistFunction) {
            HistFunction function = (HistFunction)parentElement;
            CGCategory parents = function.getParentsFunctions();
            CGCategory children = function.getChildrenFunctions();
            if (parents == null) {
                if (children == null) {
                    return new Object[0];
                }
                return new Object[]{children};
            }
            if (children == null) {
                return new Object[]{parents};
            }
            return new Object[]{parents, children};
        }
        if (parentElement instanceof CGCategory) {
            CGCategory cat = (CGCategory)parentElement;
            return cat.getChildren().toArray();
        }
        return null;
    }

    protected LinkedList<? extends TreeElement> getFunctionChildrenList(HistRoot root) {
        LinkedList<? extends TreeElement> ret = new LinkedList<TreeElement>();
        LinkedList<? extends TreeElement> list = root.getChildren();
        for (TreeElement treeElement : list) {
            LinkedList<? extends TreeElement> partialList = treeElement.getChildren();
            ret.addAll(partialList);
        }
        return ret;
    }

    public TreeElement getParent(Object element) {
        if (element instanceof TreeElement) {
            TreeElement cge = (TreeElement)element;
            if (cge instanceof HistFunction) {
                return cge.getParent().getParent();
            }
            return cge.getParent();
        }
        return null;
    }

    public boolean hasChildren(Object parentElement) {
        if (parentElement instanceof HistRoot) {
            HistRoot root = (HistRoot)parentElement;
            LinkedList<? extends TreeElement> ret = this.getFunctionChildrenList(root);
            return !ret.isEmpty();
        }
        if (parentElement instanceof HistFunction) {
            HistFunction function = (HistFunction)parentElement;
            CGCategory parents = function.getParentsFunctions();
            CGCategory children = function.getChildrenFunctions();
            return parents != null || children != null;
        }
        if (parentElement instanceof CGCategory) {
            CGCategory cat = (CGCategory)parentElement;
            return !cat.getChildren().isEmpty();
        }
        return false;
    }

    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof GmonDecoder) {
            GmonDecoder obj = (GmonDecoder)inputElement;
            HistRoot root = obj.getRootNode();
            return new Object[]{root};
        }
        return new Object[0];
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }
}

