/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.mtoolkit.iagent.internal;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.SocketException;
import java.util.Arrays;
import org.osgi.framework.BundleContext;
import org.tigris.mtoolkit.iagent.internal.mbsa.DataFormater;
import org.tigris.mtoolkit.iagent.internal.utils.DebugUtils;
import org.tigris.mtoolkit.iagent.mbsa.MBSAException;
import org.tigris.mtoolkit.iagent.mbsa.MBSARequest;
import org.tigris.mtoolkit.iagent.mbsa.MBSARequestHandler;
import org.tigris.mtoolkit.iagent.mbsa.MBSAResponse;
import org.tigris.mtoolkit.iagent.mbsa.MBSAServer;
import org.tigris.mtoolkit.iagent.mbsa.MBSASessionFactory;
import org.tigris.mtoolkit.iagent.pmp.PMPServer;

public class VMCommander {
    private static final int VM_CONTROLLER_PORT = 7366;
    private static final int UDP_LISTENER_PORT = 7367;
    private static final int IAGENT_CMD_STOPVM = 131074;
    private static final int IAGENT_CMD_GET_PMP_LISTENING_PORT = 131086;
    private static final byte[] UDP_NOTIFICATION = new byte[]{68, 72, 84, 88};
    private static final String PROP_VM_CONTROLLER_PORT = "vm.controller.port";
    private static final String SERVER_PROP_PORT = "port";
    private MBSAServer vmServer;
    private BundleContext bc;
    private UDPListener udpListener;
    private PMPServer pmpServer;
    private boolean shutdownOnDisconnect;

    public VMCommander(BundleContext bc, PMPServer pmpServer, boolean shutdownOnDisconnect) {
        this.bc = bc;
        this.pmpServer = pmpServer;
        this.shutdownOnDisconnect = shutdownOnDisconnect;
        this.startUDPListener();
        this.startServer();
    }

    public void close() {
        this.stopServer();
        if (this.udpListener != null) {
            this.udpListener.dispose();
        }
    }

    private synchronized void startServer() {
        block3: {
            if (this.vmServer != null && !this.vmServer.isClosed()) {
                return;
            }
            try {
                this.vmServer = MBSASessionFactory.serverConnect(null, this.getControllerPort(), new VMRequestHandler());
            }
            catch (MBSAException e) {
                this.info("[startServer] cannot connect to controller.", e);
                if (!this.shutdownOnDisconnect || e.getCode() != 306) break block3;
                this.info("[startServer] Shutting down because no connection with the controller can be established.");
                this.stopVM();
            }
        }
    }

    private synchronized void stopServer() {
        if (this.vmServer != null) {
            this.shutdownOnDisconnect = false;
            this.vmServer.close();
            this.vmServer = null;
        }
    }

    private int getControllerPort() {
        int port = 7366;
        String portStr = System.getProperty(PROP_VM_CONTROLLER_PORT);
        this.debug("[getControllerPort] vm.controller.port = " + portStr);
        if (portStr != null) {
            try {
                port = Integer.parseInt(portStr);
            }
            catch (NumberFormatException e) {
                this.info("[getControllerPort] Incorrect value of property: vm.controller.port: " + portStr, e);
            }
        }
        return port;
    }

    private void startUDPListener() {
        this.udpListener = new UDPListener();
        this.udpListener.setName("UDPListener Thread");
        this.udpListener.start();
    }

    private boolean stopVM() {
        this.debug("[stopVM] stopVM command received.");
        try {
            this.bc.getBundle(0L).stop();
        }
        catch (Exception e) {
            this.error("[stopVM] Cannot stop VM.", e);
            return false;
        }
        return true;
    }

    private int getPmpListeningPort() {
        this.debug("[getPmpListeningPort] getPmpListeningPort command received.");
        if (this.pmpServer == null) {
            return 0;
        }
        Object port = this.pmpServer.getProperties().get(SERVER_PROP_PORT);
        this.debug("[getPmpListeningPort] port = " + port);
        if (port == null) {
            return 0;
        }
        if (port instanceof Integer) {
            return (Integer)port;
        }
        try {
            return Integer.parseInt(port.toString());
        }
        catch (NumberFormatException e) {
            this.error("[getPmpListeningPort] unrecognized port value: " + port, e);
            return 0;
        }
    }

    private final void debug(String message) {
        DebugUtils.debug(this, message);
    }

    private final void info(String message) {
        DebugUtils.info(this, message);
    }

    private final void info(String message, Throwable t) {
        DebugUtils.info(this, message, t);
    }

    private final void error(String message, Throwable t) {
        DebugUtils.error(this, message, t);
    }

    static /* synthetic */ byte[] access$0() {
        return UDP_NOTIFICATION;
    }

    static /* synthetic */ void access$1(VMCommander vMCommander, String string, Throwable throwable) {
        vMCommander.error(string, throwable);
    }

    static /* synthetic */ void access$2(VMCommander vMCommander) {
        vMCommander.startServer();
    }

    static /* synthetic */ void access$3(VMCommander vMCommander, String string) {
        vMCommander.info(string);
    }

    private class UDPListener
    extends Thread {
        private volatile boolean listenerRunning;

        public UDPListener() {
            super("IAgent UDP Listener");
        }

        public void start() {
            this.listenerRunning = true;
            super.start();
        }

        public void dispose() {
            this.listenerRunning = false;
            this.interrupt();
        }

        /*
         * Unable to fully structure code
         */
        public void run() {
            socket = null;
            buffer = new byte[VMCommander.access$0().length];
            packet = new DatagramPacket(buffer, buffer.length);
            try {
                socket = new DatagramSocket(7367);
                if (true) ** GOTO lbl19
            }
            catch (SocketException se) {
                VMCommander.access$1(VMCommander.this, "[startUDPListener] Cannot open socket for UDP notifications.", se);
                return;
            }
            do {
                try {
                    socket.receive(packet);
                    if (Arrays.equals(buffer, VMCommander.access$0())) {
                        VMCommander.access$2(VMCommander.this);
                        continue;
                    }
                    VMCommander.access$3(VMCommander.this, "[UDPListener] Unknown UDP notification received.");
                }
                catch (IOException v0) {}
lbl19:
                // 4 sources

            } while (this.listenerRunning);
        }
    }

    private class VMRequestHandler
    implements MBSARequestHandler {
        private VMRequestHandler() {
        }

        public MBSAResponse handleRequest(MBSARequest msg) {
            MBSAResponse response = null;
            switch (msg.getCommand()) {
                case 131074: {
                    boolean res = VMCommander.this.stopVM();
                    response = msg.respond(res ? 0 : -1);
                    response.done();
                    break;
                }
                case 131086: {
                    int port = VMCommander.this.getPmpListeningPort();
                    ByteArrayOutputStream bos = new ByteArrayOutputStream();
                    try {
                        DataFormater.writeInt(bos, port);
                    }
                    catch (IOException iOException) {}
                    response = msg.respond(0, bos.toByteArray());
                    response.done();
                    break;
                }
                default: {
                    response = msg.respond(131071);
                    response.done();
                }
            }
            return response;
        }

        public void disconnected(MBSAServer server) {
            if (VMCommander.this.shutdownOnDisconnect) {
                VMCommander.this.debug("[disconnected] MBSA Server got disconnected, shutdown the framework");
                VMCommander.this.stopVM();
            }
        }
    }
}

