/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.internal.rest.auth;

import java.security.Principal;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Priority;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.core.PathSegment;
import org.eclipse.kura.audit.AuditConstants;
import org.eclipse.kura.audit.AuditContext;
import org.eclipse.kura.internal.rest.auth.RestSessionHelper;
import org.eclipse.kura.internal.rest.provider.RestServiceOptions;
import org.eclipse.kura.rest.auth.AuthenticationProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Priority(value=300)
public class SessionAuthProvider
implements AuthenticationProvider {
    private static final Logger auditLogger = LoggerFactory.getLogger((String)"AuditLogger");
    private final RestSessionHelper sessionHelper;
    private RestServiceOptions restServiceOptions;
    private final Set<String> lockedSessionAllowedPaths;
    private final Set<String> allowNoXsrfTokenPaths;

    public SessionAuthProvider(RestSessionHelper sessionHelper, Set<String> allowSessionLocked, Set<String> allowNoXsrfToken) {
        this.sessionHelper = sessionHelper;
        this.lockedSessionAllowedPaths = allowSessionLocked;
        this.allowNoXsrfTokenPaths = allowNoXsrfToken;
    }

    @Override
    public void onEnabled() {
    }

    @Override
    public void onDisabled() {
    }

    public void setOptions(RestServiceOptions restServiceOptions) {
        this.restServiceOptions = restServiceOptions;
    }

    @Override
    public Optional<Principal> authenticate(HttpServletRequest request, ContainerRequestContext requestContext) {
        AuditContext auditContext = AuditContext.currentOrInternal();
        Optional<HttpSession> session = this.sessionHelper.getExistingSession(request);
        if (!session.isPresent()) {
            return Optional.empty();
        }
        auditContext.getProperties().put("session.id", session.get().getId());
        Optional<Principal> result = this.sessionHelper.getPrincipalFromSession(session.get());
        if (!result.isPresent()) {
            return Optional.empty();
        }
        auditContext.getProperties().put(AuditConstants.KEY_IDENTITY.getValue(), result.get().getName());
        if (!this.isXsrfTokenValid(request, requestContext)) {
            auditLogger.warn("{} Rest - Failure - Session authentication failed, invalid XSRF token", (Object)auditContext);
            return Optional.empty();
        }
        if (this.sessionHelper.isSessionExpired(session.get(), this.restServiceOptions.getSessionInactivityInterval())) {
            auditLogger.warn("{} Rest - Failure - Session authentication failed, session expired", (Object)auditContext);
            session.get().invalidate();
            return Optional.empty();
        }
        if (this.isSessionLocked(session.get(), requestContext)) {
            auditLogger.warn("{} Rest - Failure - Session authentication failed, session is locked", (Object)auditContext);
            return Optional.empty();
        }
        if (this.sessionHelper.credentialsChanged(session.get(), result.get().getName())) {
            auditLogger.warn("{} Rest - Failure - Session authentication failed, user credentials changed", (Object)auditContext);
            session.get().invalidate();
            return Optional.empty();
        }
        this.sessionHelper.updateLastActivity(session.get());
        auditLogger.info("{} Rest - Success - Authentication succeeded via session provider", (Object)auditContext);
        return result;
    }

    private boolean isSessionLocked(HttpSession session, ContainerRequestContext requestContext) {
        if (this.containsPath(this.lockedSessionAllowedPaths, requestContext)) {
            return false;
        }
        return this.sessionHelper.isSessionLocked(session);
    }

    private boolean isXsrfTokenValid(HttpServletRequest request, ContainerRequestContext context) {
        if (this.containsPath(this.allowNoXsrfTokenPaths, context)) {
            return true;
        }
        return this.sessionHelper.isXsrfTokenValid(request);
    }

    private boolean containsPath(Set<String> paths, ContainerRequestContext requestContext) {
        String reuqestPath = String.valueOf('/') + requestContext.getUriInfo().getPathSegments().stream().map(PathSegment::getPath).collect(Collectors.joining("/"));
        return paths.contains(reuqestPath);
    }
}

