/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.composer.ui.wizards;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.polarsys.kitalpha.cadence.core.api.parameter.ActivityParameters;
import org.polarsys.kitalpha.cadence.core.api.parameter.GenericParameter;
import org.polarsys.kitalpha.cadence.core.api.parameter.WorkflowActivityParameter;
import org.polarsys.kitalpha.composer.api.CodeManagerCadenceLaunchConfiguration;
import org.polarsys.kitalpha.composer.api.configuration.CodeManagerConfiguration;
import org.polarsys.kitalpha.composer.api.profiles.ComposerProfile;
import org.polarsys.kitalpha.composer.extension.points.CodeManagerExtensions;
import org.polarsys.kitalpha.composer.ui.Activator;
import org.polarsys.kitalpha.composer.ui.launch.tabs.ComposerHelper;
import org.polarsys.kitalpha.composer.ui.wizards.CadenceConfigurationWizardPage;
import org.polarsys.kitalpha.composer.ui.wizards.GenericConfigurationWizardPage;

public class GenericLaunchConfigurationWizard
extends Wizard {
    private static final String ID_COMPOSER_LAUNCH_CONFIG = "org.polarsys.kitalpha.code.generation.manager.ui.launch.CodeManagerConfigurationType";
    public static final String PARAMETER_SEPARATOR = ":";
    private CodeManagerConfiguration configuration;
    private ComposerProfile profile;
    private GenericConfigurationWizardPage wizardPage;

    public GenericLaunchConfigurationWizard(CodeManagerConfiguration configuration) {
        this.configuration = configuration;
    }

    public GenericLaunchConfigurationWizard(CodeManagerConfiguration configuration, ComposerProfile profile) {
        this.configuration = configuration;
        this.profile = profile;
    }

    public void addPages() {
        super.addPages();
        this.wizardPage = new GenericConfigurationWizardPage("Generation configuration", "Generation configuration", null);
        this.wizardPage.setConfiguration(this.configuration);
        this.addPage((IWizardPage)this.wizardPage);
        if (this.configuration.getCodeManagerCadenceLaunchConfiguration().containsActivities()) {
            this.wizardPage = new CadenceConfigurationWizardPage("Cadence configuration", "Cadence configuration", null);
            this.wizardPage.setConfiguration(this.configuration);
            this.addPage((IWizardPage)this.wizardPage);
        }
    }

    public boolean performFinish() {
        try {
            ILaunchConfiguration workingCopy = this.createLaunchConfiguration(GenericConfigurationWizardPage.getConfigNameName());
            this.convertCodeManagerLaunchConfiguration((ILaunchConfigurationWorkingCopy)workingCopy, this.configuration);
        }
        catch (Exception e) {
            Status status = new Status(4, "org.polarsys.kitalpha.composer.ui", "Error while creating launch configuration", e.fillInStackTrace());
            Activator.getDefault().getLog().log((IStatus)status);
        }
        return true;
    }

    private void convertCodeManagerLaunchConfiguration(ILaunchConfigurationWorkingCopy workingCopy, CodeManagerConfiguration configuration_p) throws CoreException {
        String id = this.profile.getAllocationBindingId();
        String nsUri = this.profile.getAllocationBinding();
        workingCopy.setAttribute("allocation_uri", nsUri);
        IConfigurationElement element = CodeManagerExtensions.getBindingConfigElementFromId((String)id);
        String name = element.getAttribute("Name");
        workingCopy.setAttribute("generation_name", name);
        id = this.profile.getStrategy().getId();
        element = CodeManagerExtensions.getStrategyConfigElementFromId((String)id);
        name = element.getAttribute("Name");
        workingCopy.setAttribute("strategie_id", id);
        workingCopy.setAttribute("strategie_name", name);
        Map<String, String> map = ComposerHelper.getMapFromTable(configuration_p.getStrategyParameters().values());
        workingCopy.setAttribute("strategie_parameters", map);
        id = this.profile.getRefinery().getId();
        element = CodeManagerExtensions.getRefineryConfigElementFromId((String)id);
        name = element.getAttribute("Name");
        workingCopy.setAttribute("refinery_id", id);
        workingCopy.setAttribute("refinery_name", name);
        map = ComposerHelper.getMapFromTable(configuration_p.getRefineryParameters().values());
        workingCopy.setAttribute("refinery_parameters", map);
        id = this.profile.getGenerator().getId();
        element = CodeManagerExtensions.getGeneratorConfigElementFromId((String)id);
        name = element.getAttribute("Name");
        workingCopy.setAttribute("generator_id", id);
        workingCopy.setAttribute("generator_name", name);
        workingCopy.setAttribute("generation_folder", configuration_p.getDestinationFolder().toString());
        map = ComposerHelper.getMapFromTable(configuration_p.getGeneratorParameters().values());
        workingCopy.setAttribute("generator_parameters", map);
        HashMap<String, String> cadence = new HashMap<String, String>();
        CodeManagerCadenceLaunchConfiguration cadenceConfig = this.configuration.getCodeManagerCadenceLaunchConfiguration();
        WorkflowActivityParameter wParams = cadenceConfig.getBeforeStrategyActivities();
        String key = "org.polarsys.kitalpha.composer.core.workflow.beforestrategy";
        this.createCadenceItem(wParams, key, cadence);
        wParams = cadenceConfig.getBeforeRefineryActivities();
        key = "org.polarsys.kitalpha.composer.core.workflow.beforerefinery";
        this.createCadenceItem(wParams, key, cadence);
        wParams = cadenceConfig.getBeforeGenerationActivities();
        key = "org.polarsys.kitalpha.composer.core.workflow.beforegeneration";
        this.createCadenceItem(wParams, key, cadence);
        wParams = cadenceConfig.getAfterGenerationActivities();
        key = "org.polarsys.kitalpha.composer.core.workflow.aftergeneration";
        this.createCadenceItem(wParams, key, cadence);
        workingCopy.setAttribute("paramActivities", cadence);
        workingCopy.setAttribute("libraries_list", this.profile.getLibraries());
        workingCopy.doSave();
    }

    private void createCadenceItem(WorkflowActivityParameter wParams, String key, HashMap<String, String> cadence) {
        Set activities = wParams.getActivitiesID();
        String value = this.getParameters(wParams, activities);
        cadence.put(key, value);
    }

    ILaunchConfiguration createLaunchConfiguration(String name) throws Exception {
        ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType type = manager.getLaunchConfigurationType(ID_COMPOSER_LAUNCH_CONFIG);
        ILaunchConfiguration[] configurations = manager.getLaunchConfigurations(type);
        int i = 0;
        while (i < configurations.length) {
            ILaunchConfiguration configuration = configurations[i];
            if (configuration.getName().equals(name)) {
                configuration.delete();
                break;
            }
            ++i;
        }
        ILaunchConfigurationWorkingCopy workingCopy = type.newInstance(null, name);
        workingCopy.doSave();
        return workingCopy;
    }

    public String getParameters(WorkflowActivityParameter _params, Set<String> activities) {
        String value = "";
        String result = "";
        for (String actId : activities) {
            ActivityParameters actParam = _params.getActivityParameters(actId);
            value = String.valueOf(actId) + PARAMETER_SEPARATOR;
            if (actParam == null) continue;
            for (GenericParameter p : actParam.getParameters()) {
                value = String.valueOf(value) + p.getName() + "=" + p.getValue() + ",";
            }
            value = String.valueOf(value.substring(0, value.length() - PARAMETER_SEPARATOR.length())) + ";";
            result = String.valueOf(result) + value;
        }
        return result;
    }
}

