/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.concurrent.spec.ContextService.tx;

import ee.jakarta.tck.concurrent.framework.TestClient;
import ee.jakarta.tck.concurrent.framework.junit.anno.Assertion;
import ee.jakarta.tck.concurrent.framework.junit.anno.Common;
import ee.jakarta.tck.concurrent.framework.junit.anno.TestName;
import ee.jakarta.tck.concurrent.framework.junit.anno.Web;
import java.net.URL;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.RunAsClient;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;

@Web
@RunAsClient
@Common(value={Common.PACKAGE.TRANSACTION})
public class TransactionTests
extends TestClient {
    @ArquillianResource
    private URL baseURL;
    @TestName
    private String testname;

    @Deployment(name="TransactionTests")
    public static WebArchive createDeployment() {
        return (WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class)).addPackages(true, new Package[]{TransactionTests.class.getPackage()});
    }

    @Override
    protected String getServletPath() {
        return "TransactionServlet";
    }

    @Assertion(id="SPEC:86 SPEC:87 SPEC:88 SPEC:89 SPEC:90 SPEC:31.2 SPEC:32 SPEC:34 SPEC:8.1 SPEC:9", strategy="Get UserTransaction in Servlet and insert 2 row data. Create a proxy with Transaction property TransactionOfExecuteThread. Invoke proxy in Servlet. In proxy, insert 1 row data commit in Servlet. Expect insert actions in servlet and in proxy will be committed.")
    public void testTransactionOfExecuteThreadAndCommit() {
        this.runTest(this.baseURL, this.testname);
    }

    @Assertion(id="SPEC:86 SPEC:87 SPEC:88 SPEC:89 SPEC:90 SPEC:31.2 SPEC:32 SPEC:34 SPEC:8.1 SPEC:9", strategy="Get UserTransaction in Servlet and insert 2 row data. Create a proxy with Transaction property TransactionOfExecuteThread. Invoke proxy in Servlet. In proxy, insert 1 row data rollback in Servlet. Expect insert actions in servlet and in proxy will be roll backed.")
    public void testTransactionOfExecuteThreadAndRollback() {
        this.runTest(this.baseURL, this.testname);
    }

    @Assertion(id="SPEC:86 SPEC:87 SPEC:88 SPEC:89 SPEC:90 SPEC:31.2 SPEC:32 SPEC:34 SPEC:8.1 SPEC:9", strategy="Get UserTransaction in Servlet and insert 2 row data. Create a proxy with Transaction property SUSPEND. Invoke proxy in Servlet. In proxy, get UserTransaction then insert 1 row data and commit Rollback in Servlet. Expect insert action in servlet will be roll backed and insert action in proxy will be committed.")
    public void testSuspendAndCommit() {
        this.runTest(this.baseURL, this.testname);
    }

    @Assertion(id="SPEC:86 SPEC:87 SPEC:88 SPEC:89 SPEC:90 SPEC:31.2 SPEC:32 SPEC:34 SPEC:8.1 SPEC:9", strategy="Get UserTransaction in Servlet and insert 2 row data. Create a proxy with Transaction property SUSPEND. Invoke proxy in Servlet. In proxy, get UserTransaction then insert 1 row data and rollback Commit in Servlet. Expect insert action in servlet will be committed and insert action in proxy will be roll backed.")
    public void testSuspendAndRollback() {
        this.runTest(this.baseURL, this.testname);
    }

    @Assertion(id="SPEC:86; SPEC:87; SPEC:88; SPEC:89; SPEC:90; SPEC:91; SPEC:31.2; SPEC:32; SPEC:34; SPEC:8.1; SPEC:9", strategy="Get UserTransaction in Servlet and insert 2 row data. Create a proxy with default Transaction property. Invoke proxy in Servlet. In proxy, get UserTransaction then insert 1 row data and commit Rollback in Servlet. Expect insert action in servlet will be roll backed and insert action in proxy will be committed.")
    public void testDefaultAndCommit() {
        this.runTest(this.baseURL, this.testname);
    }
}

