/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.concurrent.framework.junit.extensions;

import ee.jakarta.tck.concurrent.framework.junit.anno.Assertion;
import ee.jakarta.tck.concurrent.framework.junit.anno.Challenge;
import ee.jakarta.tck.concurrent.framework.junit.anno.TestName;
import java.lang.reflect.Method;
import java.util.Optional;
import java.util.logging.Logger;
import java.util.stream.Stream;
import org.junit.jupiter.api.extension.AfterTestExecutionCallback;
import org.junit.jupiter.api.extension.BeforeTestExecutionCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.TestWatcher;

public class AssertionExtension
implements TestWatcher,
BeforeTestExecutionCallback,
AfterTestExecutionCallback {
    private static final Logger log = Logger.getLogger(AssertionExtension.class.getCanonicalName());
    private static final String nl = System.lineSeparator();

    public void testFailed(ExtensionContext context, Throwable cause) {
        Method testMethod = context.getRequiredTestMethod();
        Assertion instance = testMethod.getAnnotation(Assertion.class);
        if (instance != null) {
            log.warning(testMethod.getName() + " failed " + nl + " @Assertion.ids: " + instance.id() + nl + " @Assertion.strategy: " + instance.strategy() + nl + " Throwable.cause: " + cause.getLocalizedMessage());
        }
    }

    public void testAborted(ExtensionContext context, Throwable cause) {
        Method testMethod = context.getRequiredTestMethod();
        Assertion instance = testMethod.getAnnotation(Assertion.class);
        if (instance != null) {
            log.warning(testMethod.getName() + " was aborted " + nl + " @Assertion.ids: " + instance.id() + nl + " @Assertion.strategy: " + instance.strategy() + nl + " Throwable.cause: " + cause.getLocalizedMessage());
        }
    }

    public void testDisabled(ExtensionContext context, Optional<String> reason) {
        Challenge challenge;
        Method testMethod = context.getRequiredTestMethod();
        Assertion instance = testMethod.getAnnotation(Assertion.class);
        boolean isChallenge = testMethod.isAnnotationPresent(Challenge.class);
        Challenge challenge2 = challenge = isChallenge ? testMethod.getAnnotation(Challenge.class) : null;
        if (instance != null) {
            log.warning(testMethod.getName() + " is disabled" + nl + " @Assertion.id: #" + instance.id() + nl + " @Assertion.strategy: " + instance.strategy() + nl + (isChallenge ? " @Challenge.issue:" + challenge.link() + nl + " @Challenge.version: " + challenge.version() : " @Disabled.reason:" + reason.get()));
        }
    }

    public void beforeTestExecution(ExtensionContext context) throws Exception {
        log.info(">>> Begin test: " + context.getDisplayName());
        this.injectTestName(context, context.getRequiredTestMethod().getName());
    }

    public void afterTestExecution(ExtensionContext context) throws Exception {
        log.info("<<< End test: " + context.getDisplayName());
        this.injectTestName(context, null);
    }

    private void injectTestName(ExtensionContext context, String testname) {
        Class testClass = context.getRequiredTestClass();
        Stream.of(testClass.getDeclaredFields()).filter(field -> field.isAnnotationPresent(TestName.class)).forEach(field -> {
            field.setAccessible(true);
            try {
                field.set(context.getRequiredTestInstance(), testname);
            }
            catch (Exception e) {
                log.warning("Unable to set TestName field on test class: " + testClass.getCanonicalName() + " Error:" + e.getLocalizedMessage());
            }
        });
    }
}

