/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.concurrent.api.LastExecution;

import ee.jakarta.tck.concurrent.api.LastExecution.LogicDrivenTrigger;
import ee.jakarta.tck.concurrent.common.fixed.counter.CounterCallableTask;
import ee.jakarta.tck.concurrent.common.fixed.counter.CounterRunnableTask;
import ee.jakarta.tck.concurrent.common.fixed.counter.StaticCounter;
import ee.jakarta.tck.concurrent.framework.TestConstants;
import ee.jakarta.tck.concurrent.framework.junit.anno.Assertion;
import ee.jakarta.tck.concurrent.framework.junit.anno.Common;
import ee.jakarta.tck.concurrent.framework.junit.anno.TestName;
import ee.jakarta.tck.concurrent.framework.junit.anno.Web;
import jakarta.annotation.Resource;
import jakarta.enterprise.concurrent.ManagedExecutors;
import jakarta.enterprise.concurrent.ManagedScheduledExecutorService;
import jakarta.enterprise.concurrent.Trigger;
import java.util.HashMap;
import java.util.concurrent.Callable;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.BeforeEach;

@Web
@Common(value={Common.PACKAGE.FIXED_COUNTER})
public class LastExecutionTests {
    public static final String IDENTITY_NAME_TEST_ID = "lastExecutionGetIdentityNameTest";
    @TestName
    private String testname;
    @Resource(lookup="java:comp/DefaultManagedScheduledExecutorService")
    private ManagedScheduledExecutorService scheduledExecutor;

    @Deployment(name="LastExecutionTests")
    public static WebArchive createDeployment() {
        return (WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class)).addPackages(true, new Package[]{LastExecutionTests.class.getPackage()});
    }

    @BeforeEach
    public void reset() {
        StaticCounter.reset();
    }

    @Assertion(id="JAVADOC:15", strategy="The name or ID of the identifiable object, as specified in the ManagedTask#IDENTITY_NAME execution property of the task if it also implements the ManagedTask interface.")
    public void lastExecutionGetIdentityNameTest() {
        HashMap<String, String> executionProperties = new HashMap<String, String>();
        executionProperties.put("jakarta.enterprise.concurrent.IDENTITY_NAME", IDENTITY_NAME_TEST_ID);
        this.scheduledExecutor.schedule(ManagedExecutors.managedTask((Runnable)new CounterRunnableTask(), executionProperties, null), (Trigger)new LogicDrivenTrigger(TestConstants.pollInterval.toMillis(), this.testname));
        StaticCounter.waitTill(2, "Got wrong identity name. See server log for more details.");
    }

    @Assertion(id="JAVADOC:16", strategy="Result of the last execution.")
    public void lastExecutionGetResultRunnableTest() {
        this.scheduledExecutor.schedule(ManagedExecutors.managedTask((Runnable)new CounterRunnableTask(), null, null), (Trigger)new LogicDrivenTrigger(TestConstants.pollInterval.toMillis(), this.testname));
        StaticCounter.waitTill(2, "Got wrong last execution result. See server log for more details.");
    }

    @Assertion(id="JAVADOC:16", strategy="Result of the last execution.")
    public void lastExecutionGetResultCallableTest() {
        this.scheduledExecutor.schedule(ManagedExecutors.managedTask((Callable)new CounterCallableTask(), null, null), (Trigger)new LogicDrivenTrigger(TestConstants.pollInterval.toMillis(), this.testname));
        StaticCounter.waitTill(2, "Got wrong last execution result. See server log for more details.");
    }

    @Assertion(id="JAVADOC:17 JAVADOC:18 JAVADOC:19", strategy="The last time in which the task was completed.")
    public void lastExecutionGetRunningTimeTest() {
        this.scheduledExecutor.schedule(ManagedExecutors.managedTask((Runnable)new CounterRunnableTask(TestConstants.pollInterval), null, null), (Trigger)new LogicDrivenTrigger(TestConstants.pollInterval.toMillis(), this.testname));
        StaticCounter.waitTill(2, "Got wrong last execution result. See server log for more details.");
    }
}

