/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api;

import java.util.Comparator;
import java.util.concurrent.atomic.AtomicLongArray;
import org.assertj.core.annotation.CheckReturnValue;
import org.assertj.core.api.AbstractEnumerableAssert;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.data.Index;
import org.assertj.core.internal.ComparatorBasedComparisonStrategy;
import org.assertj.core.internal.LongArrays;
import org.assertj.core.util.Arrays;
import org.assertj.core.util.VisibleForTesting;

public class AtomicLongArrayAssert
extends AbstractEnumerableAssert<AtomicLongArrayAssert, AtomicLongArray, Long> {
    @VisibleForTesting
    protected LongArrays arrays = LongArrays.instance();
    private long[] array;

    public AtomicLongArrayAssert(AtomicLongArray actual) {
        super(actual, AtomicLongArrayAssert.class);
        this.array = Arrays.array(actual);
    }

    @Override
    public void isNullOrEmpty() {
        if (this.actual == null) {
            return;
        }
        this.isEmpty();
    }

    @Override
    public void isEmpty() {
        this.arrays.assertEmpty(this.info, this.array);
    }

    @Override
    public AtomicLongArrayAssert isNotEmpty() {
        this.arrays.assertNotEmpty(this.info, this.array);
        return (AtomicLongArrayAssert)this.myself;
    }

    public AtomicLongArrayAssert hasArray(long[] expected) {
        this.arrays.assertContainsExactly(this.info, this.array, expected);
        return (AtomicLongArrayAssert)this.myself;
    }

    @Override
    public AtomicLongArrayAssert hasSize(int expected) {
        this.arrays.assertHasSize(this.info, this.array, expected);
        return (AtomicLongArrayAssert)this.myself;
    }

    @Override
    public AtomicLongArrayAssert hasSizeGreaterThan(int boundary) {
        this.arrays.assertHasSizeGreaterThan(this.info, this.array, boundary);
        return (AtomicLongArrayAssert)this.myself;
    }

    @Override
    public AtomicLongArrayAssert hasSizeGreaterThanOrEqualTo(int boundary) {
        this.arrays.assertHasSizeGreaterThanOrEqualTo(this.info, this.array, boundary);
        return (AtomicLongArrayAssert)this.myself;
    }

    @Override
    public AtomicLongArrayAssert hasSizeLessThan(int boundary) {
        this.arrays.assertHasSizeLessThan(this.info, this.array, boundary);
        return (AtomicLongArrayAssert)this.myself;
    }

    @Override
    public AtomicLongArrayAssert hasSizeLessThanOrEqualTo(int boundary) {
        this.arrays.assertHasSizeLessThanOrEqualTo(this.info, this.array, boundary);
        return (AtomicLongArrayAssert)this.myself;
    }

    @Override
    public AtomicLongArrayAssert hasSizeBetween(int lowerBoundary, int higherBoundary) {
        this.arrays.assertHasSizeBetween(this.info, this.array, lowerBoundary, higherBoundary);
        return (AtomicLongArrayAssert)this.myself;
    }

    @Override
    public AtomicLongArrayAssert hasSameSizeAs(Iterable<?> other) {
        this.arrays.assertHasSameSizeAs((AssertionInfo)this.info, this.array, other);
        return (AtomicLongArrayAssert)this.myself;
    }

    public AtomicLongArrayAssert contains(long ... values) {
        this.arrays.assertContains(this.info, this.array, values);
        return (AtomicLongArrayAssert)this.myself;
    }

    public AtomicLongArrayAssert containsOnly(long ... values) {
        this.arrays.assertContainsOnly(this.info, this.array, values);
        return (AtomicLongArrayAssert)this.myself;
    }

    public AtomicLongArrayAssert containsOnlyOnce(long ... values) {
        this.arrays.assertContainsOnlyOnce(this.info, this.array, values);
        return (AtomicLongArrayAssert)this.myself;
    }

    public AtomicLongArrayAssert containsSequence(long ... sequence) {
        this.arrays.assertContainsSequence(this.info, this.array, sequence);
        return (AtomicLongArrayAssert)this.myself;
    }

    public AtomicLongArrayAssert containsSubsequence(long ... subsequence) {
        this.arrays.assertContainsSubsequence(this.info, this.array, subsequence);
        return (AtomicLongArrayAssert)this.myself;
    }

    public AtomicLongArrayAssert contains(long value, Index index) {
        this.arrays.assertContains(this.info, this.array, value, index);
        return (AtomicLongArrayAssert)this.myself;
    }

    public AtomicLongArrayAssert doesNotContain(long ... values) {
        this.arrays.assertDoesNotContain(this.info, this.array, values);
        return (AtomicLongArrayAssert)this.myself;
    }

    public AtomicLongArrayAssert doesNotContain(long value, Index index) {
        this.arrays.assertDoesNotContain(this.info, this.array, value, index);
        return (AtomicLongArrayAssert)this.myself;
    }

    public AtomicLongArrayAssert doesNotHaveDuplicates() {
        this.arrays.assertDoesNotHaveDuplicates(this.info, this.array);
        return (AtomicLongArrayAssert)this.myself;
    }

    public AtomicLongArrayAssert startsWith(long ... sequence) {
        this.arrays.assertStartsWith(this.info, this.array, sequence);
        return (AtomicLongArrayAssert)this.myself;
    }

    public AtomicLongArrayAssert endsWith(long ... sequence) {
        this.arrays.assertEndsWith(this.info, this.array, sequence);
        return (AtomicLongArrayAssert)this.myself;
    }

    public AtomicLongArrayAssert isSorted() {
        this.arrays.assertIsSorted(this.info, this.array);
        return (AtomicLongArrayAssert)this.myself;
    }

    public AtomicLongArrayAssert isSortedAccordingTo(Comparator<? super Long> comparator) {
        this.arrays.assertIsSortedAccordingToComparator(this.info, this.array, comparator);
        return (AtomicLongArrayAssert)this.myself;
    }

    @Override
    @CheckReturnValue
    public AtomicLongArrayAssert usingElementComparator(Comparator<? super Long> customComparator) {
        this.arrays = new LongArrays(new ComparatorBasedComparisonStrategy(customComparator));
        return (AtomicLongArrayAssert)this.myself;
    }

    @Override
    public AtomicLongArrayAssert usingDefaultElementComparator() {
        this.arrays = LongArrays.instance();
        return (AtomicLongArrayAssert)this.myself;
    }

    public AtomicLongArrayAssert containsExactly(long ... values) {
        this.arrays.assertContainsExactly(this.info, this.array, values);
        return (AtomicLongArrayAssert)this.myself;
    }

    public AtomicLongArrayAssert containsExactlyInAnyOrder(long ... values) {
        this.arrays.assertContainsExactlyInAnyOrder(this.info, this.array, values);
        return (AtomicLongArrayAssert)this.myself;
    }

    public AtomicLongArrayAssert containsAnyOf(long ... values) {
        this.arrays.assertContainsAnyOf(this.info, this.array, values);
        return (AtomicLongArrayAssert)this.myself;
    }
}

